/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.tool;

import com.ic2additions.objects.items.tool.ItemVajra;
import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemAdvancedVajra
extends ItemVajra {
    private static final String NBT_ROOT = "adv_vajra_data";
    private static final String NBT_MODE = "Mode";
    private static final String MODE_NONE = "NONE";
    private static final String MODE_SILK = "SILK";
    private static final String MODE_AOE_3x3 = "AOE_3x3";
    private static final double EXTRA_BLOCK_COST = 1.0;

    public ItemAdvancedVajra(String name) {
        super(name);
        this.maxCharge = 100000000;
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String mode = ItemAdvancedVajra.readMode(stack);
        tooltip.add(TextFormatting.YELLOW + "Current Mode: " + TextFormatting.WHITE + ItemAdvancedVajra.label(mode));
        tooltip.add(TextFormatting.YELLOW + "Right-click to toggle");
        tooltip.add(TextFormatting.YELLOW + "Shift + Right Click to Disable");
        ItemAdvancedVajra.addModeLine(tooltip, MODE_NONE.equals(mode), "None");
        ItemAdvancedVajra.addModeLine(tooltip, MODE_SILK.equals(mode), "Silk Touch");
        ItemAdvancedVajra.addModeLine(tooltip, MODE_AOE_3x3.equals(mode), "3x3");
    }

    private static void addModeLine(List<String> tooltip, boolean active, String label) {
        tooltip.add((active ? TextFormatting.WHITE : TextFormatting.YELLOW) + " - " + label);
    }

    @Override
    public boolean func_77636_d(ItemStack stack) {
        String m = ItemAdvancedVajra.readMode(stack);
        return MODE_SILK.equals(m) || MODE_AOE_3x3.equals(m);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            String current = ItemAdvancedVajra.readMode(stack);
            String next = player.func_70093_af() ? MODE_NONE : ItemAdvancedVajra.nextMode(current);
            ItemAdvancedVajra.writeMode(stack, next);
            if (stack.func_77978_p() != null) {
                stack.func_77978_p().func_82580_o("ench");
            }
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Vajra mode: " + ItemAdvancedVajra.label(next)));
            player.field_71071_by.func_70296_d();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    private static String label(String mode) {
        if (MODE_SILK.equals(mode)) {
            return "Silk Touch";
        }
        if (MODE_AOE_3x3.equals(mode)) {
            return "3x3";
        }
        return "None";
    }

    private static String nextMode(String cur) {
        if (MODE_NONE.equals(cur)) {
            return MODE_SILK;
        }
        if (MODE_SILK.equals(cur)) {
            return MODE_AOE_3x3;
        }
        return MODE_NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        if (!MODE_SILK.equals(ItemAdvancedVajra.readMode(stack))) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, (IBlockAccess)world, pos) || !block.canHarvestBlock((IBlockAccess)world, pos, player)) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        HashMap before = new HashMap(EnchantmentHelper.func_82781_a((ItemStack)stack));
        try {
            GameType gameType;
            HashMap<Enchantment, Integer> temp = new HashMap<Enchantment, Integer>(before);
            temp.remove(Enchantments.field_185308_t);
            temp.put(Enchantments.field_185306_r, 1);
            EnchantmentHelper.func_82782_a(temp, (ItemStack)stack);
            int xp = 0;
            if (player instanceof EntityPlayerMP && (xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)(gameType = ((EntityPlayerMP)player).field_71134_c.func_73081_b()), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos)) < 0) {
                boolean bl = true;
                return bl;
            }
            block.func_176208_a(world, pos, state, player);
            if (player.field_71075_bZ.field_75098_d) {
                if (block.removedByPlayer(state, world, pos, player, false)) {
                    block.func_176206_d(world, pos, state);
                }
            } else {
                if (block.removedByPlayer(state, world, pos, player, true)) {
                    block.func_176206_d(world, pos, state);
                    block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), stack);
                    if (xp > 0) {
                        block.func_180637_b(world, pos, xp);
                    }
                }
                stack.func_179548_a(world, state, pos, player);
            }
            ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            EnchantmentHelper.func_82782_a(before, (ItemStack)stack);
        }
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, BlockPos center, EntityLivingBase entity) {
        boolean centerOk = super.func_179218_a(stack, world, state, center, entity);
        if (world.field_72995_K) {
            return centerOk;
        }
        if (!(entity instanceof EntityPlayerMP)) {
            return centerOk;
        }
        if (!MODE_AOE_3x3.equals(ItemAdvancedVajra.readMode(stack))) {
            return centerOk;
        }
        EntityPlayerMP player = (EntityPlayerMP)entity;
        RayTraceResult rt = this.func_77621_a(world, (EntityPlayer)player, false);
        EnumFacing face = rt != null && rt.field_178784_b != null ? rt.field_178784_b : player.func_174811_aO();
        double perBlockEU = this.operationEnergyCost * 1.0;
        for (BlockPos p : ItemAdvancedVajra.getAoEPlane(face, center, 1)) {
            IBlockState st;
            if (p.equals((Object)center) || world.func_175623_d(p) || (st = world.func_180495_p(p)).func_185887_b(world, p) < 0.0f || !st.func_177230_c().canHarvestBlock((IBlockAccess)world, p, (EntityPlayer)player) || this.func_150893_a(stack, st) <= 1.0f) continue;
            if (!ElectricItem.manager.use(stack, perBlockEU, (EntityLivingBase)player)) break;
            GameType gt = player.field_71134_c.func_73081_b();
            int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)gt, (EntityPlayerMP)player, (BlockPos)p);
            if (xp < 0) continue;
            Block b = st.func_177230_c();
            b.func_176208_a(world, p, st, (EntityPlayer)player);
            boolean removed = b.removedByPlayer(st, world, p, (EntityPlayer)player, !player.field_71075_bZ.field_75098_d);
            if (!removed) continue;
            b.func_176206_d(world, p, st);
            b.func_180657_a(world, (EntityPlayer)player, p, st, world.func_175625_s(p), stack);
            if (xp > 0) {
                b.func_180637_b(world, p, xp);
            }
            world.func_175718_b(2001, p, Block.func_176210_f((IBlockState)st));
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, p));
        }
        return centerOk;
    }

    private static List<BlockPos> getAoEPlane(EnumFacing face, BlockPos center, int r) {
        ArrayList<BlockPos> out = new ArrayList<BlockPos>((2 * r + 1) * (2 * r + 1));
        for (int dx = -r; dx <= r; ++dx) {
            for (int dy = -r; dy <= r; ++dy) {
                BlockPos bp;
                switch (face) {
                    case UP: 
                    case DOWN: {
                        bp = center.func_177982_a(dx, 0, dy);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        bp = center.func_177982_a(dx, dy, 0);
                        break;
                    }
                    default: {
                        bp = center.func_177982_a(0, dy, dx);
                    }
                }
                out.add(bp);
            }
        }
        return out;
    }

    @Override
    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.EPIC;
    }

    private static String readMode(ItemStack stack) {
        String m;
        NBTTagCompound root = stack.func_179543_a(NBT_ROOT);
        String string = m = root != null ? root.func_74779_i(NBT_MODE) : "";
        if (m == null || m.isEmpty()) {
            return MODE_NONE;
        }
        return m;
    }

    private static void writeMode(ItemStack stack, String mode) {
        NBTTagCompound root = stack.func_190925_c(NBT_ROOT);
        root.func_74778_a(NBT_MODE, mode);
    }
}

