/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.objects.items.tool;

import com.ic2additions.init.IC2AdditionsCreativeTabs;
import com.ic2additions.init.ItemInit;
import ic2.api.item.ElectricItem;
import ic2.core.item.tool.HarvestLevel;
import ic2.core.item.tool.ItemElectricTool;
import ic2.core.item.tool.ToolClass;
import ic2.core.util.StackUtil;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class ItemVajra
extends ItemElectricTool {
    public static boolean accurateEnabled = true;
    private static final String NBT_ACCURATE = "accurate";
    private static final String MODE_NONE = "NONE";
    private static final String MODE_SILK = "SILK";

    public ItemVajra(String name) {
        super(null, 3333, HarvestLevel.Iridium, EnumSet.of(ToolClass.Pickaxe, ToolClass.Shovel, ToolClass.Axe));
        this.setRegistryName(name);
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.maxCharge = 10000000;
        this.transferLimit = 60000;
        this.tier = 3;
        this.field_77865_bY = 25.0f;
        this.field_77864_a = 20000.0f;
        this.func_77637_a(IC2AdditionsCreativeTabs.tab);
        ItemInit.ITEMS.add((Item)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        String mode = ItemVajra.readMode(stack);
        tooltip.add(TextFormatting.YELLOW + "Current Mode: " + TextFormatting.WHITE + ItemVajra.label(mode));
        tooltip.add(TextFormatting.YELLOW + "Right-click to toggle");
        tooltip.add(TextFormatting.YELLOW + "Shift + Right Click to Disable");
        ItemVajra.addModeLine(tooltip, MODE_NONE.equals(mode), "None");
        ItemVajra.addModeLine(tooltip, MODE_SILK.equals(mode), "Silk Touch");
    }

    private static void addModeLine(List<String> tooltip, boolean active, String label) {
        tooltip.add((active ? TextFormatting.WHITE : TextFormatting.YELLOW) + " - " + label);
    }

    public boolean func_77636_d(ItemStack stack) {
        return MODE_SILK.equals(ItemVajra.readMode(stack));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            String current = ItemVajra.readMode(stack);
            String next = player.func_70093_af() ? MODE_NONE : (MODE_NONE.equals(current) ? MODE_SILK : MODE_NONE);
            ItemVajra.writeMode(stack, next);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GOLD + "Vajra mode: " + ItemVajra.label(next)));
            player.field_71071_by.func_70296_d();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    private static String label(String mode) {
        return MODE_SILK.equals(mode) ? "Silk Touch" : "None";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (!accurateEnabled) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        if (!MODE_SILK.equals(ItemVajra.readMode(stack))) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        World world = player.field_70170_p;
        if (world.field_72995_K) {
            return true;
        }
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return super.onBlockStartBreak(stack, pos, player);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        boolean didHarvest = false;
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>(EnchantmentHelper.func_82781_a((ItemStack)stack));
        enchants.remove(Enchantments.field_185308_t);
        enchants.put(Enchantments.field_185306_r, 1);
        EnchantmentHelper.func_82782_a(enchants, (ItemStack)stack);
        try {
            if (!block.isAir(state, (IBlockAccess)world, pos) && block.canHarvestBlock((IBlockAccess)world, pos, player)) {
                GameType gameType;
                int xp = 0;
                if (player instanceof EntityPlayerMP && (xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)(gameType = ((EntityPlayerMP)player).field_71134_c.func_73081_b()), (EntityPlayerMP)((EntityPlayerMP)player), (BlockPos)pos)) < 0) {
                    boolean bl = true;
                    return bl;
                }
                block.func_176208_a(world, pos, state, player);
                if (player.field_71075_bZ.field_75098_d) {
                    if (block.removedByPlayer(state, world, pos, player, false)) {
                        block.func_176206_d(world, pos, state);
                    }
                } else {
                    if (block.removedByPlayer(state, world, pos, player, true)) {
                        block.func_176206_d(world, pos, state);
                        block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), stack);
                        if (xp > 0) {
                            block.func_180637_b(world, pos, xp);
                        }
                    }
                    stack.func_179548_a(world, state, pos, player);
                }
                ElectricItem.manager.use(stack, this.operationEnergyCost, (EntityLivingBase)player);
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
                }
                didHarvest = true;
            }
        }
        finally {
            HashMap after = new HashMap(EnchantmentHelper.func_82781_a((ItemStack)stack));
            after.remove(Enchantments.field_185306_r);
            EnchantmentHelper.func_82782_a(after, (ItemStack)stack);
        }
        return didHarvest;
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return state.func_177230_c() != Blocks.field_150357_h;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker instanceof EntityPlayer) {
            if (ElectricItem.manager.use(stack, this.operationEnergyCost * 2.0, attacker)) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 25.0f);
            } else {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)), 1.0f);
            }
        }
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    private static String readMode(ItemStack stack) {
        return ItemVajra.getNbt(stack).func_74767_n(NBT_ACCURATE) ? MODE_SILK : MODE_NONE;
    }

    private static void writeMode(ItemStack stack, String mode) {
        ItemVajra.getNbt(stack).func_74757_a(NBT_ACCURATE, MODE_SILK.equals(mode));
    }

    private static NBTTagCompound getNbt(ItemStack stack) {
        return StackUtil.getOrCreateNbtData((ItemStack)stack);
    }
}

