/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.recipes.breeding;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;

public class BreederReactorRecipesHandler {
    private static final List<Recipe> RECIPES = new ArrayList<Recipe>();

    private BreederReactorRecipesHandler() {
    }

    public static synchronized void add(ItemStack input, int totalEU, int totalTime, ItemStack output) {
        Objects.requireNonNull(input, "input");
        Objects.requireNonNull(output, "output");
        if (input.func_190926_b() || output.func_190926_b() || totalEU <= 0 || totalTime <= 0) {
            return;
        }
        RECIPES.add(new Recipe(input, totalEU, totalTime, output));
    }

    public static synchronized Recipe find(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return null;
        }
        for (Recipe r : RECIPES) {
            if (stack.func_77973_b() != r.input.func_77973_b() || stack.func_77960_j() != r.input.func_77960_j()) continue;
            return r;
        }
        return null;
    }

    public static synchronized int getRecipeCount() {
        return RECIPES.size();
    }

    public static synchronized List<Recipe> getAllRecipes() {
        return new ArrayList<Recipe>(RECIPES);
    }

    public static final class Recipe {
        public final ItemStack input;
        public final int totalEU;
        public final int totalTime;
        public final ItemStack output;

        public Recipe(ItemStack input, int totalEU, int totalTime, ItemStack output) {
            this.input = input.func_77946_l();
            this.totalEU = totalEU;
            this.totalTime = totalTime;
            this.output = output.func_77946_l();
        }
    }
}

