/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.tilentity;

import com.ic2additions.recipes.breeding.BreederReactorRecipesHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.audio.AudioSource;
import ic2.core.audio.PositionSpec;
import ic2.core.block.IInventorySlotHolder;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityBreederReactor
extends TileEntityInventory
implements IEnergySink,
IHasGui,
IGuiValueProvider {
    public final InvSlot input;
    public final InvSlotOutput output;
    private static final int DEFAULT_SINK_TIER = 12;
    @GuiSynced
    private int ticksRemaining;
    private boolean addedToEnet;
    @GuiSynced
    private double energyBuffer;
    @GuiSynced
    private int progressTicks;
    @GuiSynced
    private int currentRecipeTotalTime;
    @GuiSynced
    private ItemStack currentInput = ItemStack.field_190927_a;
    private BreederReactorRecipesHandler.Recipe currentRecipe;
    @GuiSynced
    private String currentInputName = "-";
    @GuiSynced
    private String currentOutputName = "-";
    @GuiSynced
    private int currentRecipeCostEu = 0;
    public AudioSource audioSourceMain;
    private static final String AUDIO_PATH = "Generators/NuclearReactor/NuclearReactorLoop.ogg";

    public TileEntityBreederReactor() {
        this.input = new InvSlot((IInventorySlotHolder)this, "input", InvSlot.Access.I, 1, InvSlot.InvSide.TOP);
        this.output = new InvSlotOutput((IInventorySlotHolder)this, "output", 1);
    }

    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    protected void onUnloaded() {
        if (IC2.platform.isRendering()) {
            IC2.audioManager.removeSources((Object)this);
            this.audioSourceMain = null;
        }
        if (IC2.platform.isSimulating() && this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
        super.onUnloaded();
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean active = this.getActive();
        boolean dirty = false;
        if (this.currentRecipe == null) {
            ItemStack in = this.input.get();
            BreederReactorRecipesHandler.Recipe recipe = BreederReactorRecipesHandler.find(in);
            if (recipe != null && this.canAcceptOutput(recipe.output)) {
                if (this.energyBuffer >= (double)recipe.totalEU) {
                    in.func_190918_g(1);
                    if (in.func_190916_E() <= 0) {
                        this.input.clear();
                    }
                    this.energyBuffer -= (double)recipe.totalEU;
                    this.currentRecipe = recipe;
                    this.currentInput = recipe.input.func_77946_l();
                    this.progressTicks = 0;
                    this.ticksRemaining = this.currentRecipeTotalTime = recipe.totalTime;
                    this.currentInputName = recipe.input.func_82833_r();
                    this.currentOutputName = recipe.output.func_82833_r();
                    this.currentRecipeCostEu = recipe.totalEU;
                    active = true;
                    dirty = true;
                }
            } else {
                this.currentInputName = "-";
                this.currentOutputName = "-";
                this.currentRecipeCostEu = 0;
                this.currentRecipeTotalTime = 0;
                this.ticksRemaining = 0;
                active = false;
            }
        }
        if (this.currentRecipe != null) {
            ++this.progressTicks;
            this.ticksRemaining = Math.max(0, this.currentRecipeTotalTime - this.progressTicks);
            active = true;
            dirty = true;
            if (this.progressTicks >= this.currentRecipeTotalTime) {
                this.finishRecipe();
                active = false;
                dirty = true;
            }
        }
        if (this.getActive() != active) {
            this.setActive(active);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (dirty) {
            this.func_70296_d();
        }
    }

    public void onNetworkUpdate(String field) {
        if ("active".equals(field)) {
            if (this.getActive()) {
                if (this.audioSourceMain == null) {
                    this.audioSourceMain = IC2.audioManager.createSource((Object)this, PositionSpec.Center, AUDIO_PATH, true, false, IC2.audioManager.getDefaultVolume());
                }
                if (this.audioSourceMain != null) {
                    this.audioSourceMain.play();
                }
            } else if (this.audioSourceMain != null) {
                this.audioSourceMain.stop();
            }
        }
        super.onNetworkUpdate(field);
    }

    @Override
    public double injectEnergy(EnumFacing from, double amount, double voltage) {
        this.energyBuffer += amount;
        return 0.0;
    }

    @Override
    public double getDemandedEnergy() {
        ItemStack in = this.input.get();
        BreederReactorRecipesHandler.Recipe recipe = BreederReactorRecipesHandler.find(in);
        if (recipe == null) {
            return 0.0;
        }
        if (this.canAcceptOutput(recipe.output) && this.currentRecipe == null) {
            return Math.max(0.0, (double)recipe.totalEU - this.energyBuffer);
        }
        return 0.0;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    @Override
    public int getSinkTier() {
        return 12;
    }

    private void finishRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        if (this.canAcceptOutput(this.currentRecipe.output)) {
            this.output.add(this.currentRecipe.output);
        }
        this.currentRecipe = null;
        this.currentInput = ItemStack.field_190927_a;
        this.progressTicks = 0;
        this.currentRecipeTotalTime = 0;
        this.ticksRemaining = 0;
        this.currentInputName = "-";
        this.currentOutputName = "-";
        this.currentRecipeCostEu = 0;
    }

    private boolean canAcceptOutput(ItemStack stack) {
        return !StackUtil.isEmpty((ItemStack)stack) && this.output.canAdd(stack);
    }

    public ContainerBase<? extends TileEntityBreederReactor> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public double getGuiValue(String key) {
        switch (key) {
            case "progress01": 
            case "time01": {
                return this.currentRecipeTotalTime <= 0 ? 0.0 : (double)this.progressTicks / (double)this.currentRecipeTotalTime;
            }
            case "progress": 
            case "time": {
                return this.currentRecipeTotalTime <= 0 ? 0.0 : (double)Math.round((double)this.progressTicks / (double)this.currentRecipeTotalTime * 100.0);
            }
            case "eut": {
                return this.energyBuffer;
            }
            case "countdownSeconds": {
                return (double)this.ticksRemaining / 20.0;
            }
        }
        return 0.0;
    }

    public double getEutNow() {
        return this.energyBuffer;
    }

    public double getProgressPercent() {
        if (this.currentRecipeTotalTime <= 0) {
            return 0.0;
        }
        return Math.round((double)this.progressTicks / (double)this.currentRecipeTotalTime * 100.0);
    }

    public double getTimeProgressPercent() {
        if (this.currentRecipeTotalTime <= 0) {
            return 0.0;
        }
        return Math.round((double)this.progressTicks / (double)this.currentRecipeTotalTime * 100.0);
    }

    public double getTime() {
        return this.getTimeProgressPercent();
    }

    public String getCurrentInputName() {
        return this.currentInputName;
    }

    public String getCurrentOutputName() {
        return this.currentOutputName;
    }

    public int getRecipeCostEu() {
        return this.currentRecipeCostEu;
    }

    public String getCountdown() {
        int seconds = this.ticksRemaining / 20;
        int minutes = seconds / 60;
        return String.format("%d:%02d", minutes, seconds %= 60);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyBuffer = nbt.func_74769_h("energyBuffer");
        this.progressTicks = nbt.func_74762_e("progressTicks");
        this.currentRecipeTotalTime = nbt.func_74762_e("currentRecipeTotalTime");
        this.ticksRemaining = nbt.func_74762_e("ticksRemaining");
        this.currentInput = new ItemStack(nbt.func_74775_l("currentInput"));
        this.currentInputName = nbt.func_74779_i("currentInputName");
        this.currentOutputName = nbt.func_74779_i("currentOutputName");
        this.currentRecipeCostEu = nbt.func_74762_e("currentRecipeCostEu");
        if (!this.currentInput.func_190926_b()) {
            this.currentRecipe = BreederReactorRecipesHandler.find(this.currentInput);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("energyBuffer", this.energyBuffer);
        nbt.func_74768_a("progressTicks", this.progressTicks);
        nbt.func_74768_a("currentRecipeTotalTime", this.currentRecipeTotalTime);
        nbt.func_74768_a("ticksRemaining", this.ticksRemaining);
        NBTTagCompound inputTag = new NBTTagCompound();
        this.currentInput.func_77955_b(inputTag);
        nbt.func_74782_a("currentInput", (NBTBase)inputTag);
        nbt.func_74778_a("currentInputName", this.currentInputName);
        nbt.func_74778_a("currentOutputName", this.currentOutputName);
        nbt.func_74768_a("currentRecipeCostEu", this.currentRecipeCostEu);
        return nbt;
    }
}

