/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.tilentity;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyConductor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityCable
extends TileEntity
implements IEnergyConductor {
    public static final String NBT_NAME = "name";
    public static final String NBT_LOSS = "loss";
    public static final String NBT_CAPACITY = "capacity";
    public static final String DEFAULT_NAME = "Cable";
    public static final double DEFAULT_LOSS = 0.05;
    public static final int DEFAULT_CAPACITY = 38168;
    private boolean addedToEnergyNet = false;
    private byte connectivity = 0;
    private String displayName = "Cable";
    private double loss = 0.05;
    private int capacity = 38168;

    public void setDisplayName(String name) {
        this.displayName = name != null ? name : DEFAULT_NAME;
    }

    public void setLoss(double v) {
        this.loss = v;
    }

    public void setCapacity(int v) {
        this.capacity = v;
    }

    public byte getConnectivity() {
        return this.connectivity;
    }

    private void setConnectivity(byte value) {
        this.connectivity = value;
        if (this.field_145850_b != null) {
            IBlockState s = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, s, s, 3);
            this.func_70296_d();
        }
    }

    public void updateConnectivity() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        byte newConn = 0;
        int mask = 1;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IEnergyTile t = EnergyNet.instance.getSubTile(this.field_145850_b, this.field_174879_c.func_177972_a(dir));
            if (t != null) {
                boolean ok;
                boolean bl = ok = t instanceof IEnergyAcceptor && ((IEnergyAcceptor)t).acceptsEnergyFrom(this, dir.func_176734_d()) || t instanceof IEnergyEmitter && ((IEnergyEmitter)t).emitsEnergyTo(this, dir.func_176734_d());
                if (ok) {
                    newConn = (byte)(newConn | mask);
                }
            }
            mask <<= 1;
        }
        if (newConn != this.connectivity) {
            this.setConnectivity(newConn);
        }
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
            this.updateConnectivity();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!this.field_145850_b.field_72995_K && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
    }

    @Override
    public void update() {
    }

    @Override
    public double getConductionLoss() {
        return this.loss;
    }

    @Override
    public double getInsulationEnergyAbsorption() {
        return 2.147483647E9;
    }

    @Override
    public double getInsulationBreakdownEnergy() {
        return 9001.0;
    }

    @Override
    public double getConductorBreakdownEnergy() {
        return this.capacity + 1;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    @Override
    public void removeInsulation() {
    }

    @Override
    public void removeConductor() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b(NBT_NAME)) {
            this.displayName = nbt.func_74779_i(NBT_NAME);
        }
        if (nbt.func_74764_b(NBT_LOSS)) {
            this.loss = nbt.func_74769_h(NBT_LOSS);
        }
        if (nbt.func_74764_b(NBT_CAPACITY)) {
            this.capacity = nbt.func_74762_e(NBT_CAPACITY);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a(NBT_NAME, this.displayName);
        nbt.func_74780_a(NBT_LOSS, this.loss);
        nbt.func_74768_a(NBT_CAPACITY, this.capacity);
        return nbt;
    }
}

