/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.tilentity;

import com.ic2additions.util.EnergyStorageRF;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityEUtoRF
extends TileEntity
implements ITickable,
IEnergySink {
    private int euBuffer = 0;
    private final int maxEuBuffer = 10000;
    private final EnergyStorageRF rfStorage = new EnergyStorageRF(40000);
    private static final double CONVERSION = 4.0;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            int rfSpace;
            int euToConvert;
            int rfProduced;
            if (this.euBuffer > 0 && this.rfStorage.getEnergyStored() < this.rfStorage.getMaxEnergyStored() && (rfProduced = (int)((double)(euToConvert = Math.min(this.euBuffer, (int)((double)(rfSpace = this.rfStorage.getMaxEnergyStored() - this.rfStorage.getEnergyStored()) / 4.0))) * 4.0)) > 0) {
                this.euBuffer -= euToConvert;
                this.rfStorage.receiveEnergy(rfProduced, false);
            }
            for (EnumFacing side : EnumFacing.values()) {
                IEnergyStorage neighborEnergy;
                TileEntity neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
                if (neighbor == null || (neighborEnergy = (IEnergyStorage)neighbor.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d())) == null) continue;
                int extracted = this.rfStorage.extractEnergy(this.rfStorage.getEnergyStored(), true);
                int accepted = neighborEnergy.receiveEnergy(extracted, false);
                this.rfStorage.extractEnergy(accepted, false);
            }
        }
    }

    @Override
    public double getDemandedEnergy() {
        int rfSpace = this.rfStorage.getMaxEnergyStored() - this.rfStorage.getEnergyStored();
        int euNeeded = (int)((double)rfSpace / 4.0);
        return Math.max(0, Math.min(10000 - this.euBuffer, euNeeded));
    }

    @Override
    public int getSinkTier() {
        return 7;
    }

    @Override
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        int accepted = (int)Math.min(amount, (double)(10000 - this.euBuffer));
        this.euBuffer += accepted;
        return amount - (double)accepted;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.rfStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void onLoad() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyNet.instance.addTile(this);
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            EnergyNet.instance.removeTile(this);
        }
        super.func_145843_s();
    }

    public int getEuBuffer() {
        return this.euBuffer;
    }

    public EnergyStorageRF getRfStorage() {
        return this.rfStorage;
    }
}

