/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.tilentity;

import com.ic2additions.recipes.molecular.MolecularAssemblerRecipesHandler;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.IInventorySlotHolder;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotOutput;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.EnumSkyBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class TileEntityMolecularAssembler
extends TileEntityInventory
implements IEnergySink,
IHasGui,
IGuiValueProvider {
    public final InvSlot input = new InvSlot((IInventorySlotHolder)this, "input", InvSlot.Access.I, 1, InvSlot.InvSide.TOP);
    public final InvSlotOutput output = new InvSlotOutput((IInventorySlotHolder)this, "output", 1);
    private MolecularAssemblerRecipesHandler.Recipe current;
    @GuiSynced
    private int currentTotalEu;
    private int toConsume;
    private static final int DEFAULT_SINK_TIER = 12;
    private static final byte MAX_STARVE_WAIT = 40;
    private boolean addedToEnet;
    private double energyInThisTick;
    private double energyGivenThisTick;
    @GuiSynced
    private double lastEnergyGiven;
    @GuiSynced
    private double energyUsed;
    private byte starveWait;
    @GuiSynced
    private String currentInputName = "";
    @GuiSynced
    private String currentOutputName = "";
    @GuiSynced
    private int currentRecipeCostEu = 0;

    private static String nameOf(ItemStack s) {
        return s == null || s.func_190926_b() ? "-" : s.func_82833_r();
    }

    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    protected void onUnloaded() {
        super.onUnloaded();
        if (this.addedToEnet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    protected void updateEntityServer() {
        super.updateEntityServer();
        boolean shouldBeActive = this.getActive();
        boolean invChanged = false;
        if (this.current == null) {
            ItemStack in = this.input.get();
            MolecularAssemblerRecipesHandler.Recipe r = MolecularAssemblerRecipesHandler.find(in);
            if (r != null && this.canAcceptOutput(r.output)) {
                int n = this.toConsume = r.input.func_190916_E() > 0 ? r.input.func_190916_E() : 1;
                if (in.func_190916_E() >= this.toConsume) {
                    in.func_190918_g(this.toConsume);
                    if (in.func_190916_E() <= 0) {
                        this.input.clear();
                    }
                    this.current = r;
                    this.currentTotalEu = r.totalEU;
                    this.energyUsed = 0.0;
                    this.currentInputName = TileEntityMolecularAssembler.nameOf(r.input);
                    this.currentOutputName = TileEntityMolecularAssembler.nameOf(r.output);
                    this.currentRecipeCostEu = r.totalEU;
                    invChanged = true;
                    shouldBeActive = true;
                } else {
                    shouldBeActive = false;
                    this.previewDisplayFromSlot();
                }
            } else {
                shouldBeActive = false;
                this.previewDisplayFromSlot();
            }
        } else {
            shouldBeActive = true;
        }
        this.lastEnergyGiven = this.energyGivenThisTick;
        this.energyGivenThisTick = 0.0;
        if (shouldBeActive && this.current != null) {
            if (this.energyInThisTick <= 0.0) {
                if (this.starveWait < 40) {
                    this.starveWait = (byte)(this.starveWait + 1);
                } else {
                    shouldBeActive = false;
                }
            } else {
                this.starveWait = 0;
                double need = this.getDemandedEnergy();
                if (need > 0.0 && this.energyInThisTick >= need) {
                    this.energyInThisTick -= need;
                    this.energyUsed += need;
                    this.finishWork();
                    invChanged = true;
                    this.previewDisplayFromSlot();
                } else {
                    this.energyUsed += this.energyInThisTick;
                    this.energyInThisTick = 0.0;
                }
            }
        }
        if (this.getActive() != shouldBeActive) {
            this.setActive(shouldBeActive);
            this.field_145850_b.func_180500_c(EnumSkyBlock.BLOCK, this.field_174879_c);
        }
        if (invChanged) {
            this.func_70296_d();
        }
    }

    private boolean canAcceptOutput(ItemStack stack) {
        return !StackUtil.isEmpty((ItemStack)stack) && this.output.canAdd(stack);
    }

    private void finishWork() {
        if (this.current == null) {
            return;
        }
        this.output.add(this.current.output);
        this.current = null;
        this.currentTotalEu = 0;
        this.energyUsed = 0.0;
        this.toConsume = 0;
        this.currentInputName = "";
        this.currentOutputName = "";
        this.currentRecipeCostEu = 0;
    }

    private void previewDisplayFromSlot() {
        ItemStack in = this.input.get();
        if (in == null || in.func_190926_b()) {
            this.currentInputName = "";
            this.currentOutputName = "";
            this.currentRecipeCostEu = 0;
            return;
        }
        MolecularAssemblerRecipesHandler.Recipe r = MolecularAssemblerRecipesHandler.find(in);
        this.currentInputName = TileEntityMolecularAssembler.nameOf(in);
        this.currentOutputName = r != null ? TileEntityMolecularAssembler.nameOf(r.output) : "-";
        this.currentRecipeCostEu = r != null ? r.totalEU : 0;
    }

    public ContainerBase<? extends TileEntityMolecularAssembler> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public double getGuiValue(String key) {
        switch (key) {
            case "progress": {
                return this.currentTotalEu <= 0 ? 0.0 : this.energyUsed / (double)this.currentTotalEu * 100.0;
            }
            case "progress01": {
                return this.currentTotalEu <= 0 ? 0.0 : this.energyUsed / (double)this.currentTotalEu;
            }
            case "eut": {
                return this.lastEnergyGiven;
            }
        }
        return 0.0;
    }

    public String getCurrentInputName() {
        return this.currentInputName == null ? "" : this.currentInputName;
    }

    public String getCurrentOutputName() {
        return this.currentOutputName == null ? "" : this.currentOutputName;
    }

    public int getRecipeCostEu() {
        return this.currentRecipeCostEu;
    }

    public double getProgress01() {
        return this.currentTotalEu <= 0 ? 0.0 : this.energyUsed / (double)this.currentTotalEu;
    }

    public double getProgressPercent() {
        return this.currentTotalEu <= 0 ? 0.0 : (double)Math.round(this.energyUsed / (double)this.currentTotalEu * 100.0);
    }

    public double getEutNow() {
        return (double)Math.round(this.lastEnergyGiven * 10.0) / 10.0;
    }

    public int getTotalEu() {
        return this.currentTotalEu;
    }

    @Override
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return true;
    }

    @Override
    public int getSinkTier() {
        return 12;
    }

    @Override
    public double getDemandedEnergy() {
        if (this.current == null || this.currentTotalEu <= 0) {
            this.lastEnergyGiven = 0.0;
            return 0.0;
        }
        return Math.max(0.0, (double)this.currentTotalEu - this.energyUsed);
    }

    @Override
    public double injectEnergy(EnumFacing from, double amount, double voltage) {
        this.energyGivenThisTick += amount;
        double need = this.getDemandedEnergy();
        if (need <= 0.0) {
            return amount;
        }
        if (amount <= need) {
            this.energyInThisTick += amount;
            return 0.0;
        }
        this.energyInThisTick += need;
        return amount - need;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.energyUsed = nbt.func_74769_h("energyUsed");
        this.currentTotalEu = nbt.func_74762_e("currentTotalEu");
        this.currentInputName = nbt.func_74779_i("currentInputName");
        this.currentOutputName = nbt.func_74779_i("currentOutputName");
        this.currentRecipeCostEu = nbt.func_74762_e("currentRecipeCostEu");
        if (this.currentTotalEu > 0) {
            this.current = new MolecularAssemblerRecipesHandler.Recipe(ItemStack.field_190927_a, this.currentTotalEu, ItemStack.field_190927_a);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74780_a("energyUsed", this.energyUsed);
        nbt.func_74768_a("currentTotalEu", this.currentTotalEu);
        nbt.func_74778_a("currentInputName", this.currentInputName == null ? "" : this.currentInputName);
        nbt.func_74778_a("currentOutputName", this.currentOutputName == null ? "" : this.currentOutputName);
        nbt.func_74768_a("currentRecipeCostEu", this.currentRecipeCostEu);
        return nbt;
    }
}

