/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.tilentity;

import com.ic2additions.util.EnergyStorageRF;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySource;
import ic2.core.ContainerBase;
import ic2.core.IHasGui;
import ic2.core.block.ITeBlock;
import ic2.core.block.TileEntityInventory;
import ic2.core.gui.dynamic.DynamicContainer;
import ic2.core.gui.dynamic.DynamicGui;
import ic2.core.gui.dynamic.GuiParser;
import ic2.core.gui.dynamic.IGuiValueProvider;
import ic2.core.network.GuiSynced;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEntityRFtoEU
extends TileEntityInventory
implements IEnergySource,
IHasGui,
IGuiValueProvider {
    private final EnergyStorageRF rfStorage = new EnergyStorageRF(40000);
    private int euBuffer = 0;
    private final int maxEuBuffer = 10000;
    private static final double CONVERSION = 4.0;
    @GuiSynced
    private int selectedTier = 1;

    protected void updateEntityServer() {
        super.updateEntityServer();
        int rfAvailable = this.rfStorage.getEnergyStored();
        if (rfAvailable > 0 && this.euBuffer < 10000) {
            int maxEuThisTick = this.tierToEU(this.selectedTier);
            int euSpace = Math.min(10000 - this.euBuffer, maxEuThisTick);
            int rfToExtract = Math.min(rfAvailable, (int)((double)euSpace * 4.0));
            int euProduced = (int)((double)rfToExtract / 4.0);
            if (rfToExtract > 0 && euProduced > 0) {
                this.rfStorage.extractEnergy(rfToExtract, false);
                this.euBuffer += euProduced;
            }
        }
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.euBuffer, this.tierToEU(this.selectedTier));
    }

    @Override
    public void drawEnergy(double amount) {
        this.euBuffer = (int)((double)this.euBuffer - amount);
        if (this.euBuffer < 0) {
            this.euBuffer = 0;
        }
    }

    @Override
    public int getSourceTier() {
        return this.selectedTier;
    }

    @Override
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return true;
    }

    private int tierToEU(int tier) {
        switch (tier) {
            case 1: {
                return 32;
            }
            case 2: {
                return 128;
            }
            case 3: {
                return 512;
            }
            case 4: {
                return 2048;
            }
            case 5: {
                return 8192;
            }
        }
        return 32;
    }

    public void nextTier() {
        ++this.selectedTier;
        if (this.selectedTier > 5) {
            this.selectedTier = 1;
        }
        this.func_70296_d();
    }

    public void prevTier() {
        --this.selectedTier;
        if (this.selectedTier < 1) {
            this.selectedTier = 5;
        }
        this.func_70296_d();
    }

    private boolean handleTierEvent(String name) {
        System.out.println("GUI EVENT: " + name);
        if ("tier_up".equals(name)) {
            this.nextTier();
            return true;
        }
        if ("tier_down".equals(name)) {
            this.prevTier();
            return true;
        }
        return false;
    }

    public boolean onGuiEvent(String name) {
        return this.handleTierEvent(name);
    }

    public boolean onGuiEvent(String name, int value) {
        return this.handleTierEvent(name);
    }

    public boolean onGuiEvent(String name, double value) {
        return this.handleTierEvent(name);
    }

    public boolean onGuiEvent(String name, String value) {
        return this.handleTierEvent(name);
    }

    public double getGuiValue(String key) {
        switch (key) {
            case "tier": {
                return this.selectedTier;
            }
            case "tier_eu": {
                return this.tierToEU(this.selectedTier);
            }
            case "euBuffer": {
                return this.euBuffer;
            }
            case "rfBuffer": {
                return this.rfStorage.getEnergyStored();
            }
        }
        return 0.0;
    }

    public ContainerBase<? extends TileEntityRFtoEU> getGuiContainer(EntityPlayer player) {
        return DynamicContainer.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public GuiScreen getGui(EntityPlayer player, boolean isAdmin) {
        return DynamicGui.create((IInventory)this, (EntityPlayer)player, (GuiParser.GuiNode)GuiParser.parse((ITeBlock)this.teBlock));
    }

    public void onGuiClosed(EntityPlayer player) {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.selectedTier = nbt.func_74762_e("selectedTier");
        this.euBuffer = nbt.func_74762_e("euBuffer");
        this.rfStorage.receiveEnergy(nbt.func_74762_e("rfEnergy"), false);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("selectedTier", this.selectedTier);
        nbt.func_74768_a("euBuffer", this.euBuffer);
        nbt.func_74768_a("rfEnergy", this.rfStorage.getEnergyStored());
        return nbt;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.rfStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected void onLoaded() {
        super.onLoaded();
        if (!this.field_145850_b.field_72995_K) {
            EnergyNet.instance.addTile(this);
        }
    }

    protected void onUnloaded() {
        super.onUnloaded();
        if (!this.field_145850_b.field_72995_K) {
            EnergyNet.instance.removeTile(this);
        }
    }
}

