/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.util;

import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryModifiable;

@Mod.EventBusSubscriber
public class DeleteItems {
    private static final String[] TO_REMOVE = new String[]{"quantum_helmet", "quantum_chestplate", "quantum_leggings", "quantum_boots"};

    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> event) {
        for (String id : TO_REMOVE) {
            ResourceLocation rl = new ResourceLocation("ic2", id);
            Item item = (Item)event.getRegistry().getValue(rl);
            if (item == null) continue;
            event.getRegistry().register(new Item().setRegistryName(rl));
        }
    }

    @SubscribeEvent
    public static void onRecipeRegister(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable registry = (IForgeRegistryModifiable)event.getRegistry();
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        block0: for (IRecipe recipe : event.getRegistry().getValuesCollection()) {
            ItemStack output = recipe.func_77571_b();
            if (output.func_190926_b() || output.func_77973_b().getRegistryName() == null) continue;
            String outputName = output.func_77973_b().getRegistryName().toString();
            for (String id : TO_REMOVE) {
                if (!outputName.equals("ic2:" + id)) continue;
                toRemove.add(recipe.getRegistryName());
                continue block0;
            }
        }
        for (ResourceLocation rl : toRemove) {
            registry.remove(rl);
        }
    }
}

