/*
 * Decompiled with CFR 0.152.
 */
package com.ic2additions.util;

import com.ic2additions.objects.items.armor.AdvancedElectricJetpack;
import com.ic2additions.objects.items.armor.ItemArmorMolecular;
import ic2.core.item.armor.jetpack.IJetpack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class JetpackOverlay {
    public static boolean hudEnabled = true;
    public static byte hudPos = 1;

    public JetpackOverlay() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRender(TickEvent.RenderTickEvent evt) {
        if (!hudEnabled) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e == null || mc.field_71439_g == null || !Minecraft.func_71382_s() || mc.field_71474_y.field_74330_P) {
            return;
        }
        ItemStack chest = mc.field_71439_g.func_184582_a(EntityEquipmentSlot.CHEST);
        if (chest.func_190926_b()) {
            return;
        }
        Item item = chest.func_77973_b();
        if (!(item instanceof IJetpack)) {
            return;
        }
        IJetpack jp = (IJetpack)item;
        int percent = Math.round((float)(jp.getChargeLevel(chest) * 100.0));
        String energyLine = I18n.func_135052_a((String)"ic2additions.hud.energy", (Object[])new Object[]{percent});
        String engineLine = "";
        if (jp.isJetpackActive(chest)) {
            engineLine = I18n.func_135052_a((String)"ic2additions.hud.engine", (Object[])new Object[]{I18n.func_135052_a((String)(jp.isJetpackActive(chest) ? "ic2additions.message.on" : "ic2additions.message.off"), (Object[])new Object[0])});
            if (AdvancedElectricJetpack.isHovering(chest)) {
                engineLine = engineLine + " " + I18n.func_135052_a((String)"ic2additions.hud.hover_brackets", (Object[])new Object[0]);
            }
        }
        String suitLine = "";
        if (item instanceof ItemArmorMolecular) {
            boolean punch;
            boolean fire = chest.func_77942_o() && chest.func_77978_p().func_74767_n("fireMode");
            boolean hand = chest.func_77942_o() && chest.func_77978_p().func_74767_n("handFastbreak");
            boolean silk = hand && chest.func_77942_o() && "SILK".equals(chest.func_77978_p().func_74779_i("handMode"));
            boolean bl = punch = chest.func_77942_o() && chest.func_77978_p().func_74767_n("punchMode");
            String modeKey = fire ? "ic2additions.mode.fire" : (hand ? (silk ? "ic2additions.mode.hand_silk" : "ic2additions.mode.hand") : (punch ? "ic2additions.mode.punch" : "ic2additions.mode.none"));
            suitLine = I18n.func_135052_a((String)"ic2additions.message.suit_mode", (Object[])new Object[]{I18n.func_135052_a((String)modeKey, (Object[])new Object[0])});
        }
        ArrayList<String> lines = new ArrayList<String>(3);
        if (!engineLine.isEmpty()) {
            lines.add(engineLine);
        }
        if (!suitLine.isEmpty()) {
            lines.add(suitLine);
        }
        lines.add(energyLine);
        FontRenderer fr = mc.field_71466_p;
        int fh = fr.field_78288_b;
        int pad = 2;
        ScaledResolution sr = new ScaledResolution(mc);
        boolean rightAlign = hudPos == 2 || hudPos == 4;
        int startY = hudPos == 3 || hudPos == 4 ? sr.func_78328_b() - pad - fh : pad;
        for (int i = 0; i < lines.size(); ++i) {
            String text = (String)lines.get(i);
            int y = hudPos == 3 || hudPos == 4 ? startY - (lines.size() - 1 - i) * (fh + pad) : startY + i * (fh + pad);
            if (rightAlign) {
                int x = sr.func_78326_a() - pad - fr.func_78256_a(text);
                mc.field_71456_v.func_73731_b(fr, text, x, y, 0xFFFFFF);
                continue;
            }
            mc.field_71456_v.func_73731_b(fr, text, pad, y, 0xFFFFFF);
        }
    }
}

