/*
 * Decompiled with CFR 0.152.
 */
package cyborgcabbage.emojitype.emoji;

import java.util.Optional;

public class EmojiCode {
    public static String DELIMITER = ";";
    private final String code;
    private final String emoji;

    public EmojiCode(String code, String emoji) {
        this.code = code;
        this.emoji = emoji;
    }

    public String getCode() {
        return this.code;
    }

    public String getEmoji() {
        return this.emoji;
    }

    public boolean match(String string, int charIndex) {
        for (int i = 0; i < this.code.length(); ++i) {
            int stringIndex = charIndex - i;
            int codeIndex = this.code.length() - 1 - i;
            if (stringIndex < 0 || codeIndex < 0) {
                return false;
            }
            if (stringIndex >= string.length()) {
                return false;
            }
            if (string.charAt(stringIndex) == this.code.charAt(codeIndex)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.code.length() >= 3) {
            return this.code.substring(1, this.code.length() - 1) + DELIMITER + this.emoji;
        }
        return this.code + DELIMITER + this.emoji;
    }

    public static Optional<EmojiCode> fromString(String str) {
        int index = str.indexOf(DELIMITER);
        if (index != -1) {
            String code = ":" + str.substring(0, index) + ":";
            String emoji = str.substring(index + DELIMITER.length());
            return Optional.of(new EmojiCode(code, emoji));
        }
        return Optional.empty();
    }
}

