/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancient_elements.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.ancient_elements.AncientElementsMod;
import net.mcreator.ancient_elements.procedures.CraterbornButtonProcedure;
import net.mcreator.ancient_elements.procedures.Items2ButtonProcedure;
import net.mcreator.ancient_elements.procedures.PocketMagnetButtonProcedure;
import net.mcreator.ancient_elements.world.inventory.GravityAnchorPageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class GravityAnchorPageButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public GravityAnchorPageButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public GravityAnchorPageButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(GravityAnchorPageButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(GravityAnchorPageButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            GravityAnchorPageButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = GravityAnchorPageMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Items2ButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            CraterbornButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            CraterbornButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            CraterbornButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            CraterbornButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            CraterbornButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            PocketMagnetButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AncientElementsMod.addNetworkMessage(GravityAnchorPageButtonMessage.class, GravityAnchorPageButtonMessage::buffer, GravityAnchorPageButtonMessage::new, GravityAnchorPageButtonMessage::handler);
    }
}

