/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.ancient_elements.network;

import java.util.HashMap;
import java.util.function.Supplier;
import net.mcreator.ancient_elements.AncientElementsMod;
import net.mcreator.ancient_elements.procedures.AeroGauntletButtonProcedure;
import net.mcreator.ancient_elements.procedures.FierySolutionButtonProcedure;
import net.mcreator.ancient_elements.procedures.HellstoneButtonProcedure;
import net.mcreator.ancient_elements.procedures.SoulKnifeButtonProcedure;
import net.mcreator.ancient_elements.world.inventory.MoltenLancePageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MoltenLancePageButtonMessage {
    private final int buttonID;
    private final int x;
    private final int y;
    private final int z;

    public MoltenLancePageButtonMessage(FriendlyByteBuf buffer) {
        this.buttonID = buffer.readInt();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public MoltenLancePageButtonMessage(int buttonID, int x, int y, int z) {
        this.buttonID = buttonID;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static void buffer(MoltenLancePageButtonMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }

    public static void handler(MoltenLancePageButtonMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            int buttonID = message.buttonID;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            MoltenLancePageButtonMessage.handleButtonAction((Player)entity, buttonID, x, y, z);
        });
        context.setPacketHandled(true);
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.m_9236_();
        HashMap<String, Object> guistate = MoltenLancePageMenu.guistate;
        if (!world.m_46805_(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            SoulKnifeButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 1) {
            AeroGauntletButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 2) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 3) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 4) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 5) {
            HellstoneButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 6) {
            FierySolutionButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
        if (buttonID == 7) {
            FierySolutionButtonProcedure.execute((LevelAccessor)world, (Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        AncientElementsMod.addNetworkMessage(MoltenLancePageButtonMessage.class, MoltenLancePageButtonMessage::buffer, MoltenLancePageButtonMessage::new, MoltenLancePageButtonMessage::handler);
    }
}

