/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.object;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.state.CameraRenderState;

public record TESHudRenderContext(Either<InGuiArgs, InWorldArgs> args) {
    public static TESHudRenderContext guiContext(GuiGraphics guiGraphics, float partialTick) {
        return new TESHudRenderContext((Either<InGuiArgs, InWorldArgs>)Either.left((Object)new InGuiArgs(guiGraphics, partialTick)));
    }

    public static TESHudRenderContext inWorldContext(PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraRenderState, float partialTick, int packedLight) {
        return new TESHudRenderContext((Either<InGuiArgs, InWorldArgs>)Either.right((Object)new InWorldArgs(poseStack, renderTasks, cameraRenderState, partialTick, packedLight)));
    }

    public boolean isInWorld() {
        return this.args.right().isPresent();
    }

    public TESHudRenderContext forGui(Consumer<InGuiArgs> guiConsumer) {
        this.args.ifLeft(guiConsumer);
        return this;
    }

    public TESHudRenderContext forInWorld(Consumer<InWorldArgs> inWorldConsumer) {
        this.args.ifRight(inWorldConsumer);
        return this;
    }

    public void pushMatrix() {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.pose().pushMatrix()).ifRight(inWorldArgs -> inWorldArgs.poseStack.pushPose());
    }

    public void popMatrix() {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.pose().popMatrix()).ifRight(inWorldArgs -> inWorldArgs.poseStack.popPose());
    }

    public void translate(float x, float y, float z) {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.pose().translate(x, y)).ifRight(inWorldArgs -> inWorldArgs.poseStack.translate(x, y, z));
    }

    public void scale(float x, float y, float z) {
        this.args.ifLeft(inGuiArgs -> inGuiArgs.guiGraphics.pose().scale(x, y)).ifRight(inWorldArgs -> inWorldArgs.poseStack.scale(x, y, z));
    }

    public float getPartialTick() {
        return ((Float)this.args.map(InGuiArgs::partialTick, InWorldArgs::partialTick)).floatValue();
    }

    public GuiGraphics getGuiGraphics() {
        if (this.isInWorld()) {
            throw new IllegalStateException("Cannot get GuiGraphics from in-world render context");
        }
        return ((InGuiArgs)this.args.left().get()).guiGraphics();
    }

    public PoseStack getPoseStack() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get PoseStack from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).poseStack;
    }

    public int getPackedLight() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get BufferSource from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).packedLight;
    }

    public record InGuiArgs(GuiGraphics guiGraphics, float partialTick) {
    }

    public record InWorldArgs(PoseStack poseStack, SubmitNodeCollector renderTasks, CameraRenderState cameraRenderState, float partialTick, int packedLight) {
    }
}

