/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util.render;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.font.TextRenderable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.state.GuiTextRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.ARGB;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.object.TextRenderStyle;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;

public class TextRenderHelper {
    private final Component component;
    private TextRenderStyle style = TextRenderStyle.NORMAL;
    private Font font;
    private int textColour;
    private int secondaryColour;
    private int packedLight;
    private boolean centered;
    private int wrapWidth;
    private int backdropColour;

    TextRenderHelper(Component component) {
        this.font = Minecraft.getInstance().font;
        this.textColour = -1;
        this.secondaryColour = -1;
        this.packedLight = 0xF000F0;
        this.centered = false;
        this.wrapWidth = -1;
        this.backdropColour = 0;
        this.component = component;
    }

    public static TextRenderHelper of(String text) {
        return TextRenderHelper.of((Component)Component.literal((String)text));
    }

    public static TextRenderHelper of(Component component) {
        return new TextRenderHelper(component);
    }

    public TextRenderHelper style(TextRenderStyle style) {
        this.style = style;
        return this;
    }

    public TextRenderHelper colour(int colour) {
        this.textColour = colour;
        return this;
    }

    public TextRenderHelper centered() {
        return this.centered(true);
    }

    public TextRenderHelper centered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public TextRenderHelper wrapWidth(int wrapWidth) {
        this.wrapWidth = wrapWidth;
        return this;
    }

    public TextRenderHelper font(Font font) {
        this.font = font;
        return this;
    }

    public TextRenderHelper lightLevel(int packedLight) {
        this.packedLight = packedLight;
        return this;
    }

    public TextRenderHelper withBackdrop() {
        return this.withBackdrop(Minecraft.getInstance().options.getBackgroundColor(0.0f));
    }

    public TextRenderHelper withBackdrop(int colour) {
        this.backdropColour = colour;
        return this;
    }

    public TextRenderHelper colour(int red, int green, int blue, int alpha) {
        return this.colour(ARGB.color((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextRenderHelper colour(float red, float green, float blue, float alpha) {
        return this.colour(ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextRenderHelper colour(float red, float green, float blue) {
        return this.colour(red, green, blue, 1.0f);
    }

    public TextRenderHelper colour(int red, int green, int blue) {
        return this.colour(red, green, blue, 255);
    }

    public TextRenderHelper secondaryColour(int colour) {
        this.secondaryColour = colour;
        return this;
    }

    public TextRenderHelper secondaryColour(int red, int green, int blue, int alpha) {
        return this.secondaryColour(ARGB.color((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextRenderHelper secondaryColour(float red, float green, float blue, float alpha) {
        return this.secondaryColour(ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextRenderHelper secondaryColour(float red, float green, float blue) {
        return this.secondaryColour(red, green, blue, 1.0f);
    }

    public TextRenderHelper secondaryColour(int red, int green, int blue) {
        return this.secondaryColour(red, green, blue, 255);
    }

    public void render(TESHudRenderContext renderContext, float x, float y) {
        renderContext.forGui(args -> this.renderForHud((TESHudRenderContext.InGuiArgs)args, x, y)).forInWorld(args -> this.renderInWorld((TESHudRenderContext.InWorldArgs)args, x, y));
    }

    public void renderForHud(TESHudRenderContext.InGuiArgs args, float x, float y) {
        if (ARGB.alpha((int)this.textColour) == 0 && ARGB.alpha((int)this.secondaryColour) == 0) {
            return;
        }
        Style style = Style.fromTextRenderStyle(this.style);
        int shadowColour = this.secondaryColour == -1 ? (Integer)style.colourFunction.apply((Object)this.textColour) : this.secondaryColour;
        int stringWidth = this.font.width((FormattedText)this.component);
        int width = this.wrapWidth == -1 ? stringWidth : Math.min(stringWidth, this.wrapWidth);
        int posX = Mth.floor((float)x) - (this.centered ? width / 2 : 0);
        int posY = Mth.floor((float)y);
        FormattedCharSequence charSequence = this.component.getVisualOrderText();
        GuiGraphics guiGraphics = args.guiGraphics();
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)guiGraphics.pose());
        for (Pair<Font.PreparedText, ScreenRectangle> text : style.renderFunction.prepare(this.font, charSequence, posX, posY, this.textColour, shadowColour, this.backdropColour, this.packedLight, (Either<Matrix3x2f, Matrix4f>)Either.left((Object)pose), guiGraphics.scissorStack.peek(), null)) {
            RenderState renderState = new RenderState((Font.PreparedText)text.getFirst(), this.font, charSequence, pose, posX, posY, this.textColour, shadowColour, guiGraphics.scissorStack.peek());
            renderState.bounds = (ScreenRectangle)text.getSecond();
            guiGraphics.guiRenderState.submitText((GuiTextRenderState)renderState);
        }
    }

    public void renderInWorld(TESHudRenderContext.InWorldArgs args, float x, float y) {
        if (ARGB.alpha((int)this.textColour) == 0 && ARGB.alpha((int)this.secondaryColour) == 0) {
            return;
        }
        Style style = Style.fromTextRenderStyle(this.style);
        int shadowColour = this.secondaryColour == -1 ? (Integer)style.colourFunction.apply((Object)this.textColour) : this.secondaryColour;
        int stringWidth = this.font.width((FormattedText)this.component);
        int width = this.wrapWidth == -1 ? stringWidth : Math.min(stringWidth, this.wrapWidth);
        int posX = Mth.floor((float)x) - (this.centered ? width / 2 : 0);
        int posY = Mth.floor((float)y);
        FormattedCharSequence charSequence = this.component.getVisualOrderText();
        args.renderTasks().submitCustomGeometry(args.poseStack(), RenderType.textBackgroundSeeThrough(), (pose, vertexConsumer) -> style.renderFunction.prepare(this.font, charSequence, posX, posY, this.textColour, shadowColour, this.backdropColour, this.packedLight, (Either<Matrix3x2f, Matrix4f>)Either.right((Object)pose.pose()), null, Minecraft.getInstance().renderBuffers().bufferSource()));
    }

    static Font.PreparedTextBuilder configurablePreparedText(final Font font, float x, float y, int colour, final int shadowColour, int backgroundColour, final boolean dropShadow) {
        Font font2 = font;
        Objects.requireNonNull(font2);
        return new Font.PreparedTextBuilder(font2, x, y, colour, backgroundColour, dropShadow){
            {
                Font font2 = x0;
                Objects.requireNonNull(font2);
                super(font2, pX, pY, pColor, pBackgroundColor, pDropShadow);
            }

            public int getShadowColor(net.minecraft.network.chat.Style textStyle, int textColour) {
                if (dropShadow && shadowColour != 0) {
                    return shadowColour;
                }
                Integer textStyleColour = textStyle.getShadowColor();
                if (textStyleColour != null) {
                    float textAlpha = ARGB.alphaFloat((int)textColour);
                    float shadowAlpha = ARGB.alphaFloat((int)textStyleColour);
                    return textAlpha != 1.0f ? ARGB.color((int)ARGB.as8BitChannel((float)(textAlpha * shadowAlpha)), (int)textStyleColour) : textStyleColour;
                }
                return 0;
            }

            public void visit(Font.GlyphVisitor glyphVisitor) {
                if (ARGB.alpha((int)this.backgroundColor) != 0) {
                    glyphVisitor.acceptEffect(font.provider.effect().createEffect(this.backgroundLeft, this.backgroundTop, this.backgroundRight, this.backgroundBottom, -0.01f, this.backgroundColor, 0, 0.0f));
                }
                for (TextRenderable renderable : this.glyphs) {
                    glyphVisitor.acceptGlyph(renderable);
                }
                if (this.effects != null) {
                    for (TextRenderable effect : this.effects) {
                        glyphVisitor.acceptEffect(effect);
                    }
                }
            }
        };
    }

    static Font.GlyphVisitor getWorldspaceGlyphVisitor(MultiBufferSource bufferSource, Matrix4f pose, Font.DisplayMode displayMode, int packedLight, boolean dropShadow) {
        return Font.GlyphVisitor.forMultiBufferSource((MultiBufferSource)bufferSource, (Matrix4f)pose, (Font.DisplayMode)displayMode, (int)packedLight);
    }

    public static enum Style {
        NORMAL(Style::renderDefault, colour -> -16777216),
        DROP_SHADOW(Style::renderDropShadow, colour -> ARGB.scaleRGB((int)colour, (float)0.25f)),
        GLOWING(Style::renderOutlined, colour -> ARGB.scaleRGB((int)colour, (float)0.5f)),
        OUTLINED(Style::renderOutlined, colour -> -16777216);

        final RenderFunction renderFunction;
        final Int2IntFunction colourFunction;

        private Style(RenderFunction renderFunction, Int2IntFunction defaultShadowColour) {
            this.renderFunction = renderFunction;
            this.colourFunction = defaultShadowColour;
        }

        public static Style fromTextRenderStyle(TextRenderStyle style) {
            return switch (style) {
                default -> throw new MatchException(null, null);
                case TextRenderStyle.NORMAL -> NORMAL;
                case TextRenderStyle.DROP_SHADOW -> DROP_SHADOW;
                case TextRenderStyle.GLOWING -> GLOWING;
                case TextRenderStyle.OUTLINED -> OUTLINED;
            };
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        Font.PreparedText, @Nullable ScreenRectangle>> renderDefault(Font font, FormattedCharSequence charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable ScreenRectangle scissor, @Nullable MultiBufferSource.BufferSource bufferSource) {
            return Style.renderDefault(font, charSequence, x, y, colour, secondaryColour, backgroundColour, packedLight, false, pose, scissor, bufferSource);
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        Font.PreparedText, @Nullable ScreenRectangle>> renderDropShadow(Font font, FormattedCharSequence charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable ScreenRectangle scissor, @Nullable MultiBufferSource.BufferSource bufferSource) {
            return Style.renderDefault(font, charSequence, x, y, colour, secondaryColour, backgroundColour, packedLight, true, pose, scissor, bufferSource);
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        Font.PreparedText, @Nullable ScreenRectangle>> renderDefault(Font font, FormattedCharSequence charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, boolean dropShadow, Either<Matrix3x2f, Matrix4f> pose, @Nullable ScreenRectangle scissor, @Nullable MultiBufferSource.BufferSource bufferSource) {
            Font.PreparedTextBuilder preparedText = TextRenderHelper.configurablePreparedText(font, x, y, colour, secondaryColour, backgroundColour, dropShadow);
            charSequence.accept((FormattedCharSink)preparedText);
            return (List)Either.unwrap((Either)pose.mapBoth(pose2d -> {
                ScreenRectangle region = preparedText.bounds();
                if (region == null) {
                    return null;
                }
                region = region.transformMaxBounds(pose2d);
                return List.of(Pair.of((Object)preparedText, (Object)(scissor != null ? scissor.intersection(region) : region)));
            }, pose3d -> {
                preparedText.visit(TextRenderHelper.getWorldspaceGlyphVisitor((MultiBufferSource)bufferSource, pose3d, Font.DisplayMode.POLYGON_OFFSET, packedLight, dropShadow));
                return List.of();
            }));
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        Font.PreparedText, @Nullable ScreenRectangle>> renderOutlined(Font font, FormattedCharSequence charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable ScreenRectangle scissor, @Nullable MultiBufferSource.BufferSource bufferSource) {
            Font.PreparedTextBuilder outlineText = TextRenderHelper.configurablePreparedText(font, 0.0f, 0.0f, secondaryColour, 0, backgroundColour, false);
            float outlineWeight = 0.6f;
            for (int xO = -1; xO <= 1; ++xO) {
                for (int yO = -1; yO <= 1; ++yO) {
                    if (xO == 0 && yO == 0) continue;
                    float[] cumulativeXOffset = new float[]{x};
                    int xOffset = xO;
                    int yOffset = yO;
                    charSequence.accept((charIndex, style, character) -> {
                        BakedGlyph glyph = font.getGlyph(character, style);
                        float shadowOffset = glyph.info().getShadowOffset() * 0.6f;
                        outlineText.x = cumulativeXOffset[0] + (float)xOffset * shadowOffset;
                        outlineText.y = y + (float)yOffset * shadowOffset;
                        cumulativeXOffset[0] = cumulativeXOffset[0] + glyph.info().getAdvance(style.isBold());
                        return outlineText.accept(charIndex, style.withColor(backgroundColour), character);
                    });
                }
            }
            Font.PreparedTextBuilder text = TextRenderHelper.configurablePreparedText(font, x, y, colour, 0, backgroundColour, false);
            return (List)Either.unwrap((Either)pose.mapBoth(pose2d -> {
                charSequence.accept((FormattedCharSink)text);
                ScreenRectangle region = outlineText.bounds();
                ScreenRectangle bounds = null;
                ScreenRectangle bounds2 = null;
                if (region != null) {
                    region = region.transformMaxBounds(pose2d);
                    ScreenRectangle screenRectangle = bounds = scissor != null ? scissor.intersection(region) : region;
                }
                if ((region = text.bounds()) != null) {
                    region = region.transformMaxBounds(pose2d);
                    bounds2 = scissor != null ? scissor.intersection(region) : region;
                }
                return List.of(Pair.of((Object)outlineText, (Object)bounds), Pair.of((Object)text, bounds2));
            }, pose3d -> {
                Font.GlyphVisitor glyphVisitor = TextRenderHelper.getWorldspaceGlyphVisitor((MultiBufferSource)bufferSource, pose3d, Font.DisplayMode.NORMAL, packedLight, false);
                for (TextRenderable glyph : outlineText.glyphs) {
                    glyphVisitor.acceptGlyph(glyph);
                }
                charSequence.accept((FormattedCharSink)text);
                text.visit(TextRenderHelper.getWorldspaceGlyphVisitor((MultiBufferSource)bufferSource, pose3d, Font.DisplayMode.POLYGON_OFFSET, packedLight, false));
                return List.of();
            }));
        }

        @FunctionalInterface
        static interface RenderFunction {
            public List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
            Font.PreparedText, @Nullable ScreenRectangle>> prepare(Font var1, FormattedCharSequence var2, float var3, float var4, int var5, int var6, int var7, int var8, Either<Matrix3x2f, Matrix4f> var9, @Nullable ScreenRectangle var10, @Nullable MultiBufferSource.BufferSource var11);
        }
    }

    static class RenderState
    extends GuiTextRenderState {
        public RenderState(Font.PreparedText preparedText, Font font, FormattedCharSequence charSequence, Matrix3x2f pose, int x, int y, int colour, int secondaryColour, @Nullable ScreenRectangle scissor) {
            super(font, charSequence, pose, x, y, colour, secondaryColour, false, scissor);
            this.preparedText = preparedText;
        }

        public Font.PreparedText ensurePrepared() {
            return this.preparedText;
        }
    }
}

