/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.networking.packet;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;

public record RequestEffectsPacket(int entityId) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<RequestEffectsPacket> TYPE = new CustomPacketPayload.Type(TESConstants.id("request_effects"));
    public static final StreamCodec<FriendlyByteBuf, RequestEffectsPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RequestEffectsPacket::entityId, RequestEffectsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            Entity entity = sender.level().getEntity(this.entityId);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                Collection effects = livingEntity.getActiveEffects();
                ObjectOpenHashSet ids = new ObjectOpenHashSet(effects.size());
                for (MobEffectInstance instance : effects) {
                    if (!instance.isVisible() && !instance.showIcon()) continue;
                    ids.add(instance.getEffect());
                }
                TESConstants.NETWORKING.sendEffectsSync((ServerPlayer)sender, this.entityId, (Set<Holder<MobEffect>>)ids, Set.of());
            }
        });
    }
}

