/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.networking;

import java.util.Optional;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.core.networking.packet.MultiloaderConfigurationPacket;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.networking.packet.NewComponentParticlePacket;
import net.tslat.tes.core.networking.packet.NewNumericParticlePacket;
import net.tslat.tes.core.networking.packet.ParticleClaimPacket;
import net.tslat.tes.core.networking.packet.RequestEffectsPacket;
import net.tslat.tes.core.networking.packet.ServerConnectionAckPacket;
import net.tslat.tes.core.networking.packet.SyncEffectsPacket;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public interface TESNetworking {
    public void requestEffectsSync(int var1);

    public void sendEffectsSync(ServerPlayer var1, int var2, Set<Holder<MobEffect>> var3, Set<Holder<MobEffect>> var4);

    public void sendEffectsSync(LivingEntity var1, Set<Holder<MobEffect>> var2, Set<Holder<MobEffect>> var3);

    public void sendParticle(ServerLevel var1, Vector3f var2, Component var3);

    public void sendParticle(LivingEntity var1, Component var2);

    public void sendParticle(ServerLevel var1, Vector3f var2, double var3, int var5);

    public void sendParticle(LivingEntity var1, double var2, int var4);

    public void sendParticleClaim(ResourceLocation var1, LivingEntity var2, Optional<CompoundTag> var3);

    public static void init() {
        TESNetworking.registerPacket(NewComponentParticlePacket.TYPE, NewComponentParticlePacket.CODEC, Direction.CLIENTBOUND);
        TESNetworking.registerPacket(NewNumericParticlePacket.TYPE, NewNumericParticlePacket.CODEC, Direction.CLIENTBOUND);
        TESNetworking.registerPacket(ParticleClaimPacket.TYPE, ParticleClaimPacket.CODEC, Direction.CLIENTBOUND);
        TESNetworking.registerPacket(RequestEffectsPacket.TYPE, RequestEffectsPacket.CODEC, Direction.SERVERBOUND);
        TESNetworking.registerPacket(SyncEffectsPacket.TYPE, SyncEffectsPacket.CODEC, Direction.CLIENTBOUND);
        TESNetworking.registerConfigurationPacket(ServerConnectionAckPacket.TYPE, ServerConnectionAckPacket.CODEC, Direction.BIDIRECTIONAL);
    }

    public static <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacket(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, Direction direction) {
        TESConstants.NETWORKING.registerPacketInternal(payloadType, codec, direction);
    }

    public static <B extends FriendlyByteBuf, P extends MultiloaderConfigurationPacket> void registerConfigurationPacket(CustomPacketPayload.Type<P> payloadType, StreamCodec<B, P> codec, Direction direction) {
        TESConstants.NETWORKING.registerConfigurationPacketInternal(payloadType, codec, direction);
    }

    @ApiStatus.Internal
    public <B extends FriendlyByteBuf, P extends MultiloaderConfigurationPacket> void registerConfigurationPacketInternal(CustomPacketPayload.Type<P> var1, StreamCodec<B, P> var2, Direction var3);

    @ApiStatus.Internal
    public <B extends FriendlyByteBuf, P extends MultiloaderPacket> void registerPacketInternal(CustomPacketPayload.Type<P> var1, StreamCodec<B, P> var2, Direction var3);

    public static enum Direction {
        SERVERBOUND,
        CLIENTBOUND,
        BIDIRECTIONAL;

    }
}

