/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.networking.packet;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public record SyncEffectsPacket(int entityId, Set<Holder<MobEffect>> idsToAdd, Set<Holder<MobEffect>> idsToRemove) implements MultiloaderPacket
{
    public static final CustomPacketPayload.Type<SyncEffectsPacket> TYPE = new CustomPacketPayload.Type(TESConstants.id("sync_effects"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncEffectsPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SyncEffectsPacket::entityId, (StreamCodec)ByteBufCodecs.collection(ObjectOpenHashSet::new, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT)), SyncEffectsPacket::idsToAdd, (StreamCodec)ByteBufCodecs.collection(ObjectOpenHashSet::new, (StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT)), SyncEffectsPacket::idsToRemove, SyncEffectsPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    @Override
    public void receiveMessage(Player sender, Consumer<Runnable> workQueue) {
        workQueue.accept(() -> {
            EntityState state = TESEntityTracking.getStateForEntityId(this.entityId);
            if (state != null) {
                state.modifyEffects(this.idsToAdd, this.idsToRemove);
            }
        });
    }
}

