/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.mixin.common;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESConstants;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"onEffectAdded"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/effect/MobEffect;addAttributeModifiers(Lnet/minecraft/world/entity/ai/attributes/AttributeMap;I)V")})
    private void tes$syncAddedEffect(MobEffectInstance effectInstance, @Nullable Entity entity, CallbackInfo callback) {
        TESConstants.NETWORKING.sendEffectsSync((LivingEntity)this, Set.of(effectInstance.getEffect()), Set.of());
    }

    @Inject(method={"onEffectsRemoved"}, at={@At(value="HEAD")})
    private void tes$syncRemovedEffect(Collection<MobEffectInstance> effects, CallbackInfo ci) {
        if (!((LivingEntity)this).level().isClientSide()) {
            ObjectOpenHashSet currentEffects = new ObjectOpenHashSet(effects.size());
            for (MobEffectInstance instance : effects) {
                currentEffects.add(instance.getEffect());
            }
            TESConstants.NETWORKING.sendEffectsSync((LivingEntity)this, Set.of(), (Set<Holder<MobEffect>>)currentEffects);
        }
    }
}

