/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.tslat.tes.api.object.TESHudRenderContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;

public class ColouredRectRenderHelper {
    private final RenderPipeline renderPipeline;
    private float width = 16.0f;
    private float height = 16.0f;
    private int colour0 = -1;
    private int colour1 = -1;
    private int colour2 = -1;
    private int colour3 = -1;

    ColouredRectRenderHelper(RenderPipeline renderPipeline) {
        this.renderPipeline = renderPipeline;
    }

    public static ColouredRectRenderHelper of() {
        return ColouredRectRenderHelper.of(RenderPipelines.GUI);
    }

    public static ColouredRectRenderHelper of(RenderPipeline renderPipeline) {
        return new ColouredRectRenderHelper(renderPipeline);
    }

    public ColouredRectRenderHelper sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public ColouredRectRenderHelper colour(int colour) {
        this.colour0 = colour;
        if (this.colour1 == -1) {
            this.colour1 = colour;
        }
        if (this.colour2 == -1) {
            this.colour2 = colour;
        }
        if (this.colour3 == -1) {
            this.colour3 = colour;
        }
        return this;
    }

    public ColouredRectRenderHelper bottomLeftColour(int colour) {
        this.colour1 = colour;
        return this;
    }

    public ColouredRectRenderHelper bottomRightColour(int colour) {
        this.colour2 = colour;
        return this;
    }

    public ColouredRectRenderHelper topRightColour(int colour) {
        this.colour3 = colour;
        return this;
    }

    public ColouredRectRenderHelper colour(int red, int green, int blue, int alpha) {
        return this.colour(ARGB.color((int)alpha, (int)red, (int)green, (int)blue));
    }

    public ColouredRectRenderHelper colour(float red, float green, float blue, float alpha) {
        return this.colour(ARGB.colorFromFloat((float)alpha, (float)red, (float)green, (float)blue));
    }

    public ColouredRectRenderHelper colour(float red, float green, float blue) {
        return this.colour(red, green, blue, 1.0f);
    }

    public ColouredRectRenderHelper colour(int red, int green, int blue) {
        return this.colour(red, green, blue, 255);
    }

    public void render(TESHudRenderContext renderContext, float x, float y) {
        if (renderContext.isInWorld()) {
            this.renderInWorld(renderContext.getPoseStack(), x, y);
        } else {
            this.renderForHud(renderContext.getGuiGraphics(), x, y);
        }
    }

    public void renderForHud(GuiGraphics guiGraphics, float x, float y) {
        if (ARGB.alpha((int)this.colour0) == 0 && ARGB.alpha((int)this.colour1) == 0 && ARGB.alpha((int)this.colour2) == 0 && ARGB.alpha((int)this.colour3) == 0) {
            return;
        }
        int xMin = Mth.floor((float)x);
        int yMin = Mth.floor((float)y);
        int xMax = Math.round((float)xMin + this.width);
        int yMax = Math.round((float)yMin + this.height);
        guiGraphics.guiRenderState.submitGuiElement((GuiElementRenderState)new RenderState(this.renderPipeline, TextureSetup.noTexture(), new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()), xMin, yMin, xMax, yMax, this.colour0, this.colour1, this.colour2, this.colour3, guiGraphics.scissorStack.peek()));
    }

    public void renderInWorld(PoseStack poseStack, float x, float y) {
        if (ARGB.alpha((int)this.colour0) == 0 && ARGB.alpha((int)this.colour1) == 0 && ARGB.alpha((int)this.colour2) == 0 && ARGB.alpha((int)this.colour3) == 0) {
            return;
        }
        int xMin = Mth.floor((float)x);
        int yMin = Mth.floor((float)y);
        int xMax = Math.round((float)xMin + this.width);
        int yMax = Math.round((float)yMin + this.height);
        Matrix4f pose = poseStack.last().pose();
        VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.textBackgroundSeeThrough());
        buffer.addVertex(pose, (float)xMin, (float)yMin, 0.0f).setColor(this.colour0);
        buffer.addVertex(pose, (float)xMin, (float)yMax, 0.0f).setColor(this.colour1);
        buffer.addVertex(pose, (float)xMax, (float)yMax, 0.0f).setColor(this.colour2);
        buffer.addVertex(pose, (float)xMax, (float)yMin, 0.0f).setColor(this.colour3);
    }

    record RenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f pose, int x0, int y0, int x1, int y1, int colour1, int colour2, int colour3, int colour4, @Nullable ScreenRectangle scissorArea, @Nullable ScreenRectangle bounds) implements GuiElementRenderState
    {
        RenderState(RenderPipeline pipeline, TextureSetup textureSetup, Matrix3x2f pose, int x0, int y0, int x1, int y1, int colour1, int colour2, int colour3, int colour4, @Nullable ScreenRectangle scissorRegion) {
            this(pipeline, textureSetup, pose, x0, y0, x1, y1, colour1, colour2, colour3, colour4, scissorRegion, RenderState.getBounds(x0, y0, x1, y1, pose, scissorRegion));
        }

        public void buildVertices(VertexConsumer vertexConsumer, float depth) {
            vertexConsumer.addVertexWith2DPose(this.pose(), (float)this.x0(), (float)this.y0(), depth).setColor(this.colour1);
            vertexConsumer.addVertexWith2DPose(this.pose(), (float)this.x0(), (float)this.y1(), depth).setColor(this.colour2);
            vertexConsumer.addVertexWith2DPose(this.pose(), (float)this.x1(), (float)this.y1(), depth).setColor(this.colour3);
            vertexConsumer.addVertexWith2DPose(this.pose(), (float)this.x1(), (float)this.y0(), depth).setColor(this.colour4);
        }

        @Nullable
        private static ScreenRectangle getBounds(int x0, int y0, int x1, int y1, Matrix3x2f pose, @Nullable ScreenRectangle scissorRegion) {
            ScreenRectangle rect = new ScreenRectangle(x0, y0, x1 - x0, y1 - y0).transformMaxBounds(pose);
            return scissorRegion != null ? scissorRegion.intersection(rect) : rect;
        }
    }
}

