/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud;

import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.Util;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAttachment;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESTextures;
import net.tslat.tes.api.object.TESHudElement;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.TESClientUtil;
import net.tslat.tes.api.util.TESRenderUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.core.hud.element.BuiltinHudElements;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;
import org.joml.Matrix3x2fStack;

public class TESHud {
    private static final Map<String, TESHudElement> ELEMENTS = (Map)Util.make(Collections.synchronizedMap(new Object2ObjectArrayMap()), map -> {
        map.put("EntityName", BuiltinHudElements::renderEntityName);
        map.put("HealthBar", BuiltinHudElements::renderEntityHealth);
        map.put("Stats", BuiltinHudElements::renderEntityStats);
        map.put("Icons", BuiltinHudElements::renderEntityIcons);
        map.put("Effects", BuiltinHudElements::renderEntityEffects);
        map.put("HorseStats", BuiltinHudElements::renderHorseStats);
    });
    protected static final List<TESHudEntityIcon> ENTITY_ICONS = (List)Util.make(new CopyOnWriteArrayList(), list -> list.addAll(List.of(TESHudEntityIcon.makeGeneric(TESTextures.PROPERTY_FIRE_IMMUNE, TESUtil::isFireImmune), TESHudEntityIcon.makeGeneric(TESTextures.PROPERTY_MELEE, TESUtil::isMeleeMob), TESHudEntityIcon.makeGeneric(TESTextures.PROPERTY_RANGED, TESUtil::isRangedMob), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_AQUATIC, entity -> entity.getType().is(EntityTypeTags.AQUATIC)), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_ILLAGER, entity -> entity.getType().is(EntityTypeTags.ILLAGER)), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_ARTHROPOD, entity -> entity.getType().is(EntityTypeTags.ARTHROPOD)), TESHudEntityIcon.makeGeneric(TESTextures.ENTITY_TYPE_UNDEAD, entity -> entity.getType().is(EntityTypeTags.UNDEAD)))));
    private static TESHudElement[] INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
    private static LivingEntity TARGET_ENTITY = null;
    private static long TARGET_EXPIRY_TIME = -1L;

    public static void setTargetEntity(LivingEntity entity) {
        TARGET_ENTITY = entity;
        TARGET_EXPIRY_TIME = Mth.floor((double)(Blaze3D.getTime() * 20.0)) + 1 + TESAPI.getConfig().hudTargetGracePeriod();
    }

    public static LivingEntity getTargetEntity() {
        return TARGET_ENTITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addHudElement(String name, TESHudElement element) {
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            ELEMENTS.put(name, element);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeHudElement(String name) {
        AtomicBoolean removed = new AtomicBoolean(false);
        Map<String, TESHudElement> map = ELEMENTS;
        synchronized (map) {
            removed.set(ELEMENTS.remove(name) != null);
            INVERSE_ELEMENTS = TESHud.buildInverseElementArray(ELEMENTS.values());
        }
        return removed.get();
    }

    public static void addHudEntityIcon(TESHudEntityIcon icon) {
        ENTITY_ICONS.add(icon);
    }

    public static void renderForHud(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker) {
        if (TARGET_ENTITY == null) {
            return;
        }
        if (TARGET_ENTITY.isRemoved() || TARGET_ENTITY.level() != mc.level || (long)Mth.floor((double)(Blaze3D.getTime() * 20.0)) > TARGET_EXPIRY_TIME) {
            TARGET_ENTITY = null;
            return;
        }
        TESConfig config = TESAPI.getConfig();
        if (!config.hudEnabled() || Minecraft.getInstance().options.hideGui || !config.hudBossesEnabled() && TESConstants.UTILS.isBossEntity(TARGET_ENTITY)) {
            return;
        }
        float hudOpacity = config.hudOpacity();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        config.hudRenderPosition().adjustRenderForHudPosition(guiGraphics);
        if (TESAPI.getConfig().hudEntityRender()) {
            TESRenderUtil.renderEntityIcon(guiGraphics, mc, deltaTracker, TARGET_ENTITY, hudOpacity, true);
            poseStack.translate(40.0f, 0.0f);
        }
        poseStack.translate(0.0f, 2.0f);
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_3D);
        TESHudRenderContext renderContext = TESHudRenderContext.guiContext(guiGraphics);
        for (TESHudElement element : ELEMENTS.values()) {
            int offset = element.render(renderContext, mc, deltaTracker, TARGET_ENTITY, hudOpacity);
            if (offset <= 0) continue;
            poseStack.translate(0.0f, (float)(2 + offset));
        }
        poseStack.popMatrix();
    }

    public static void renderInWorld(PoseStack poseStack, LivingEntity entity, DeltaTracker deltaTracker) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || !entityState.isValid()) {
            return;
        }
        entityState.markActive();
        Minecraft mc = Minecraft.getInstance();
        TESConfig config = TESAPI.getConfig();
        if (!config.inWorldBarsEnabled() || entity.getSelfAndPassengers().anyMatch(passenger -> passenger == mc.player) && !config.inWorldHudForSelf() || !config.inWorldHUDActivation().test(entityState) || !config.inWorldHudBossesEnabled() && TESConstants.UTILS.isBossEntity(TARGET_ENTITY)) {
            return;
        }
        float partialTick = deltaTracker.getGameTimeDeltaPartialTick(!entity.level().tickRateManager().isEntityFrozen((Entity)entity));
        float hudOpacity = config.inWorldHudOpacity();
        EntityRenderer renderer = mc.getEntityRenderDispatcher().getRenderer((Entity)entity);
        Vec3 position = entity.getPosition(partialTick).subtract(mc.gameRenderer.getMainCamera().getPosition()).add(renderer.getRenderOffset(renderer.createRenderState((Entity)entity, partialTick)));
        Vec3 nameTagOffset = entity.getAttachments().getNullable(EntityAttachment.NAME_TAG, 0, entity.getYRot(partialTick));
        if (nameTagOffset == null) {
            nameTagOffset = new Vec3(0.0, (double)entity.getBbHeight(), 0.0);
        }
        nameTagOffset = nameTagOffset.add(0.0, 0.5, 0.0);
        poseStack.pushPose();
        poseStack.translate(position.x, position.y, position.z);
        poseStack.translate(nameTagOffset);
        poseStack.translate(0.0f, config.inWorldHudManualVerticalOffset(), 0.0f);
        TESRenderUtil.positionFacingCamera(poseStack);
        poseStack.scale(0.02f, 0.02f, 0.02f);
        TESHudRenderContext renderContext = TESHudRenderContext.inWorldContext(poseStack, mc.renderBuffers().bufferSource(), mc.getEntityRenderDispatcher().getRenderer((Entity)entity).getPackedLightCoords((Entity)entity, partialTick));
        for (TESHudElement element : INVERSE_ELEMENTS) {
            int offset = element.render(renderContext, mc, deltaTracker, entity, hudOpacity);
            if (offset <= 0) continue;
            poseStack.translate(0.0f, (float)(-(2 + offset)), 0.0f);
        }
        poseStack.popPose();
    }

    public static void pickNewEntity(float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.crosshairPickEntity != null) {
            LivingEntity target = TESConstants.UTILS.getLivingEntityIfPossible(mc.crosshairPickEntity);
            if (target != null && TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                TESHud.setTargetEntity(target);
            }
        } else {
            AABB hitBounds;
            Vec3 cameraView;
            Vec3 rayEnd;
            Vec3 cameraPos;
            double targetingRange = TESAPI.getConfig().hudTargetDistance();
            Entity cameraEntity = mc.getCameraEntity();
            EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Entity)cameraEntity, (Vec3)(cameraPos = cameraEntity.getEyePosition(partialTick)), (Vec3)(rayEnd = cameraPos.add((cameraView = cameraEntity.getViewVector(partialTick)).multiply(targetingRange, targetingRange, targetingRange))), (AABB)(hitBounds = cameraEntity.getBoundingBox().expandTowards(cameraView.scale(targetingRange)).inflate(1.0, 1.0, 1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)(targetingRange * targetingRange));
            if (hitResult == null) {
                return;
            }
            LivingEntity target = TESConstants.UTILS.getLivingEntityIfPossible(hitResult.getEntity());
            if (target == null || !TESUtil.shouldTESHandleEntity(target, TESClientUtil.getClientPlayer())) {
                return;
            }
            double entityHitClipDistanceSqr = hitResult.getLocation().distanceToSqr(cameraPos);
            targetingRange = Math.sqrt(entityHitClipDistanceSqr);
            rayEnd = cameraPos.add(cameraView.multiply(targetingRange, targetingRange, targetingRange));
            BlockHitResult blockHitResult = cameraEntity.level().clip(new ClipContext(cameraPos, rayEnd, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, cameraEntity));
            if (blockHitResult == null || blockHitResult.getType() == HitResult.Type.MISS || blockHitResult.getLocation().distanceToSqr(cameraPos) > entityHitClipDistanceSqr) {
                TESHud.setTargetEntity(target);
            }
        }
    }

    public static List<TESHudEntityIcon> getEntityIcons() {
        return ENTITY_ICONS;
    }

    private static TESHudElement[] buildInverseElementArray(Collection<TESHudElement> elements) {
        TESHudElement[] array = new TESHudElement[elements.size()];
        int i = elements.size() - 1;
        for (TESHudElement element : elements) {
            array[i--] = element;
        }
        return array;
    }

    public static enum BarRenderType {
        NUMERIC,
        BAR,
        BAR_ICONS,
        COMBINED;

    }
}

