/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.object;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import org.apache.commons.lang3.function.TriConsumer;

public record TESHudRenderContext(Either<GuiGraphics, InWorldArgs> args) {
    public static TESHudRenderContext guiContext(GuiGraphics guiGraphics) {
        return new TESHudRenderContext((Either<GuiGraphics, InWorldArgs>)Either.left((Object)guiGraphics));
    }

    public static TESHudRenderContext inWorldContext(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int packedLight) {
        return new TESHudRenderContext((Either<GuiGraphics, InWorldArgs>)Either.right((Object)new InWorldArgs(poseStack, bufferSource, packedLight)));
    }

    public boolean isInWorld() {
        return this.args.right().isPresent();
    }

    public TESHudRenderContext forGui(Consumer<GuiGraphics> guiConsumer) {
        this.args.ifLeft(guiConsumer);
        return this;
    }

    public TESHudRenderContext forInWorld(TriConsumer<PoseStack, MultiBufferSource.BufferSource, Integer> inWorldConsumer) {
        this.args.ifRight(inWorldArgs -> inWorldConsumer.accept((Object)inWorldArgs.poseStack, (Object)inWorldArgs.bufferSource, (Object)inWorldArgs.packedLight));
        return this;
    }

    public void pushMatrix() {
        if (this.isInWorld()) {
            ((InWorldArgs)this.args.right().get()).poseStack.pushPose();
        } else {
            ((GuiGraphics)this.args().left().get()).pose().pushMatrix();
        }
    }

    public void popMatrix() {
        if (this.isInWorld()) {
            ((InWorldArgs)this.args.right().get()).poseStack.popPose();
        } else {
            ((GuiGraphics)this.args().left().get()).pose().popMatrix();
        }
    }

    public void translate(float x, float y, float z) {
        if (this.isInWorld()) {
            ((InWorldArgs)this.args.right().get()).poseStack.translate(x, y, z);
        } else {
            ((GuiGraphics)this.args().left().get()).pose().translate(x, y);
        }
    }

    public void scale(float x, float y, float z) {
        if (this.isInWorld()) {
            ((InWorldArgs)this.args.right().get()).poseStack.scale(x, y, z);
        } else {
            ((GuiGraphics)this.args().left().get()).pose().scale(x, y);
        }
    }

    public GuiGraphics getGuiGraphics() {
        if (this.isInWorld()) {
            throw new IllegalStateException("Cannot get GuiGraphics from in-world render context");
        }
        return (GuiGraphics)this.args.left().get();
    }

    public PoseStack getPoseStack() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get PoseStack from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).poseStack;
    }

    public MultiBufferSource.BufferSource getBufferSource() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get BufferSource from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).bufferSource;
    }

    public int getPackedLight() {
        if (!this.isInWorld()) {
            throw new IllegalStateException("Cannot get BufferSource from in-world render context");
        }
        return ((InWorldArgs)this.args.right().get()).packedLight;
    }

    public record InWorldArgs(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, int packedLight) {
    }
}

