/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESTextures;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.render.TextureRenderHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public final class TESRenderUtil {
    public static TextureAtlasSprite getAtlasSprite(ResourceLocation texture) {
        return Minecraft.getInstance().getGuiSprites().getSprite(texture);
    }

    public static void centerTextForRender(Component text, float x, float y, BiConsumer<Float, Float> renderRunnable) {
        Float f = Float.valueOf(x - (float)Minecraft.getInstance().font.width((FormattedText)text) / 2.0f);
        Objects.requireNonNull(Minecraft.getInstance().font);
        renderRunnable.accept(f, Float.valueOf(y + (float)(9 - 1) / 2.0f));
    }

    public static int colourGradeForLerp(double value, double minValue, double maxValue) {
        return TESRenderUtil.colourGradeForValue((value - minValue) / (maxValue - minValue));
    }

    public static int colourGradeForValue(double value) {
        return Mth.hsvToArgb((float)((float)Mth.clamp((double)((double)0.35f * value), (double)0.0, (double)0.35f)), (float)1.0f, (float)1.0f, (int)255);
    }

    public static void positionFacingCamera(PoseStack poseStack) {
        poseStack.scale(-1.0f, -1.0f, -1.0f);
        poseStack.mulPose((Quaternionfc)Minecraft.getInstance().gameRenderer.getMainCamera().rotation());
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
    }

    public static void renderBar(TESHudRenderContext renderContext, int x, int y, int barWidth, float completionPercentage, float transitionPercentage, float opacity, TextureAtlasSprite background, TextureAtlasSprite emptyBar, TextureAtlasSprite filledBar, @Nullable TextureAtlasSprite overlayBar) {
        TESRenderUtil.renderBarLayer(renderContext, x, y, background, barWidth, 1.0f, opacity);
        renderContext.translate(0.0f, 0.0f, 0.01f);
        TESRenderUtil.renderBarLayer(renderContext, x, y, emptyBar, barWidth, transitionPercentage, opacity);
        renderContext.translate(0.0f, 0.0f, 0.01f);
        TESRenderUtil.renderBarLayer(renderContext, x, y, filledBar, barWidth, completionPercentage, opacity);
        if (overlayBar != null) {
            renderContext.translate(0.0f, 0.0f, 0.01f);
            if (renderContext.isInWorld()) {
                renderContext.getBufferSource().endLastBatch();
            }
            TESRenderUtil.renderBarLayer(renderContext, x, y, overlayBar, barWidth, 1.0f, 0.75f * opacity);
        }
    }

    public static void renderBarLayer(TESHudRenderContext renderContext, int x, int y, TextureAtlasSprite sprite, float barWidth, float filledPercent, float opacity) {
        TextureRenderHelper barRight;
        float pixelWidth = sprite.contents().width();
        float barPercent = Math.round(barWidth * filledPercent);
        float pixelPercent = Math.round(pixelWidth * filledPercent);
        float midBarWidth = barWidth - 10.0f;
        float leftEndPixels = Math.min(5.0f, Math.min(barPercent, pixelPercent));
        float rightEndPixels = Math.min(5.0f, 5.0f - (pixelWidth - pixelPercent));
        TextureRenderHelper barLeft = TextureRenderHelper.of(sprite).uWidth(leftEndPixels).width(leftEndPixels).colour(ARGB.white((float)opacity));
        TextureRenderHelper barMiddle = pixelWidth <= 10.0f || midBarWidth <= 0.0f || barPercent <= 10.0f ? null : TextureRenderHelper.of(sprite).uWidth(pixelPercent - 10.0f).uOffset(5.0f).width(barPercent >= barWidth - 5.0f ? midBarWidth : barPercent - 10.0f).colour(ARGB.white((float)opacity));
        TextureRenderHelper textureRenderHelper = barRight = rightEndPixels <= 0.0f || barPercent - 5.0f <= 0.0f ? null : TextureRenderHelper.of(sprite).uWidth(rightEndPixels).uOffset(pixelWidth - 5.0f).width(Math.min(5.0f, rightEndPixels)).colour(ARGB.white((float)opacity));
        if (renderContext.isInWorld()) {
            int packedLight = renderContext.getPackedLight();
            barLeft.lightLevel(packedLight);
            if (barMiddle != null) {
                barMiddle.lightLevel(packedLight);
            }
            if (barRight != null) {
                barRight.lightLevel(packedLight);
            }
        }
        barLeft.render(renderContext, x, y);
        if (barMiddle != null) {
            barMiddle.render(renderContext, x + 5, y);
        }
        if (barRight != null) {
            barRight.render(renderContext, (float)(x + 5) + midBarWidth, y);
        }
    }

    public static void renderEntityIcon(GuiGraphics guiGraphics, Minecraft mc, DeltaTracker deltaTracker, LivingEntity entity, float opacity, boolean includeFrame) {
        TESConfig config = TESAPI.getConfig();
        float scale = 0.04f * (float)Math.pow(Math.min(30.0f / entity.getBbWidth(), 40.0f / entity.getBbHeight()), 0.95f) * -20.0f;
        boolean scissor = config.hudPreventEntityOverflow();
        if (scissor) {
            guiGraphics.enableScissor(2, 2, 36, 47);
        }
        if (includeFrame) {
            TextureRenderHelper.ofSprite(TESTextures.ENTITY_ICON_FRAME).colour(ARGB.white((float)(0.5f * opacity))).renderForHud(guiGraphics, 2.0f, 2.0f);
        }
        float yBodyRotPrev = entity.yBodyRot;
        float yRotPrev = entity.getYRot();
        float xRotPrev = entity.getXRot();
        float yHeadRotOldPrev = entity.yHeadRotO;
        float yHeadRotPrev = entity.yHeadRot;
        int hurtTicks = entity.hurtTime;
        float attackTimePrev = entity.attackAnim;
        float attackTimeOldPrev = entity.oAttackAnim;
        Component displayName = entity.getCustomName();
        entity.setYRot(22.5f);
        entity.setXRot(0.0f);
        entity.yBodyRot = 22.5f;
        entity.yHeadRot = entity.getYRot();
        entity.yHeadRotO = entity.getYRot();
        entity.hurtTime = config.hudEntityDamageOverlay() ? entity.hurtTime : 0;
        entity.attackAnim = 0.0f;
        entity.oAttackAnim = 0.0f;
        entity.setCustomName(null);
        EntityRenderState renderState = mc.getEntityRenderDispatcher().getRenderer((Entity)entity).createRenderState((Entity)entity, 1.0f);
        renderState.hitboxesRenderState = null;
        guiGraphics.submitEntityRenderState(renderState, scale / entity.getScale(), new Vector3f(0.0f, entity.getBbHeight() * -0.5f, 0.0f), new Quaternionf(), null, 2, 2, 36, 47);
        entity.setCustomName(displayName);
        entity.setYRot(yRotPrev);
        entity.setXRot(xRotPrev);
        entity.yBodyRot = yBodyRotPrev;
        entity.yHeadRot = yHeadRotPrev;
        entity.yHeadRotO = yHeadRotOldPrev;
        entity.hurtTime = hurtTicks;
        entity.attackAnim = attackTimePrev;
        entity.oAttackAnim = attackTimeOldPrev;
        if (scissor) {
            guiGraphics.disableScissor();
        }
    }
}

