/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.object.TESParticle;
import net.tslat.tes.core.particle.TESParticleClaimant;
import net.tslat.tes.core.particle.TESParticleSourceHandler;
import net.tslat.tes.core.state.EntityState;

public final class TESParticleManager {
    private static final ConcurrentLinkedQueue<TESParticle<?>> PARTICLES = new ConcurrentLinkedQueue();
    private static final Object2ObjectOpenHashMap<ResourceLocation, TESParticleClaimant> CLAIMANTS = new Object2ObjectOpenHashMap();
    private static final ConcurrentMap<Integer, List<Pair<ResourceLocation, Optional<CompoundTag>>>> CLAIMS = new ConcurrentHashMap<Integer, List<Pair<ResourceLocation, Optional<CompoundTag>>>>();
    private static final ObjectArrayList<TESParticleSourceHandler> HANDLERS = new ObjectArrayList();
    private static final ObjectArrayList<Runnable> NEW_CLAIMS = new ObjectArrayList();

    public static void addParticle(TESParticle<?> particle) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        PARTICLES.add(particle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParticleClaimant(ResourceLocation id, TESParticleClaimant claimant) {
        Object2ObjectOpenHashMap<ResourceLocation, TESParticleClaimant> object2ObjectOpenHashMap = CLAIMANTS;
        synchronized (object2ObjectOpenHashMap) {
            CLAIMANTS.put((Object)id, (Object)claimant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerParticleSourceHandler(TESParticleSourceHandler handler) {
        ObjectArrayList<TESParticleSourceHandler> objectArrayList = HANDLERS;
        synchronized (objectArrayList) {
            HANDLERS.add((Object)handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addParticleClaim(int entityId, ResourceLocation claimantId, Optional<CompoundTag> data) {
        if (!TESAPI.getConfig().particlesEnabled()) {
            return;
        }
        ObjectArrayList<Runnable> objectArrayList = NEW_CLAIMS;
        synchronized (objectArrayList) {
            NEW_CLAIMS.add(() -> CLAIMS.computeIfAbsent(entityId, key -> new ObjectArrayList()).add(Pair.of((Object)claimantId, (Object)data)));
        }
    }

    public static float handleParticleClaims(EntityState entityState, float healthDelta, Consumer<TESParticle<?>> particleAdder, boolean checkSourceHandlers) {
        Pair pair;
        ObjectListIterator objectListIterator = CLAIMS.getOrDefault(entityState.getEntity().getId(), List.of()).iterator();
        while (objectListIterator.hasNext() && (healthDelta = ((TESParticleClaimant)CLAIMANTS.getOrDefault((pair = (Pair)objectListIterator.next()).getFirst(), (state, delta, data, adder) -> delta)).checkClaim(entityState, healthDelta, (Optional)pair.getSecond(), particleAdder)) != 0.0f) {
        }
        if (checkSourceHandlers && healthDelta < 0.0f) {
            for (TESParticleSourceHandler handler : HANDLERS) {
                if (!handler.checkIncomingDamage(entityState, -healthDelta, entityState.getEntity().getLastDamageSource(), particleAdder)) continue;
                healthDelta = 0.0f;
                break;
            }
        }
        return healthDelta;
    }

    public static void tick() {
        Minecraft mc = Minecraft.getInstance();
        if (!mc.isPaused() && mc.level != null && !mc.level.tickRateManager().isFrozen()) {
            if (!TESAPI.getConfig().particlesEnabled()) {
                PARTICLES.clear();
                CLAIMS.clear();
                return;
            }
            PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.tick(mc)));
            PARTICLES.removeIf(particle -> !particle.isValid());
        }
    }

    public static void clearClaims() {
        CLAIMS.clear();
        NEW_CLAIMS.forEach(Runnable::run);
        NEW_CLAIMS.clear();
    }

    public static void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        Font fontRenderer = mc.font;
        PARTICLES.forEach((Consumer<TESParticle<?>>)((Consumer<TESParticle>)particle -> particle.render(poseStack, bufferSource, mc, fontRenderer, partialTick)));
    }
}

