/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util.render;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_11247;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_379;
import net.minecraft.class_382;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5224;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8030;
import net.minecraft.class_9848;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.object.TextRenderStyle;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;

public class TextRenderHelper {
    private final class_2561 component;
    private TextRenderStyle style = TextRenderStyle.NORMAL;
    private class_327 font;
    private int textColour;
    private int secondaryColour;
    private int packedLight;
    private boolean centered;
    private int wrapWidth;
    private int backdropColour;

    TextRenderHelper(class_2561 component) {
        this.font = class_310.method_1551().field_1772;
        this.textColour = -1;
        this.secondaryColour = -1;
        this.packedLight = 0xF000F0;
        this.centered = false;
        this.wrapWidth = -1;
        this.backdropColour = 0;
        this.component = component;
    }

    public static TextRenderHelper of(String text) {
        return TextRenderHelper.of((class_2561)class_2561.method_43470((String)text));
    }

    public static TextRenderHelper of(class_2561 component) {
        return new TextRenderHelper(component);
    }

    public TextRenderHelper style(TextRenderStyle style) {
        this.style = style;
        return this;
    }

    public TextRenderHelper colour(int colour) {
        this.textColour = colour;
        return this;
    }

    public TextRenderHelper centered() {
        return this.centered(true);
    }

    public TextRenderHelper centered(boolean centered) {
        this.centered = centered;
        return this;
    }

    public TextRenderHelper wrapWidth(int wrapWidth) {
        this.wrapWidth = wrapWidth;
        return this;
    }

    public TextRenderHelper font(class_327 font) {
        this.font = font;
        return this;
    }

    public TextRenderHelper lightLevel(int packedLight) {
        this.packedLight = packedLight;
        return this;
    }

    public TextRenderHelper withBackdrop() {
        return this.withBackdrop(class_310.method_1551().field_1690.method_19345(0.0f));
    }

    public TextRenderHelper withBackdrop(int colour) {
        this.backdropColour = colour;
        return this;
    }

    public TextRenderHelper colour(int red, int green, int blue, int alpha) {
        return this.colour(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextRenderHelper colour(float red, float green, float blue, float alpha) {
        return this.colour(class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextRenderHelper colour(float red, float green, float blue) {
        return this.colour(red, green, blue, 1.0f);
    }

    public TextRenderHelper colour(int red, int green, int blue) {
        return this.colour(red, green, blue, 255);
    }

    public TextRenderHelper secondaryColour(int colour) {
        this.textColour = colour;
        return this;
    }

    public TextRenderHelper secondaryColour(int red, int green, int blue, int alpha) {
        return this.secondaryColour(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextRenderHelper secondaryColour(float red, float green, float blue, float alpha) {
        return this.secondaryColour(class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextRenderHelper secondaryColour(float red, float green, float blue) {
        return this.secondaryColour(red, green, blue, 1.0f);
    }

    public TextRenderHelper secondaryColour(int red, int green, int blue) {
        return this.secondaryColour(red, green, blue, 255);
    }

    public void render(TESHudRenderContext renderContext, float x, float y) {
        if (renderContext.isInWorld()) {
            TESHudRenderContext.InWorldArgs args = (TESHudRenderContext.InWorldArgs)renderContext.args().right().get();
            this.renderInWorld(args.poseStack(), args.bufferSource(), x, y);
        } else {
            this.renderForHud(renderContext.getGuiGraphics(), x, y);
        }
    }

    public void renderForHud(class_332 guiGraphics, float x, float y) {
        if (class_9848.method_61320((int)this.textColour) == 0 && class_9848.method_61320((int)this.secondaryColour) == 0) {
            return;
        }
        Style style = Style.fromTextRenderStyle(this.style);
        int shadowColour = this.secondaryColour == -1 ? (Integer)style.colourFunction.apply((Object)this.textColour) : this.secondaryColour;
        int stringWidth = this.font.method_27525((class_5348)this.component);
        int width = this.wrapWidth == -1 ? stringWidth : Math.min(stringWidth, this.wrapWidth);
        int posX = class_3532.method_15375((float)x) - (this.centered ? width / 2 : 0);
        int posY = class_3532.method_15375((float)y);
        class_5481 charSequence = this.component.method_30937();
        Matrix3x2f pose = new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448());
        for (Pair<class_327.class_11465, class_8030> text : style.renderFunction.prepare(this.font, charSequence, posX, posY, this.textColour, shadowColour, this.backdropColour, this.packedLight, (Either<Matrix3x2f, Matrix4f>)Either.left((Object)pose), guiGraphics.field_44659.method_70863(), null)) {
            RenderState renderState = new RenderState((class_327.class_11465)text.getFirst(), this.font, charSequence, pose, posX, posY, this.textColour, shadowColour, guiGraphics.field_44659.method_70863());
            renderState.field_60752 = (class_8030)text.getSecond();
            guiGraphics.field_59826.method_70921((class_11247)renderState);
        }
    }

    public void renderInWorld(class_4587 poseStack, class_4597.class_4598 bufferSource, float x, float y) {
        if (class_9848.method_61320((int)this.textColour) == 0 && class_9848.method_61320((int)this.secondaryColour) == 0) {
            return;
        }
        Style style = Style.fromTextRenderStyle(this.style);
        int shadowColour = this.secondaryColour == -1 ? (Integer)style.colourFunction.apply((Object)this.textColour) : this.secondaryColour;
        int stringWidth = this.font.method_27525((class_5348)this.component);
        int width = this.wrapWidth == -1 ? stringWidth : Math.min(stringWidth, this.wrapWidth);
        int posX = class_3532.method_15375((float)x) - (this.centered ? width / 2 : 0);
        int posY = class_3532.method_15375((float)y);
        class_5481 charSequence = this.component.method_30937();
        style.renderFunction.prepare(this.font, charSequence, posX, posY, this.textColour, shadowColour, this.backdropColour, this.packedLight, (Either<Matrix3x2f, Matrix4f>)Either.right((Object)poseStack.method_23760().method_23761()), null, bufferSource);
    }

    static class_327.class_5232 configurablePreparedText(final class_327 font, float x, float y, int colour, final int shadowColour, int backgroundColour, final boolean dropShadow) {
        class_327 class_3272 = font;
        Objects.requireNonNull(class_3272);
        return new class_327.class_5232(class_3272, x, y, colour, backgroundColour, dropShadow){
            {
                class_327 class_3273 = x0;
                Objects.requireNonNull(class_3273);
                super(class_3273, f, g, i, j, bl);
            }

            public int method_65177(class_2583 textStyle, int textColour) {
                if (dropShadow && shadowColour != 0) {
                    return shadowColour;
                }
                Integer textStyleColour = textStyle.method_65301();
                if (textStyleColour != null) {
                    float textAlpha = class_9848.method_65100((int)textColour);
                    float shadowAlpha = class_9848.method_65100((int)textStyleColour);
                    return textAlpha != 1.0f ? class_9848.method_61330((int)class_9848.method_61326((float)(textAlpha * shadowAlpha)), (int)textStyleColour) : textStyleColour;
                }
                return 0;
            }

            public void method_71801(class_327.class_11464 glyphVisitor) {
                class_382 bakedGlyph = null;
                if (class_9848.method_61320((int)this.field_54818) != 0) {
                    class_382.class_328 effect = new class_382.class_328(this.field_60703, this.field_60704, this.field_60705, this.field_60706, -0.02f, this.field_54818);
                    bakedGlyph = font.method_27526(class_2583.field_24359).method_22943();
                    glyphVisitor.method_71798(bakedGlyph, effect);
                }
                for (class_382.class_10364 glyph : this.field_60707) {
                    glyphVisitor.method_71797(glyph);
                }
                if (this.field_24252 != null) {
                    if (bakedGlyph == null) {
                        bakedGlyph = font.method_27526(class_2583.field_24359).method_22943();
                    }
                    for (class_382.class_328 effect : this.field_24252) {
                        glyphVisitor.method_71798(bakedGlyph, effect);
                    }
                }
            }
        };
    }

    static class_327.class_11464 getWorldspaceGlyphVisitor(final class_4597 bufferSource, final Matrix4f pose, final class_327.class_6415 displayMode, final int packedLight, final boolean dropShadow) {
        return new class_327.class_11464(){

            public void method_71797(class_382.class_10364 glyph) {
                class_382 bakedGlyph = glyph.comp_3316();
                class_4588 vertexconsumer = bufferSource.getBuffer(bakedGlyph.method_24045(displayMode));
                2.renderDropShadowFriendlyGlyph(bakedGlyph, glyph, vertexconsumer, pose, packedLight, dropShadow);
            }

            public void method_71798(class_382 bakedGlyph, class_382.class_328 glyphEffect) {
                class_4588 vertexconsumer = bufferSource.getBuffer(bakedGlyph.method_24045(displayMode));
                bakedGlyph.method_22944(glyphEffect, pose, vertexconsumer, packedLight, dropShadow);
            }

            private static void renderDropShadowFriendlyGlyph(class_382 glyph, class_382.class_10364 glyphInstance, class_4588 buffer, Matrix4f pose2, int packedLight2, boolean dropShadow2) {
                float zDepth;
                float dropShadowOffset;
                class_2583 style = glyphInstance.comp_3317();
                boolean italic = style.method_10966();
                boolean bold = style.method_10984();
                float x = glyphInstance.comp_3313();
                float y = glyphInstance.comp_3314();
                int colour = glyphInstance.comp_3315();
                float f = dropShadowOffset = dropShadow2 ? 0.001f : 0.0f;
                if (glyphInstance.method_65184()) {
                    int shadowColour = glyphInstance.comp_3338();
                    glyph.method_2025(italic, x + glyphInstance.comp_3339(), y + glyphInstance.comp_3339(), 0.0f, pose2, buffer, shadowColour, bold, packedLight2);
                    if (bold) {
                        glyph.method_2025(italic, x + glyphInstance.comp_3318() + glyphInstance.comp_3339(), y + glyphInstance.comp_3339(), dropShadowOffset, pose2, buffer, shadowColour, true, packedLight2);
                    }
                    zDepth = dropShadow2 ? 0.006f : 0.0f;
                } else {
                    zDepth = 0.0f;
                }
                glyph.method_2025(italic, x, y, zDepth, pose2, buffer, colour, bold, packedLight2);
                if (bold) {
                    glyph.method_2025(italic, x + glyphInstance.comp_3318(), y, zDepth + dropShadowOffset, pose2, buffer, colour, true, packedLight2);
                }
            }
        };
    }

    public static enum Style {
        NORMAL(Style::renderDefault, colour -> -16777216),
        DROP_SHADOW(Style::renderDropShadow, colour -> class_9848.method_61321((int)colour, (float)0.25f)),
        GLOWING(Style::renderOutlined, colour -> class_9848.method_61321((int)colour, (float)0.5f)),
        OUTLINED(Style::renderOutlined, colour -> -16777216);

        final RenderFunction renderFunction;
        final Int2IntFunction colourFunction;

        private Style(RenderFunction renderFunction, Int2IntFunction defaultShadowColour) {
            this.renderFunction = renderFunction;
            this.colourFunction = defaultShadowColour;
        }

        public static Style fromTextRenderStyle(TextRenderStyle style) {
            return switch (style) {
                default -> throw new MatchException(null, null);
                case TextRenderStyle.NORMAL -> NORMAL;
                case TextRenderStyle.DROP_SHADOW -> DROP_SHADOW;
                case TextRenderStyle.GLOWING -> GLOWING;
                case TextRenderStyle.OUTLINED -> OUTLINED;
            };
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderDefault(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            return Style.renderDefault(font, charSequence, x, y, colour, secondaryColour, backgroundColour, packedLight, false, pose, scissor, bufferSource);
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderDropShadow(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            return Style.renderDefault(font, charSequence, x, y, colour, secondaryColour, backgroundColour, packedLight, true, pose, scissor, bufferSource);
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderDefault(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, boolean dropShadow, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            class_327.class_5232 preparedText = TextRenderHelper.configurablePreparedText(font, x, y, colour, secondaryColour, backgroundColour, dropShadow);
            charSequence.accept((class_5224)preparedText);
            return (List)Either.unwrap((Either)pose.mapBoth(pose2d -> {
                class_8030 region = preparedText.method_71800();
                if (region == null) {
                    return null;
                }
                region = region.method_71523(pose2d);
                return List.of(Pair.of((Object)preparedText, (Object)(scissor != null ? scissor.method_49701(region) : region)));
            }, pose3d -> {
                preparedText.method_71801(TextRenderHelper.getWorldspaceGlyphVisitor((class_4597)bufferSource, pose3d, class_327.class_6415.field_33995, packedLight, dropShadow));
                return List.of();
            }));
        }

        private static List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
        class_327.class_11465, @Nullable class_8030>> renderOutlined(class_327 font, class_5481 charSequence, float x, float y, int colour, int secondaryColour, int backgroundColour, int packedLight, Either<Matrix3x2f, Matrix4f> pose, @Nullable class_8030 scissor, @Nullable class_4597.class_4598 bufferSource) {
            class_327.class_5232 outlineText = TextRenderHelper.configurablePreparedText(font, 0.0f, 0.0f, secondaryColour, 0, backgroundColour, false);
            boolean filterFishyGlyphs = font.field_39925;
            float outlineWeight = 0.6f;
            for (int xO = -1; xO <= 1; ++xO) {
                for (int yO = -1; yO <= 1; ++yO) {
                    if (xO == 0 && yO == 0) continue;
                    float[] cumulativeXOffset = new float[]{x};
                    int xOffset = xO;
                    int yOffset = yO;
                    charSequence.accept((charIndex, style, character) -> {
                        class_379 glyphInfo = font.method_27526(style.method_27708()).method_2011(character, filterFishyGlyphs);
                        float shadowOffset = glyphInfo.method_16800() * 0.6f;
                        outlineText.field_24250 = cumulativeXOffset[0] + (float)xOffset * shadowOffset;
                        outlineText.field_24251 = y + (float)yOffset * shadowOffset;
                        cumulativeXOffset[0] = cumulativeXOffset[0] + glyphInfo.method_16798(style.method_10984());
                        return outlineText.accept(charIndex, style.method_36139(backgroundColour), character);
                    });
                }
            }
            class_327.class_5232 text = TextRenderHelper.configurablePreparedText(font, x, y, colour, 0, backgroundColour, false);
            return (List)Either.unwrap((Either)pose.mapBoth(pose2d -> {
                charSequence.accept((class_5224)text);
                class_8030 region = outlineText.method_71800();
                class_8030 bounds = null;
                class_8030 bounds2 = null;
                if (region != null) {
                    region = region.method_71523(pose2d);
                    class_8030 class_80302 = bounds = scissor != null ? scissor.method_49701(region) : region;
                }
                if ((region = text.method_71800()) != null) {
                    region = region.method_71523(pose2d);
                    bounds2 = scissor != null ? scissor.method_49701(region) : region;
                }
                return List.of(Pair.of((Object)outlineText, (Object)bounds), Pair.of((Object)text, bounds2));
            }, pose3d -> {
                class_327.class_11464 glyphVisitor = TextRenderHelper.getWorldspaceGlyphVisitor((class_4597)bufferSource, pose3d, class_327.class_6415.field_33993, packedLight, false);
                for (class_382.class_10364 glyph : outlineText.field_60707) {
                    glyphVisitor.method_71797(glyph);
                }
                charSequence.accept((class_5224)text);
                text.method_71801(TextRenderHelper.getWorldspaceGlyphVisitor((class_4597)bufferSource, pose3d, class_327.class_6415.field_33995, packedLight, false));
                return List.of();
            }));
        }

        @FunctionalInterface
        static interface RenderFunction {
            public List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
            class_327.class_11465, @Nullable class_8030>> prepare(class_327 var1, class_5481 var2, float var3, float var4, int var5, int var6, int var7, int var8, Either<Matrix3x2f, Matrix4f> var9, @Nullable class_8030 var10, @Nullable class_4597.class_4598 var11);
        }
    }

    static class RenderState
    extends class_11247 {
        public RenderState(class_327.class_11465 preparedText, class_327 font, class_5481 charSequence, Matrix3x2f pose, int x, int y, int colour, int secondaryColour, @Nullable class_8030 scissor) {
            super(font, charSequence, pose, x, y, colour, secondaryColour, false, scissor);
            this.field_60751 = preparedText;
        }

        public class_327.class_11465 method_71837() {
            return this.field_60751;
        }
    }
}

