/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.api.util.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11244;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_9848;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.TESRenderUtil;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Matrix4f;

public class TextureRenderHelper {
    private final class_2960 texture;
    private final class_1058 sprite;
    private final GpuTextureView textureView;
    private final float uScale;
    private final float vScale;
    private int lightLevel = 0xF000F0;
    private float width;
    private float height;
    private float uWidth;
    private float vHeight;
    private float uMin;
    private float vMin;
    private int colour = -1;

    TextureRenderHelper(class_2960 texture) {
        this.texture = texture;
        this.sprite = null;
        this.textureView = class_310.method_1551().method_1531().method_4619(texture).method_71659();
        this.uScale = 1.0f / (float)this.textureView.getWidth(0);
        this.vScale = 1.0f / (float)this.textureView.getHeight(0);
    }

    TextureRenderHelper(class_1058 sprite) {
        this.texture = sprite.method_45852();
        this.sprite = sprite;
        this.textureView = class_310.method_1551().method_1531().method_4619(this.texture).method_71659();
        this.width = this.uWidth = (float)sprite.method_45851().method_45807();
        this.height = this.vHeight = (float)sprite.method_45851().method_45815();
        this.uScale = 1.0f / this.width;
        this.vScale = 1.0f / this.height;
    }

    public static TextureRenderHelper of(class_2960 texture) {
        return new TextureRenderHelper(texture);
    }

    public static TextureRenderHelper ofSprite(class_2960 texture) {
        return TextureRenderHelper.of(TESRenderUtil.getAtlasSprite(texture));
    }

    public static TextureRenderHelper of(class_1058 sprite) {
        return new TextureRenderHelper(sprite);
    }

    public TextureRenderHelper sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public TextureRenderHelper width(float width) {
        this.width = width;
        return this;
    }

    public TextureRenderHelper height(float height) {
        this.height = height;
        return this;
    }

    public TextureRenderHelper uWidth(float pixels) {
        this.uWidth = pixels;
        return this;
    }

    public TextureRenderHelper uWidth(Float2FloatFunction pixels) {
        this.uWidth = ((Float)pixels.apply((Object)Float.valueOf(1.0f / this.uScale))).floatValue();
        return this;
    }

    public TextureRenderHelper vHeight(float pixels) {
        this.vHeight = pixels;
        return this;
    }

    public TextureRenderHelper vHeight(Float2FloatFunction pixels) {
        this.vHeight = ((Float)pixels.apply((Object)Float.valueOf(1.0f / this.vScale))).floatValue();
        return this;
    }

    public TextureRenderHelper uOffset(float uMin) {
        this.uMin = uMin;
        return this;
    }

    public TextureRenderHelper uOffset(Float2FloatFunction uMin) {
        this.uMin = ((Float)uMin.apply((Object)Float.valueOf(1.0f / this.uScale))).floatValue();
        return this;
    }

    public TextureRenderHelper vOffset(float vMin) {
        this.vMin = vMin;
        return this;
    }

    public TextureRenderHelper vOffset(Float2FloatFunction vMin) {
        this.vMin = ((Float)vMin.apply((Object)Float.valueOf(1.0f / this.vScale))).floatValue();
        return this;
    }

    public TextureRenderHelper lightLevel(int packedLight) {
        this.lightLevel = packedLight;
        return this;
    }

    public TextureRenderHelper colour(int colour) {
        this.colour = colour;
        return this;
    }

    public TextureRenderHelper colour(int red, int green, int blue, int alpha) {
        return this.colour(class_9848.method_61324((int)alpha, (int)red, (int)green, (int)blue));
    }

    public TextureRenderHelper colour(float red, float green, float blue, float alpha) {
        return this.colour(class_9848.method_61318((float)alpha, (float)red, (float)green, (float)blue));
    }

    public TextureRenderHelper colour(float red, float green, float blue) {
        return this.colour(red, green, blue, 1.0f);
    }

    public TextureRenderHelper colour(int red, int green, int blue) {
        return this.colour(red, green, blue, 255);
    }

    public void render(TESHudRenderContext renderContext, float x, float y) {
        this.render(renderContext, class_10799.field_56883, class_1921::method_23580, x, y);
    }

    public void render(TESHudRenderContext renderContext, RenderPipeline renderPipeline, Function<class_2960, class_1921> renderTypeFunction, float x, float y) {
        if (renderContext.isInWorld()) {
            this.renderInWorld(renderTypeFunction, renderContext.getPoseStack(), x, y);
        } else {
            this.renderForHud(renderContext.getGuiGraphics(), renderPipeline, x, y);
        }
    }

    public void renderForHud(class_332 guiGraphics, float x, float y) {
        this.renderForHud(guiGraphics, class_10799.field_56883, x, y);
    }

    public void renderForHud(class_332 guiGraphics, RenderPipeline renderPipeline, float x, float y) {
        if (class_9848.method_61320((int)this.colour) == 0) {
            return;
        }
        int xMin = class_3532.method_15375((float)x);
        int yMin = class_3532.method_15375((float)y);
        int xMax = Math.round((float)xMin + this.width);
        int yMax = Math.round((float)yMin + this.height);
        float uMin = this.uMin * this.uScale;
        float uMax = (this.uMin + this.uWidth) * this.uScale;
        float vMin = this.vMin * this.vScale;
        float vMax = (this.vMin + this.vHeight) * this.vScale;
        if (this.sprite != null) {
            uMin = this.sprite.method_4580(uMin);
            vMin = this.sprite.method_4570(vMin);
            uMax = this.sprite.method_4580(uMax);
            vMax = this.sprite.method_4570(vMax);
        }
        guiGraphics.field_59826.method_70919((class_11244)new class_11241(renderPipeline, class_11231.method_70900((GpuTextureView)this.textureView), new Matrix3x2f((Matrix3x2fc)guiGraphics.method_51448()), xMin, yMin, xMax, yMax, uMin, uMax, vMin, vMax, this.colour, guiGraphics.field_44659.method_70863()));
    }

    public void renderInWorld(class_4587 poseStack, float x, float y) {
        this.renderInWorld(class_1921::method_23580, poseStack, x, y);
    }

    public void renderInWorld(Function<class_2960, class_1921> renderTypeFunction, class_4587 poseStack, float x, float y) {
        if (class_9848.method_61320((int)this.colour) == 0) {
            return;
        }
        int xMin = class_3532.method_15375((float)x);
        int yMin = class_3532.method_15375((float)y);
        int xMax = Math.round((float)xMin + this.width);
        int yMax = Math.round((float)yMin + this.height);
        float uMin = this.uMin * this.uScale;
        float uMax = (this.uMin + this.uWidth) * this.uScale;
        float vMin = this.vMin * this.vScale;
        float vMax = (this.vMin + this.vHeight) * this.vScale;
        if (this.sprite != null) {
            uMin = this.sprite.method_4580(uMin);
            uMax = this.sprite.method_4580(uMax);
            vMin = this.sprite.method_4570(vMin);
            vMax = this.sprite.method_4570(vMax);
        }
        Matrix4f pose = poseStack.method_23760().method_23761();
        class_4588 buffer = class_310.method_1551().method_22940().method_23000().getBuffer(renderTypeFunction.apply(this.texture));
        buffer.method_22918(pose, (float)xMin, (float)yMin, 0.0f).method_22913(uMin, vMin).method_39415(this.colour).method_60803(this.lightLevel).method_22922(class_4608.field_21444).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(pose, (float)xMin, (float)yMax, 0.0f).method_22913(uMin, vMax).method_39415(this.colour).method_60803(this.lightLevel).method_22922(class_4608.field_21444).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(pose, (float)xMax, (float)yMax, 0.0f).method_22913(uMax, vMax).method_39415(this.colour).method_60803(this.lightLevel).method_22922(class_4608.field_21444).method_22914(0.0f, 1.0f, 0.0f);
        buffer.method_22918(pose, (float)xMax, (float)yMin, 0.0f).method_22913(uMax, vMin).method_39415(this.colour).method_60803(this.lightLevel).method_22922(class_4608.field_21444).method_22914(0.0f, 1.0f, 0.0f);
    }
}

