/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.core.hud.element;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1058;
import net.minecraft.class_1291;
import net.minecraft.class_1309;
import net.minecraft.class_1492;
import net.minecraft.class_1496;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import net.tslat.tes.api.TESAPI;
import net.tslat.tes.api.TESConfig;
import net.tslat.tes.api.TESConstants;
import net.tslat.tes.api.TESTextures;
import net.tslat.tes.api.object.TESEntityType;
import net.tslat.tes.api.object.TESHudRenderContext;
import net.tslat.tes.api.util.TESRenderUtil;
import net.tslat.tes.api.util.TESUtil;
import net.tslat.tes.api.util.render.TextRenderHelper;
import net.tslat.tes.api.util.render.TextureRenderHelper;
import net.tslat.tes.core.hud.TESHud;
import net.tslat.tes.core.hud.element.TESHudEntityIcon;
import net.tslat.tes.core.state.EntityState;
import net.tslat.tes.core.state.TESEntityTracking;

public final class BuiltinHudElements {
    public static int renderEntityName(TESHudRenderContext renderContext, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity) {
        TextRenderHelper namespaceRenderer;
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudEntityName() && (!config.inWorldHudNameOverride() || !entity.method_16914()) : !config.hudEntityName()) {
            return 0;
        }
        Objects.requireNonNull(mc.field_1772);
        int lineHeight = 9;
        boolean inWorldHud = renderContext.isInWorld();
        TextRenderHelper nameRenderer = TextRenderHelper.of(entity.method_5476()).colour(class_9848.method_61317((float)opacity));
        TextRenderHelper textRenderHelper = (inWorldHud ? config.inWorldHudEntityNamespace() : config.hudEntityNamespace()) ? TextRenderHelper.of((class_2561)class_2561.method_43470((String)("(" + class_7923.field_41177.method_10221((Object)entity.method_5864()).method_12836() + ")"))).colour(200, 200, 200, class_3532.method_15375((float)(opacity * 255.0f))) : (namespaceRenderer = null);
        if (inWorldHud) {
            nameRenderer.style(config.inWorldHudEntityNameFontStyle()).centered();
            if (namespaceRenderer != null) {
                namespaceRenderer.style(config.inWorldHudEntityNameFontStyle()).centered();
            }
        } else {
            nameRenderer.style(config.hudEntityNameFontStyle());
            if (namespaceRenderer != null) {
                namespaceRenderer.style(config.hudEntityNameFontStyle());
            }
        }
        nameRenderer.render(renderContext, 0.0f, 0.0f);
        if (namespaceRenderer != null) {
            namespaceRenderer.render(renderContext, 0.0f, lineHeight);
            Objects.requireNonNull(mc.field_1772);
            lineHeight += 9;
        }
        TESEntityTracking.markNameRendered(entity);
        return lineHeight;
    }

    public static int renderEntityHealth(TESHudRenderContext renderContext, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity) {
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null) {
            return 0;
        }
        TESConfig config = TESAPI.getConfig();
        boolean inWorldHud = renderContext.isInWorld();
        int barWidth = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        TESHud.BarRenderType renderType = inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType();
        renderContext.pushMatrix();
        renderContext.translate(inWorldHud ? (float)barWidth * -0.5f : 0.0f, inWorldHud ? 4.0f : 1.0f, 0.0f);
        if (renderType != TESHud.BarRenderType.NUMERIC) {
            float filledPercent = entityState.getHealth() / entity.method_6063();
            float transitionPercent = entityState.getLastTransitionHealth() / entity.method_6063();
            boolean doSegmentsOverlay = inWorldHud ? config.inWorldBarsSegments() : config.hudHealthBarSegments();
            TESEntityType entityType = TESConstants.UTILS.getEntityType(entity);
            class_1058 emptyBar = TESRenderUtil.getAtlasSprite(entityType.backgroundTexture());
            class_1058 filledBar = TESRenderUtil.getAtlasSprite(entityType.overlayTexture());
            class_1058 barBackground = TESRenderUtil.getAtlasSprite(TESTextures.BAR_EMPTY);
            class_1058 barOverlay = doSegmentsOverlay ? TESRenderUtil.getAtlasSprite(TESTextures.BAR_OVERLAY_SEGMENTS) : null;
            TESRenderUtil.renderBar(renderContext, 0, 0, barWidth, filledPercent, transitionPercent, opacity, barBackground, emptyBar, filledBar, barOverlay);
        }
        if (renderType != TESHud.BarRenderType.BAR && renderType != TESHud.BarRenderType.BAR_ICONS) {
            String healthText = TESUtil.roundToDecimal(entityState.getHealth(), 1) + "/" + TESUtil.roundToDecimal(entity.method_6063(), 1);
            if (inWorldHud) {
                renderContext.translate(0.0f, 0.0f, 0.019f);
            }
            TextRenderHelper healthRenderer = TextRenderHelper.of((class_2561)class_2561.method_43470((String)healthText)).colour(255, 255, 255, class_3532.method_15375((float)(opacity * 255.0f))).withBackdrop(class_9848.method_61324((int)class_3532.method_15375((float)(opacity * 255.0f * config.hudBarFontBackingOpacity())), (int)9, (int)9, (int)9)).centered();
            if (inWorldHud) {
                healthRenderer.lightLevel(renderContext.getPackedLight());
            }
            healthRenderer.render(renderContext, (float)barWidth / 2.0f, -1.0f);
        }
        renderContext.popMatrix();
        Objects.requireNonNull(mc.field_1772);
        return 9;
    }

    public static int renderEntityStats(TESHudRenderContext renderContext, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity) {
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudStats() : !config.hudStats()) {
            return 0;
        }
        boolean inWorldHud = renderContext.isInWorld();
        int armour = TESUtil.getArmour(entity);
        float toughness = TESUtil.getArmourToughness(entity);
        float meleeDamage = TESUtil.getMeleeDamage(entity);
        float health = TESUtil.getHealth(entity);
        int hearts = health <= 0.0f ? 0 : Math.max(1, class_3532.method_15375((float)(health / 2.0f)));
        int colour = class_9848.method_61317((float)opacity);
        class_5250 armourString = armour > 0 ? class_2561.method_43470((String)("x" + armour)) : null;
        class_5250 toughnessString = toughness > 0.0f ? class_2561.method_43470((String)("x" + TESUtil.roundToDecimal(toughness, 1))) : null;
        class_5250 meleeDamageString = meleeDamage > 0.0f ? class_2561.method_43470((String)("x" + TESUtil.roundToDecimal(meleeDamage, 1))) : null;
        class_5250 heartsString = (inWorldHud ? config.inWorldBarsRenderType() : config.hudHealthRenderType()) == TESHud.BarRenderType.BAR_ICONS ? class_2561.method_43470((String)("x" + hearts)) : null;
        int armourX = 0;
        int toughnessX = armourX + (armourString == null ? 0 : 11 + mc.field_1772.method_27525((class_5348)armourString));
        int meleeDamageX = toughnessX + (toughnessString == null ? 0 : 11 + mc.field_1772.method_27525((class_5348)toughnessString));
        int healthX = meleeDamageX + (meleeDamageString == null ? 0 : 11 + mc.field_1772.method_27525((class_5348)meleeDamageString));
        if (healthX == 0 && heartsString == null) {
            return 0;
        }
        renderContext.pushMatrix();
        if (inWorldHud) {
            renderContext.translate((float)(healthX + (heartsString == null ? 0 : mc.field_1772.method_27525((class_5348)heartsString)) + 2) * -0.5f, 0.0f, 0.0f);
        }
        if (armour > 0) {
            TextureRenderHelper.ofSprite(TESTextures.STAT_ARMOUR).sized(9.0f, 9.0f).colour(colour).render(renderContext, armourX, 0.0f);
        }
        if (toughness > 0.0f) {
            TextureRenderHelper.ofSprite(TESTextures.STAT_TOUGHNESS).sized(9.0f, 9.0f).colour(colour).render(renderContext, toughnessX, 0.0f);
        }
        if (meleeDamage > 0.0f) {
            TextureRenderHelper.ofSprite(TESTextures.STAT_MELEE_DAMAGE).sized(9.0f, 9.0f).colour(colour).render(renderContext, meleeDamageX, 0.0f);
        }
        if (heartsString != null) {
            TextureRenderHelper.ofSprite(class_2960.method_60656((String)"hud/heart/container")).sized(9.0f, 9.0f).colour(colour).render(renderContext, healthX, 0.0f);
            TextureRenderHelper.ofSprite(class_2960.method_60656((String)"hud/heart/full")).sized(9.0f, 9.0f).colour(colour).render(renderContext, healthX, 0.0f);
        }
        if (armour > 0) {
            TextRenderHelper.of((class_2561)armourString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, armourX + 10, 1.0f);
        }
        if (toughness > 0.0f) {
            TextRenderHelper.of((class_2561)toughnessString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, toughnessX + 10, 1.0f);
        }
        if (meleeDamage > 0.0f) {
            TextRenderHelper.of((class_2561)meleeDamageString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, meleeDamageX + 10, 1.0f);
        }
        if (heartsString != null) {
            TextRenderHelper.of((class_2561)heartsString).colour(colour).style(inWorldHud ? config.inWorldHudStatsFontStyle() : config.hudStatsFontStyle()).render(renderContext, healthX + 10, 1.0f);
        }
        renderContext.popMatrix();
        Objects.requireNonNull(mc.field_1772);
        return 9;
    }

    public static int renderEntityIcons(TESHudRenderContext renderContext, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity) {
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudEntityIcons() : !config.hudEntityIcons()) {
            return 0;
        }
        float x = 0.0f;
        List<TESHudEntityIcon> icons = TESHud.getEntityIcons();
        ObjectArrayList toRender = new ObjectArrayList(icons.size());
        for (TESHudEntityIcon icon : icons) {
            if (!icon.shouldRender(entity)) continue;
            toRender.add(icon);
            x += 9.0f;
        }
        x = renderContext.isInWorld() ? -(x / 2.0f) : 0.0f;
        for (TESHudEntityIcon icon : toRender) {
            icon.render(renderContext, entity, x, 0.0f, opacity);
            x += 9.0f;
        }
        return toRender.isEmpty() ? 0 : 8;
    }

    public static int renderEntityEffects(TESHudRenderContext renderContext, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity) {
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudPotionIcons() : !config.hudPotionIcons()) {
            return 0;
        }
        EntityState entityState = TESEntityTracking.getStateForEntity(entity);
        if (entityState == null || entityState.getEffects().isEmpty()) {
            return 0;
        }
        boolean inWorldHud = renderContext.isInWorld();
        int effectsSize = entityState.getEffects().size();
        int barLength = inWorldHud ? config.inWorldBarsLength() : config.hudHealthBarLength();
        float maxX = (float)barLength * 2.0f;
        int iconsPerRow = (int)Math.floor(maxX / 18.0f);
        int rows = (int)Math.ceil((float)effectsSize / (float)iconsPerRow);
        int x = inWorldHud ? Math.min(effectsSize, iconsPerRow) * -9 : 0;
        int y = 0;
        int i = 0;
        renderContext.pushMatrix();
        renderContext.scale(0.5f, 0.5f, 1.0f);
        if (inWorldHud) {
            renderContext.translate(0.0f, class_3532.method_15375((float)((float)(effectsSize * 18) / maxX)) * -18, 0.0f);
        }
        for (class_6880<class_1291> effect : entityState.getEffects()) {
            TextureRenderHelper effectRenderer = TextureRenderHelper.ofSprite(class_329.method_71644(effect)).sized(18.0f, 18.0f).colour(class_9848.method_61317((float)opacity));
            if (inWorldHud) {
                effectRenderer.lightLevel(renderContext.getPackedLight());
            }
            effectRenderer.render(renderContext, i * 18 + x, y);
            if (++i < iconsPerRow) continue;
            i = 0;
            if (!inWorldHud || (y += 18) / 18 != rows - 1) continue;
            x = effectsSize % iconsPerRow % iconsPerRow * -9;
        }
        renderContext.popMatrix();
        return (int)Math.ceil((float)effectsSize / (float)iconsPerRow) * 9;
    }

    public static int renderHorseStats(TESHudRenderContext renderContext, class_310 mc, class_9779 deltaTracker, class_1309 entity, float opacity) {
        class_1492 chestedHorse;
        boolean hasChest;
        TESConfig config = TESAPI.getConfig();
        if (renderContext.isInWorld() ? !config.inWorldHudHorseStats() : !config.hudHorseStats()) {
            return 0;
        }
        if (!(entity instanceof class_1496)) {
            return 0;
        }
        class_1496 horse = (class_1496)entity;
        boolean bl = hasChest = entity instanceof class_1492 && (chestedHorse = (class_1492)entity).method_6703();
        int x = renderContext.isInWorld() ? (hasChest ? -18 : -11) : 1;
        double healthRatio = (horse.method_45325(class_5134.field_23716) - (double)class_1496.field_42645) / (double)(class_1496.field_42646 - class_1496.field_42645);
        double moveSpeedRatio = (horse.method_45325(class_5134.field_23719) - (double)class_1496.field_42641) / (double)(class_1496.field_42642 - class_1496.field_42641);
        double jumpStrengthRatio = (horse.method_45325(class_5134.field_23728) - (double)class_1496.field_42643) / (double)(class_1496.field_42644 - class_1496.field_42643);
        TextRenderHelper health = TextRenderHelper.of("H:" + class_3532.method_15357((double)(healthRatio * 100.0)) + "%").colour(class_9848.method_71346((float)opacity, (int)TESRenderUtil.colourGradeForValue(healthRatio)));
        TextRenderHelper speed = TextRenderHelper.of("S:" + class_3532.method_15357((double)(moveSpeedRatio * 100.0)) + "%").colour(class_9848.method_71346((float)opacity, (int)TESRenderUtil.colourGradeForValue(moveSpeedRatio)));
        TextRenderHelper jumpStrength = TextRenderHelper.of("J:" + class_3532.method_15357((double)(jumpStrengthRatio * 100.0)) + "%").colour(class_9848.method_71346((float)opacity, (int)TESRenderUtil.colourGradeForValue(jumpStrengthRatio)));
        TextureRenderHelper storageSprite = TextureRenderHelper.ofSprite(TESTextures.PROPERTY_STORAGE).sized(8.0f, 8.0f).colour(class_9848.method_61317((float)opacity));
        if (hasChest) {
            storageSprite.render(renderContext, x, 1.0f);
            x += 10;
        }
        health.render(renderContext, x, 1.0f);
        speed.render(renderContext, x + 34, 1.0f);
        jumpStrength.render(renderContext, x + 68, 1.0f);
        return 9;
    }
}

