/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import net.tslat.tes.TESClient;
import net.tslat.tes.core.networking.TESNetworking;
import net.tslat.tes.core.networking.packet.MultiloaderConfigurationPacket;
import net.tslat.tes.core.networking.packet.MultiloaderPacket;
import net.tslat.tes.core.networking.packet.NewComponentParticlePacket;
import net.tslat.tes.core.networking.packet.NewNumericParticlePacket;
import net.tslat.tes.core.networking.packet.ParticleClaimPacket;
import net.tslat.tes.core.networking.packet.RequestEffectsPacket;
import net.tslat.tes.core.networking.packet.SyncEffectsPacket;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector3f;

public class TESNetworking
implements net.tslat.tes.core.networking.TESNetworking {
    @Override
    @ApiStatus.Internal
    public <B extends class_2540, P extends MultiloaderConfigurationPacket> void registerConfigurationPacketInternal(class_8710.class_9154<P> packetType, class_9139<B, P> codec, TESNetworking.Direction direction) {
        if (direction != TESNetworking.Direction.CLIENTBOUND) {
            PayloadTypeRegistry.configurationC2S().register(packetType, codec);
            ServerConfigurationNetworking.registerGlobalReceiver(packetType, (packet, context) -> packet.handleTask(new MultiloaderConfigurationPacket.TaskHandler(reply -> {}, arg_0 -> ((class_8610)context.networkHandler()).completeTask(arg_0))));
        }
        if (direction != TESNetworking.Direction.SERVERBOUND) {
            PayloadTypeRegistry.configurationS2C().register(packetType, codec);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                TESClient.registerConfigurationPacket(packetType);
            }
        }
    }

    @Override
    @ApiStatus.Internal
    public <B extends class_2540, P extends MultiloaderPacket> void registerPacketInternal(class_8710.class_9154<P> packetType, class_9139<B, P> codec, TESNetworking.Direction direction) {
        if (direction != TESNetworking.Direction.CLIENTBOUND) {
            PayloadTypeRegistry.playC2S().register(packetType, codec);
            ServerPlayNetworking.registerGlobalReceiver(packetType, (packet, context) -> packet.receiveMessage((class_1657)context.player(), arg_0 -> ((MinecraftServer)context.player().method_5682()).execute(arg_0)));
        }
        if (direction != TESNetworking.Direction.SERVERBOUND) {
            PayloadTypeRegistry.playS2C().register(packetType, codec);
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                TESClient.registerPacket(packetType);
            }
        }
    }

    @Override
    public void requestEffectsSync(int entityId) {
        TESClient.sendPacket(new RequestEffectsPacket(entityId));
    }

    @Override
    public void sendEffectsSync(class_3222 player, int entityId, Set<class_6880<class_1291>> toAdd, Set<class_6880<class_1291>> toRemove) {
        ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncEffectsPacket(entityId, toAdd, toRemove));
    }

    @Override
    public void sendEffectsSync(class_1309 targetedEntity, Set<class_6880<class_1291>> toAdd, Set<class_6880<class_1291>> toRemove) {
        for (class_3222 player : PlayerLookup.tracking((class_1297)targetedEntity)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SyncEffectsPacket(targetedEntity.method_5628(), toAdd, toRemove));
        }
    }

    @Override
    public void sendParticle(class_3218 level, Vector3f position, class_2561 contents) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_2338)class_2338.method_49637((double)position.x, (double)position.y, (double)position.z))) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NewComponentParticlePacket(position, contents));
        }
    }

    @Override
    public void sendParticle(class_1309 targetedEntity, class_2561 contents) {
        for (class_3222 player : PlayerLookup.tracking((class_1297)targetedEntity)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NewComponentParticlePacket(targetedEntity, contents));
        }
    }

    @Override
    public void sendParticle(class_3218 level, Vector3f position, double value, int colour) {
        for (class_3222 player : PlayerLookup.tracking((class_3218)level, (class_2338)class_2338.method_49637((double)position.x, (double)position.y, (double)position.z))) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NewNumericParticlePacket(value, position, colour));
        }
    }

    @Override
    public void sendParticle(class_1309 targetedEntity, double value, int colour) {
        for (class_3222 player : PlayerLookup.tracking((class_1297)targetedEntity)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NewNumericParticlePacket(value, new Vector3f((float)targetedEntity.method_23317(), (float)targetedEntity.method_23320(), (float)targetedEntity.method_23321()), colour));
        }
    }

    @Override
    public void sendParticleClaim(class_2960 claimantId, class_1309 targetedEntity, Optional<class_2487> additionalData) {
        for (class_3222 player : PlayerLookup.tracking((class_1297)targetedEntity)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ParticleClaimPacket(targetedEntity.method_5628(), claimantId, additionalData));
        }
    }
}

