/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.block.DryingRackBlock;
import cn.leolezury.eternalstarlight.common.block.entity.SimpleContainerBlockEntity;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipe;
import cn.leolezury.eternalstarlight.common.item.recipe.DryingRecipeInput;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1262;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public class DryingRackBlockEntity
extends SimpleContainerBlockEntity {
    private static final String TAG_DRYING_TICKS = "drying_ticks";
    private final class_1863.class_7266<DryingRecipeInput, DryingRecipe> quickCheck = class_1863.method_42302(ESRecipes.DRYING.get());
    private boolean lastLit;
    private int dryingTicks = 0;
    private class_2371<class_1799> items = class_2371.method_10213((int)1, (Object)class_1799.field_8037);

    protected DryingRackBlockEntity(class_2591<?> entityType, class_2338 pos, class_2680 state) {
        super(entityType, pos, state);
    }

    public DryingRackBlockEntity(class_2338 blockPos, class_2680 blockState) {
        this(ESBlockEntities.DRYING_RACK.get(), blockPos, blockState);
    }

    public class_1799 getItem() {
        return (class_1799)this.items.getFirst();
    }

    public void setItem(class_1799 item) {
        this.method_5447(0, item);
        this.dryingTicks = 0;
    }

    public boolean canBeDried(class_1799 stack, boolean fireBelow) {
        if (this.field_11863 == null) {
            return false;
        }
        List list = this.field_11863.method_8433().method_30027(ESRecipes.DRYING.get());
        for (class_8786 holder : list) {
            DryingRecipe recipe = (DryingRecipe)holder.comp_1933();
            if (fireBelow != recipe.fireBelow() || !recipe.input().method_8093(stack)) continue;
            return true;
        }
        return false;
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, DryingRackBlockEntity entity) {
        if (!level.field_9236) {
            if (!entity.getItem().method_7960()) {
                Optional optionalRecipe;
                boolean lit = (Boolean)state.method_11654((class_2769)DryingRackBlock.LIT);
                if (entity.lastLit != lit) {
                    entity.dryingTicks = 0;
                    entity.lastLit = lit;
                }
                if ((optionalRecipe = entity.quickCheck.method_42303((class_9695)new DryingRecipeInput((class_1799)entity.items.getFirst(), lit), level)).isPresent()) {
                    DryingRecipe recipe = (DryingRecipe)((class_8786)optionalRecipe.get()).comp_1933();
                    ++entity.dryingTicks;
                    if (entity.dryingTicks > recipe.durationTicks()) {
                        entity.dryingTicks = 0;
                        entity.setItem(recipe.output().method_7972());
                    }
                } else {
                    entity.dryingTicks = 0;
                }
            } else {
                entity.dryingTicks = 0;
            }
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38242(provider);
    }

    public void method_5431() {
        super.method_5431();
        if (this.method_10997() != null) {
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.dryingTicks = compoundTag.method_10550(TAG_DRYING_TICKS);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10569(TAG_DRYING_TICKS, this.dryingTicks);
        class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
    }

    @Override
    protected class_2371<class_1799> getItems() {
        return this.items;
    }

    public int method_5439() {
        return 1;
    }

    public int method_5444() {
        return 1;
    }

    public boolean method_5437(int index, class_1799 stack) {
        class_2680 state = this.method_11010();
        return this.canBeDried(stack, state.method_28498((class_2769)DryingRackBlock.LIT) && (Boolean)state.method_11654((class_2769)DryingRackBlock.LIT) != false) && this.method_5438(index).method_7960() && stack.method_7947() <= this.method_5444();
    }
}

