/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.FlareSpawnerBlock;
import cn.leolezury.eternalstarlight.common.block.entity.DuskLightReceptor;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1317;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_1952;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4844;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import net.minecraft.class_6008;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class FlareSpawner {
    public static final String TAG_SPAWN_DATA = "spawn_data";
    public static final String TAG_SPAWN_POTENTIALS = "spawn_potentials";
    private static final String TAG_SPAWN_DELAY = "spawn_delay";
    private static final String TAG_MIN_SPAWN_DELAY = "min_spawn_delay";
    private static final String TAG_MAX_SPAWN_DELAY = "max_spawn_delay";
    private static final String TAG_SPAWN_COUNT = "spawn_count";
    private static final String TAG_TOTAL_SPAWN_COUNT = "total_spawn_count";
    private static final String TAG_SPAWNED_COUNT = "spawned_count";
    private static final String TAG_MAX_NEARBY_ENTITIES = "max_nearby_entities";
    private static final String TAG_ACTIVATION_PLAYER_RANGE = "activation_player_range";
    private static final String TAG_REQUIRED_PLAYER_RANGE = "required_player_range";
    private static final String TAG_SPAWN_RANGE = "spawn_range";
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_TRACKED_MOBS = "tracked_mobs";
    private static final int EVENT_SPAWN = 1;
    private int spawnDelay = 20;
    private class_6005<class_1952> spawnPotentials = class_6005.method_38062();
    @Nullable
    private class_1952 nextSpawnData;
    private double spin;
    private double oSpin;
    private int minSpawnDelay = 20;
    private int maxSpawnDelay = 80;
    private int spawnCount = 4;
    private int totalSpawnCount = 10;
    private int spawnedCount = 0;
    @Nullable
    private class_1297 displayEntity;
    private int maxNearbyEntities = 6;
    private int activationPlayerRange = 4;
    private int requiredPlayerRange = 16;
    private int spawnRange = 4;
    private int cooldown = 0;
    private final Set<UUID> trackedMobs = new HashSet<UUID>();

    public void setEntityId(class_1299<?> type, @Nullable class_1937 level, class_5819 random, class_2338 pos) {
        this.getOrCreateNextSpawnData(level, random, pos).method_38093().method_10582("id", class_7923.field_41177.method_10221(type).toString());
    }

    private boolean isNearPlayer(class_1937 level, class_2338 pos, int range) {
        return !level.method_18467(class_1657.class, new class_238(pos).method_1014((double)range)).stream().filter(player -> (level.field_9236 || FlareSpawner.inLineOfSight(level, pos.method_46558(), player.method_33571())) && !player.method_7337() && !player.method_7325()).toList().isEmpty();
    }

    private static boolean inLineOfSight(class_1937 level, class_243 block, class_243 target) {
        class_3965 blockHitResult = level.method_17742(new class_3959(target, block, class_3959.class_3960.field_23142, class_3959.class_242.field_1348, class_3726.method_16194()));
        return blockHitResult.method_17777().equals((Object)class_2338.method_49638((class_2374)block)) || blockHitResult.method_17783() == class_239.class_240.field_1333;
    }

    private static boolean shouldMobBeUntracked(class_3218 serverLevel, class_2338 blockPos, UUID uuid) {
        class_1297 entity = serverLevel.method_14190(uuid);
        return entity == null || !entity.method_5805() || !entity.method_37908().method_27983().equals(serverLevel.method_27983()) || entity.method_24515().method_10262((class_2382)blockPos) > 1024.0;
    }

    private void sendDuskSignal(class_1937 level, class_2338 pos) {
        class_2586 class_25862;
        class_2680 state = level.method_8320(pos);
        if (state.method_28498((class_2769)FlareSpawnerBlock.LIT) && ((Boolean)state.method_11654((class_2769)FlareSpawnerBlock.LIT)).booleanValue() && (class_25862 = level.method_8321(pos.method_10084())) instanceof DuskLightReceptor) {
            DuskLightReceptor receptor = (DuskLightReceptor)class_25862;
            receptor.lightUp(level, pos.method_10084(), class_2350.field_11033);
        }
    }

    public void clientTick(class_1937 level, class_2338 pos) {
        this.sendDuskSignal(level, pos);
        this.oSpin = this.spin;
        if (this.cooldown > 0) {
            return;
        }
        class_2680 state = level.method_8320(pos);
        if (this.isNearPlayer(level, pos, this.requiredPlayerRange) && state.method_28498((class_2769)FlareSpawnerBlock.LIT) && ((Boolean)state.method_11654((class_2769)FlareSpawnerBlock.LIT)).booleanValue()) {
            class_5819 random = level.method_8409();
            double x = (double)pos.method_10263() + random.method_43058();
            double y = (double)pos.method_10264() + random.method_43058();
            double z = (double)pos.method_10260() + random.method_43058();
            level.method_8406((class_2394)class_2398.field_11251, x, y, z, 0.0, 0.0, 0.0);
            level.method_8406((class_2394)class_2398.field_11240, x, y, z, 0.0, 0.0, 0.0);
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            }
            this.spin = (this.spin + 1000.0 / ((double)this.spawnDelay + 200.0)) % 360.0;
        }
    }

    public void serverTick(class_3218 serverLevel, class_2338 pos) {
        this.sendDuskSignal((class_1937)serverLevel, pos);
        this.trackedMobs.removeIf(uuid -> FlareSpawner.shouldMobBeUntracked(serverLevel, pos, uuid));
        class_2680 state = serverLevel.method_8320(pos);
        if (this.cooldown > 0) {
            --this.cooldown;
            this.spawnedCount = 0;
            if (state.method_28498((class_2769)FlareSpawnerBlock.LIT) && ((Boolean)state.method_11654((class_2769)FlareSpawnerBlock.LIT)).booleanValue()) {
                serverLevel.method_8501(pos, (class_2680)state.method_11657((class_2769)FlareSpawnerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            }
            return;
        }
        class_5819 random = serverLevel.method_8409();
        if (this.trackedMobs.isEmpty() && this.spawnedCount >= this.totalSpawnCount) {
            class_1303.method_31493((class_3218)serverLevel, (class_243)class_243.method_24953((class_2382)pos), (int)random.method_43051(50, 101));
            this.cooldown += 36000;
        }
        if (this.isNearPlayer((class_1937)serverLevel, pos, this.activationPlayerRange) && state.method_28498((class_2769)FlareSpawnerBlock.LIT) && !((Boolean)state.method_11654((class_2769)FlareSpawnerBlock.LIT)).booleanValue() && this.getOrCreateNextSpawnData((class_1937)serverLevel, random, pos).method_38093().method_10573("id", 8) && serverLevel.method_8450().method_8355(class_1928.field_19390)) {
            serverLevel.method_8501(pos, (class_2680)state.method_11657((class_2769)FlareSpawnerBlock.LIT, (Comparable)Boolean.valueOf(true)));
            for (int i = 0; i < 15; ++i) {
                class_243 speed = new class_243((double)((random.method_43057() - random.method_43057()) * 0.1f), (double)(random.method_43057() * 0.05f), (double)((random.method_43057() - random.method_43057()) * 0.1f)).method_1029();
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.FLARE, (double)pos.method_10263() + 0.5 + speed.field_1352 * 0.2, (double)pos.method_10264() + 0.5 + speed.field_1351 * 0.2, (double)pos.method_10260() + 0.5 + speed.field_1350 * 0.2, speed.field_1352, speed.field_1351, speed.field_1350));
            }
        }
        if (this.isNearPlayer((class_1937)serverLevel, pos, this.requiredPlayerRange) && state.method_28498((class_2769)FlareSpawnerBlock.LIT) && ((Boolean)state.method_11654((class_2769)FlareSpawnerBlock.LIT)).booleanValue()) {
            if (this.spawnDelay == -1) {
                this.delay((class_1937)serverLevel, pos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else if (serverLevel.method_8450().method_8355(class_1928.field_19390)) {
                boolean success = false;
                class_1952 spawnData = this.getOrCreateNextSpawnData((class_1937)serverLevel, random, pos);
                for (int i = 0; i < this.spawnCount; ++i) {
                    class_1308 mob;
                    class_1952.class_6542 rules;
                    double z;
                    if (this.spawnedCount >= this.totalSpawnCount) {
                        this.delay((class_1937)serverLevel, pos);
                        return;
                    }
                    class_2487 entityToSpawn = spawnData.method_38093();
                    Optional type = class_1299.method_17684((class_2487)entityToSpawn);
                    if (type.isEmpty()) {
                        this.delay((class_1937)serverLevel, pos);
                        return;
                    }
                    class_2499 posTag = entityToSpawn.method_10554("Pos", 6);
                    int posSize = posTag.size();
                    double x = posSize >= 1 ? posTag.method_10611(0) : (double)pos.method_10263() + (random.method_43058() - random.method_43058()) * (double)this.spawnRange + 0.5;
                    double y = posSize >= 2 ? posTag.method_10611(1) : (double)(pos.method_10264() + random.method_43048(3) - 1);
                    double d = z = posSize >= 3 ? posTag.method_10611(2) : (double)pos.method_10260() + (random.method_43058() - random.method_43058()) * (double)this.spawnRange + 0.5;
                    if (!serverLevel.method_18026(((class_1299)type.get()).method_58629(x, y, z)) || !FlareSpawner.inLineOfSight((class_1937)serverLevel, pos.method_46558(), new class_243(x, y, z))) continue;
                    class_2338 spawnPos = class_2338.method_49637((double)x, (double)y, (double)z);
                    if (!spawnData.method_38097().isPresent() ? !class_1317.method_20638((class_1299)((class_1299)type.get()), (class_5425)serverLevel, (class_3730)class_3730.field_47245, (class_2338)spawnPos, (class_5819)serverLevel.method_8409()) : !((class_1299)type.get()).method_5891().method_6136() && serverLevel.method_8407() == class_1267.field_5801 || !(rules = (class_1952.class_6542)spawnData.method_38097().get()).method_56563(spawnPos, serverLevel)) continue;
                    class_1297 entity = class_1299.method_17842((class_2487)entityToSpawn, (class_1937)serverLevel, e -> {
                        e.method_5808(x, y, z, e.method_36454(), e.method_36455());
                        return e;
                    });
                    if (entity == null) {
                        this.delay((class_1937)serverLevel, pos);
                        return;
                    }
                    int entitiesCount = serverLevel.method_18023(class_5575.method_55374(entity.getClass()), new class_238((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (double)(pos.method_10263() + 1), (double)(pos.method_10264() + 1), (double)(pos.method_10260() + 1)).method_1014((double)this.spawnRange), class_1301.field_6155).size();
                    if (entitiesCount >= this.maxNearbyEntities) {
                        this.delay((class_1937)serverLevel, pos);
                        return;
                    }
                    entity.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), random.method_43057() * 360.0f, 0.0f);
                    if (entity instanceof class_1308) {
                        boolean shouldFinalize;
                        mob = (class_1308)entity;
                        if (!mob.method_5957((class_4538)serverLevel)) continue;
                        boolean bl = shouldFinalize = spawnData.method_38093().method_10546() == 1 && spawnData.method_38093().method_10573("id", 8);
                        if (shouldFinalize) {
                            mob.method_5943((class_5425)serverLevel, serverLevel.method_8404(entity.method_24515()), class_3730.field_47245, null);
                        }
                        spawnData.method_59717().ifPresent(arg_0 -> ((class_1308)mob).method_58634(arg_0));
                    }
                    if (!serverLevel.method_30736(entity)) {
                        this.delay((class_1937)serverLevel, pos);
                        return;
                    }
                    serverLevel.method_20290(2004, pos, 0);
                    serverLevel.method_33596(entity, (class_6880)class_5712.field_28738, spawnPos);
                    if (entity instanceof class_1308) {
                        mob = (class_1308)entity;
                        mob.method_5990();
                    }
                    for (int j = 0; j <= 10; ++j) {
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.FLARE, entity.method_23317() + (double)((random.method_43057() - 0.5f) * entity.method_17681() * 1.2f), entity.method_23318(), entity.method_23321() + (double)((random.method_43057() - 0.5f) * entity.method_17681() * 1.2f), 0.0, 1.0, 0.0));
                    }
                    this.trackedMobs.add(entity.method_5667());
                    ++this.spawnedCount;
                    success = true;
                }
                if (success) {
                    this.delay((class_1937)serverLevel, pos);
                }
            }
        }
    }

    private void delay(class_1937 level, class_2338 pos) {
        class_5819 random = level.method_8409();
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + random.method_43048(this.maxSpawnDelay - this.minSpawnDelay);
        this.spawnPotentials.method_34992(random).ifPresent(wrapper -> this.setNextSpawnData(level, pos, (class_1952)wrapper.comp_2542()));
        this.broadcastEvent(level, pos, 1);
    }

    public void load(@Nullable class_1937 level, class_2338 pos, class_2487 tag) {
        boolean hasSpawnPotentials;
        this.spawnDelay = tag.method_10568(TAG_SPAWN_DELAY);
        this.spawnedCount = tag.method_10568(TAG_SPAWNED_COUNT);
        this.cooldown = tag.method_10550(TAG_COOLDOWN);
        boolean hasSpawnData = tag.method_10573(TAG_SPAWN_DATA, 10);
        if (hasSpawnData) {
            class_1952 data = class_1952.field_34460.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10562(TAG_SPAWN_DATA)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Invalid SpawnData: {}", s)).orElseGet(class_1952::new);
            this.setNextSpawnData(level, pos, data);
        }
        if (hasSpawnPotentials = tag.method_10573(TAG_SPAWN_POTENTIALS, 9)) {
            class_2499 list = tag.method_10554(TAG_SPAWN_POTENTIALS, 10);
            this.spawnPotentials = class_1952.field_34461.parse((DynamicOps)class_2509.field_11560, (Object)list).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Invalid SpawnPotentials list: {}", s)).orElseGet(class_6005::method_38062);
        } else {
            this.spawnPotentials = class_6005.method_38061((Object)(this.nextSpawnData != null ? this.nextSpawnData : new class_1952()));
        }
        if (tag.method_10573(TAG_MIN_SPAWN_DELAY, 99)) {
            this.minSpawnDelay = tag.method_10568(TAG_MIN_SPAWN_DELAY);
        }
        if (tag.method_10573(TAG_MAX_SPAWN_DELAY, 99)) {
            this.maxSpawnDelay = tag.method_10568(TAG_MAX_SPAWN_DELAY);
        }
        if (tag.method_10573(TAG_SPAWN_COUNT, 99)) {
            this.spawnCount = tag.method_10568(TAG_SPAWN_COUNT);
        }
        if (tag.method_10573(TAG_TOTAL_SPAWN_COUNT, 99)) {
            this.totalSpawnCount = tag.method_10568(TAG_TOTAL_SPAWN_COUNT);
        }
        if (tag.method_10573(TAG_MAX_NEARBY_ENTITIES, 99)) {
            this.maxNearbyEntities = tag.method_10568(TAG_MAX_NEARBY_ENTITIES);
        }
        if (tag.method_10573(TAG_REQUIRED_PLAYER_RANGE, 99)) {
            this.requiredPlayerRange = tag.method_10568(TAG_REQUIRED_PLAYER_RANGE);
        }
        if (tag.method_10573(TAG_ACTIVATION_PLAYER_RANGE, 99)) {
            this.activationPlayerRange = tag.method_10568(TAG_ACTIVATION_PLAYER_RANGE);
        }
        if (tag.method_10573(TAG_SPAWN_RANGE, 99)) {
            this.spawnRange = tag.method_10568(TAG_SPAWN_RANGE);
        }
        if (tag.method_10545(TAG_TRACKED_MOBS)) {
            this.trackedMobs.clear();
            class_4844.field_47491.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580(TAG_TRACKED_MOBS)).resultOrPartial(s -> EternalStarlight.LOGGER.warn("Invalid tracked mobs list: {}", s)).ifPresent(this.trackedMobs::addAll);
        }
        this.displayEntity = null;
    }

    public class_2487 save(class_2487 tag) {
        tag.method_10575(TAG_SPAWN_DELAY, (short)this.spawnDelay);
        tag.method_10575(TAG_SPAWNED_COUNT, (short)this.spawnedCount);
        tag.method_10569(TAG_COOLDOWN, this.cooldown);
        tag.method_10575(TAG_MIN_SPAWN_DELAY, (short)this.minSpawnDelay);
        tag.method_10575(TAG_MAX_SPAWN_DELAY, (short)this.maxSpawnDelay);
        tag.method_10575(TAG_SPAWN_COUNT, (short)this.spawnCount);
        tag.method_10575(TAG_TOTAL_SPAWN_COUNT, (short)this.totalSpawnCount);
        tag.method_10575(TAG_MAX_NEARBY_ENTITIES, (short)this.maxNearbyEntities);
        tag.method_10575(TAG_REQUIRED_PLAYER_RANGE, (short)this.requiredPlayerRange);
        tag.method_10575(TAG_ACTIVATION_PLAYER_RANGE, (short)this.activationPlayerRange);
        tag.method_10575(TAG_SPAWN_RANGE, (short)this.spawnRange);
        if (this.nextSpawnData != null) {
            tag.method_10566(TAG_SPAWN_DATA, (class_2520)class_1952.field_34460.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.nextSpawnData).getOrThrow(s -> new IllegalStateException("Invalid SpawnData: " + s)));
        }
        tag.method_10566(TAG_SPAWN_POTENTIALS, (class_2520)class_1952.field_34461.encodeStart((DynamicOps)class_2509.field_11560, this.spawnPotentials).getOrThrow());
        tag.method_10566(TAG_TRACKED_MOBS, (class_2520)class_4844.field_47491.encodeStart((DynamicOps)class_2509.field_11560, this.trackedMobs).getOrThrow());
        return tag;
    }

    @Nullable
    public class_1297 getOrCreateDisplayEntity(class_1937 level, class_2338 pos) {
        if (this.displayEntity == null) {
            class_2487 tag = this.getOrCreateNextSpawnData(level, level.method_8409(), pos).method_38093();
            if (!tag.method_10573("id", 8)) {
                return null;
            }
            this.displayEntity = class_1299.method_17842((class_2487)tag, (class_1937)level, Function.identity());
        }
        return this.displayEntity;
    }

    public boolean onEventTriggered(class_1937 level, int id) {
        if (id == 1) {
            if (level.field_9236) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    protected void setNextSpawnData(@Nullable class_1937 level, class_2338 pos, class_1952 nextSpawnData) {
        this.nextSpawnData = nextSpawnData;
    }

    private class_1952 getOrCreateNextSpawnData(@Nullable class_1937 level, class_5819 random, class_2338 pos) {
        if (this.nextSpawnData == null) {
            this.setNextSpawnData(level, pos, this.spawnPotentials.method_34992(random).map(class_6008.class_6010::comp_2542).orElseGet(class_1952::new));
        }
        return this.nextSpawnData;
    }

    public abstract void broadcastEvent(class_1937 var1, class_2338 var2, int var3);

    public double getSpin() {
        return this.spin;
    }

    public double getOSpin() {
        return this.oSpin;
    }
}

