/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.StarfireBirdNestBlock;
import cn.leolezury.eternalstarlight.common.block.entity.SimpleContainerBlockEntity;
import cn.leolezury.eternalstarlight.common.entity.living.animal.StarfireBird;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9279;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class StarfireBirdNestBlockEntity
extends SimpleContainerBlockEntity {
    private static final String TAG_BIRDS = "birds";
    private static final String TAG_LAST_SEED_PLAYER = "last_seed_player";
    private static final String TAG_HATCH_TICKS = "hatch_ticks";
    private static final List<String> IGNORED_BIRD_TAGS = Arrays.asList("Air", "FallDistance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "Motion", "PortalCooldown", "Pos", "leash", "UUID");
    private final List<BirdData> stored = Lists.newArrayList();
    private class_2371<class_1799> items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private UUID lastSeedPlayer = null;
    private int hatchTicks;

    public StarfireBirdNestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(ESBlockEntities.STARFIRE_BIRD_NEST.get(), blockPos, blockState);
    }

    public void method_5431() {
        super.method_5431();
        if (this.method_10997() != null) {
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public boolean addSeeds(class_1799 stack) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            this.items.set(i, (Object)stack);
            this.method_5431();
            return true;
        }
        return false;
    }

    public boolean removeSeeds() {
        for (int i = 0; i < this.items.size(); ++i) {
            if (((class_1799)this.items.get(i)).method_7960()) continue;
            this.items.set(i, (Object)class_1799.field_8037);
            this.method_5431();
            return true;
        }
        return false;
    }

    public void setLastSeedPlayer(class_1657 player) {
        this.lastSeedPlayer = player.method_5667();
    }

    public void releaseAllOccupants(class_2680 state, boolean emergency) {
        ArrayList list = Lists.newArrayList();
        if (this.field_11863 != null) {
            this.stored.removeIf(birdData -> StarfireBirdNestBlockEntity.releaseOccupant(this.field_11863, this.field_11867, state, this, birdData.toOccupant(), list, emergency, 2400));
        }
        if (!list.isEmpty()) {
            this.method_5431();
        }
    }

    public int getOccupantCount() {
        return this.stored.size();
    }

    public int method_5439() {
        return 5;
    }

    public int method_5444() {
        return 1;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return stack.method_31573(ESTags.Items.STARFIRE_BIRD_FOOD) && this.method_5438(index).method_7960() && stack.method_7947() <= this.method_5444();
    }

    @Override
    public boolean method_5442() {
        return this.stored.isEmpty();
    }

    public boolean isFullForAdults() {
        return this.getAdults().size() >= 2;
    }

    public boolean isFullForBabies() {
        return this.getBabies().size() >= 3;
    }

    public List<BirdData> getAdults() {
        return this.stored.stream().filter(d -> {
            class_1296 mob;
            class_1297 patt0$temp = d.getOrCreateEntityInstance(this.field_11863, this.method_11016());
            return patt0$temp instanceof class_1296 && !(mob = (class_1296)patt0$temp).method_6109();
        }).toList();
    }

    public List<BirdData> getBabies() {
        return this.stored.stream().filter(d -> {
            class_1296 mob;
            class_1297 patt0$temp = d.getOrCreateEntityInstance(this.field_11863, this.method_11016());
            return patt0$temp instanceof class_1296 && (mob = (class_1296)patt0$temp).method_6109();
        }).toList();
    }

    public void addAdultOccupant(class_1297 entity) {
        this.addOccupant(entity, 600, false);
    }

    public void addBabyOccupant(class_1297 entity) {
        this.addOccupant(entity, 23980, true);
    }

    public void addOccupant(class_1297 entity, int minTicksInNest, boolean baby) {
        if (!baby && this.getAdults().size() < 2 || baby && this.getBabies().size() < 3) {
            entity.method_5848();
            entity.method_5772();
            this.storeBird(Occupant.of(entity, minTicksInNest));
            if (this.field_11863 != null) {
                class_2338 blockPos = this.method_11016();
                this.field_11863.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)this.method_11010()));
            }
            entity.method_31472();
            this.method_5431();
        }
    }

    public void storeBird(Occupant occupant) {
        this.stored.add(new BirdData(occupant));
        if (this.field_11863 != null) {
            this.stored.sort(Comparator.comparingInt(d -> {
                int n;
                class_1297 patt0$temp = d.getOrCreateEntityInstance(this.field_11863, this.method_11016());
                if (patt0$temp instanceof class_1296) {
                    class_1296 mob = (class_1296)patt0$temp;
                    n = -mob.method_5618();
                } else {
                    n = 0;
                }
                return n;
            }));
        }
        this.method_5431();
    }

    private static boolean releaseOccupant(class_1937 level, class_2338 blockPos, class_2680 blockState, StarfireBirdNestBlockEntity blockEntity, Occupant occupant, @Nullable List<class_1297> list, boolean emergency, int renterCooldown) {
        boolean hasCollisionShape;
        if (level.method_8419() && !emergency) {
            return false;
        }
        class_2350 facing = (class_2350)blockState.method_11654((class_2769)StarfireBirdNestBlock.FACING);
        class_2338 neighborBlock = blockPos.method_10093(facing);
        boolean bl = hasCollisionShape = !level.method_8320(neighborBlock).method_26220((class_1922)level, neighborBlock).method_1110();
        if (hasCollisionShape && !emergency) {
            return false;
        }
        class_1297 entity = occupant.createEntity(level, blockPos, true);
        if (entity != null) {
            if (entity instanceof StarfireBird) {
                StarfireBird bird = (StarfireBird)entity;
                if (list != null) {
                    list.add((class_1297)bird);
                }
                float bbWidth = entity.method_17681();
                double xzOffset = hasCollisionShape ? 0.0 : 0.55 + (double)bbWidth / 2.0;
                double x = (double)blockPos.method_10263() + 0.5 + xzOffset * (double)facing.method_10148();
                double y = (double)blockPos.method_10264() + 0.5 - (double)entity.method_17682() / 2.0;
                double z = (double)blockPos.method_10260() + 0.5 + xzOffset * (double)facing.method_10165();
                entity.method_5808(x, y, z, entity.method_36454(), entity.method_36455());
                if (level.method_8320(blockPos).method_26164(ESTags.Blocks.STARFIRE_BIRD_NESTS) && !emergency && !bird.method_6109() && bird.method_6482() && bird.method_5618() == 0 && blockEntity.removeSeeds()) {
                    class_1657 loveCause = null;
                    if (blockEntity.lastSeedPlayer != null) {
                        loveCause = level.method_18470(blockEntity.lastSeedPlayer);
                    }
                    bird.method_6480(loveCause);
                }
                bird.addTrustedPlayer(blockEntity.lastSeedPlayer);
                bird.addGiftCount();
                bird.setStayOutOfNestTicks(renterCooldown);
            }
            level.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43286((class_1297)entity, (class_2680)level.method_8320(blockPos)));
            return level.method_8649(entity);
        }
        return false;
    }

    private static void tickOccupants(class_1937 level, class_2338 pos, class_2680 state, StarfireBirdNestBlockEntity blockEntity, List<BirdData> list) {
        boolean change = false;
        Iterator<BirdData> iterator = list.iterator();
        while (iterator.hasNext()) {
            BirdData data = iterator.next();
            if (!data.tick() || !StarfireBirdNestBlockEntity.releaseOccupant(level, pos, state, blockEntity, data.toOccupant(), null, false, 1200)) continue;
            change = true;
            iterator.remove();
        }
        int eggs = (Integer)state.method_11654((class_2769)StarfireBirdNestBlock.EGGS);
        if (eggs > 0) {
            ++blockEntity.hatchTicks;
            if (!blockEntity.isFullForBabies() && blockEntity.hatchTicks > 6000) {
                StarfireBird baby = new StarfireBird(ESEntities.STARFIRE_BIRD.get(), level);
                baby.method_7217(true);
                baby.method_29495(pos.method_46558());
                if (level instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)level;
                    baby.method_5943((class_5425)serverLevel, level.method_8404(pos), class_3730.field_16466, null);
                }
                blockEntity.addBabyOccupant((class_1297)baby);
                change = true;
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)StarfireBirdNestBlock.EGGS, (Comparable)Integer.valueOf(eggs - 1)));
                blockEntity.hatchTicks = 0;
            }
        } else {
            blockEntity.hatchTicks = 0;
        }
        if (change) {
            blockEntity.method_5431();
        }
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, StarfireBirdNestBlockEntity blockEntity) {
        for (BirdData data : blockEntity.stored) {
            data.clientTick(level);
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, StarfireBirdNestBlockEntity blockEntity) {
        StarfireBirdNestBlockEntity.tickOccupants(level, pos, state, blockEntity, blockEntity.stored);
        if (!blockEntity.stored.isEmpty() && level.method_8409().method_43058() < 0.005) {
            level.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, ESSoundEvents.STARFIRE_BIRD_AMBIENT.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    protected void method_11014(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11014(compoundTag, provider);
        this.stored.clear();
        if (compoundTag.method_10545(TAG_BIRDS)) {
            Occupant.LIST_CODEC.parse((DynamicOps)class_2509.field_11560, (Object)compoundTag.method_10580(TAG_BIRDS)).resultOrPartial(string -> EternalStarlight.LOGGER.error("Failed to parse Starfire Birds: '{}'", string)).ifPresent(list -> list.forEach(this::storeBird));
        }
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
        if (compoundTag.method_25928(TAG_LAST_SEED_PLAYER)) {
            this.lastSeedPlayer = compoundTag.method_25926(TAG_LAST_SEED_PLAYER);
        }
        this.hatchTicks = compoundTag.method_10550(TAG_HATCH_TICKS);
        this.method_5431();
    }

    protected void method_11007(class_2487 compoundTag, class_7225.class_7874 provider) {
        super.method_11007(compoundTag, provider);
        compoundTag.method_10566(TAG_BIRDS, (class_2520)Occupant.LIST_CODEC.encodeStart((DynamicOps)class_2509.field_11560, this.getBirds()).getOrThrow());
        class_1262.method_5426((class_2487)compoundTag, this.items, (class_7225.class_7874)provider);
        if (this.lastSeedPlayer != null) {
            compoundTag.method_25927(TAG_LAST_SEED_PLAYER, this.lastSeedPlayer);
        }
        compoundTag.method_10569(TAG_HATCH_TICKS, this.hatchTicks);
    }

    @Override
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38242(provider);
    }

    @Override
    protected void method_57568(class_2586.class_9473 input) {
        super.method_57568(input);
        this.stored.clear();
        List occupants = (List)input.method_58695(ESDataComponents.BIRDS.get(), List.of());
        occupants.forEach(this::storeBird);
        this.method_5431();
    }

    @Override
    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(ESDataComponents.BIRDS.get(), this.getBirds());
    }

    @Override
    public void method_57569(class_2487 compoundTag) {
        super.method_57569(compoundTag);
        compoundTag.method_10551(TAG_BIRDS);
    }

    private List<Occupant> getBirds() {
        return this.stored.stream().map(BirdData::toOccupant).toList();
    }

    public record Occupant(class_9279 entityData, int ticksInNest, int minTicksInNest) {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_9279.field_49303.optionalFieldOf("entity_data", (Object)class_9279.field_49302).forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("ticks_in_nest").forGetter(Occupant::ticksInNest), (App)Codec.INT.fieldOf("min_ticks_in_nest").forGetter(Occupant::minTicksInNest)).apply((Applicative)instance, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final class_9139<ByteBuf, Occupant> STREAM_CODEC = class_9139.method_56436((class_9139)class_9279.field_49305, Occupant::entityData, (class_9139)class_9135.field_48550, Occupant::ticksInNest, (class_9139)class_9135.field_48550, Occupant::minTicksInNest, Occupant::new);

        public static Occupant of(class_1297 entity, int minTicksInNest) {
            class_2487 compoundTag = new class_2487();
            entity.method_5662(compoundTag);
            IGNORED_BIRD_TAGS.forEach(arg_0 -> ((class_2487)compoundTag).method_10551(arg_0));
            return new Occupant(class_9279.method_57456((class_2487)compoundTag), 0, minTicksInNest);
        }

        public static Occupant create(class_5819 random, int ticksInNest) {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10582("id", class_7923.field_41177.method_10221(ESEntities.STARFIRE_BIRD.get()).toString());
            if (random.method_43048(20) == 0) {
                compoundTag.method_10556("special_variant", true);
            }
            return new Occupant(class_9279.method_57456((class_2487)compoundTag), ticksInNest, 600);
        }

        @Nullable
        public class_1297 createEntity(class_1937 level, class_2338 blockPos, boolean setData) {
            class_2487 compoundTag = this.entityData.method_57461();
            IGNORED_BIRD_TAGS.forEach(arg_0 -> ((class_2487)compoundTag).method_10551(arg_0));
            class_1297 entity = class_1299.method_17842((class_2487)compoundTag, (class_1937)level, e -> e);
            if (entity != null) {
                entity.method_5875(true);
                if (entity instanceof StarfireBird) {
                    StarfireBird bird = (StarfireBird)entity;
                    bird.setNestPos(blockPos);
                    if (setData) {
                        Occupant.setBirdReleaseData(this.ticksInNest, bird);
                    }
                }
                return entity;
            }
            return null;
        }

        private static void setBirdReleaseData(int ticksInNest, StarfireBird bird) {
            int age = bird.method_5618();
            if (age < 0) {
                bird.method_5614(Math.min(0, age + ticksInNest));
            } else if (age > 0) {
                bird.method_5614(Math.max(0, age - ticksInNest));
            }
            bird.method_6476(Math.max(0, bird.method_29270() - ticksInNest));
        }
    }

    public static class BirdData {
        private final Occupant occupant;
        private int ticksInNest;
        private class_1297 entityInstance;
        private int clientTickOffset = -1;

        private BirdData(Occupant occupant) {
            this.occupant = occupant;
            this.ticksInNest = occupant.ticksInNest();
        }

        public boolean tick() {
            return this.ticksInNest++ > this.occupant.minTicksInNest;
        }

        public void clientTick(class_1937 level) {
            if (this.clientTickOffset == -1) {
                this.clientTickOffset = level.method_8409().method_43048(1000);
            }
            if (this.entityInstance != null) {
                ++this.entityInstance.field_6012;
                class_1297 class_12972 = this.entityInstance;
                if (class_12972 instanceof StarfireBird) {
                    StarfireBird bird = (StarfireBird)class_12972;
                    bird.idleAnimationState.method_41324(bird.field_6012 - this.clientTickOffset);
                    bird.nestIdleAnimationState.method_41324(bird.field_6012 - this.clientTickOffset);
                }
            }
        }

        public Occupant toOccupant() {
            return new Occupant(this.occupant.entityData, this.ticksInNest, this.occupant.minTicksInNest);
        }

        public class_1297 getOrCreateEntityInstance(class_1937 level, class_2338 pos) {
            if (this.entityInstance == null) {
                this.entityInstance = this.occupant.createEntity(level, pos, false);
                if (this.entityInstance != null) {
                    class_1309 living;
                    this.entityInstance.method_36457(0.0f);
                    this.entityInstance.field_6004 = 0.0f;
                    this.entityInstance.method_36456(0.0f);
                    this.entityInstance.field_5982 = 0.0f;
                    this.entityInstance.method_5636(0.0f);
                    class_1297 class_12972 = this.entityInstance;
                    if (class_12972 instanceof class_1309) {
                        living = (class_1309)class_12972;
                        living.field_6220 = 0.0f;
                    }
                    this.entityInstance.method_5847(0.0f);
                    class_12972 = this.entityInstance;
                    if (class_12972 instanceof class_1309) {
                        living = (class_1309)class_12972;
                        living.field_6259 = 0.0f;
                    }
                }
            }
            return this.entityInstance;
        }
    }
}

