/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.SmoothSegmentedValue;
import net.minecraft.class_1262;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5253;
import net.minecraft.class_7225;

public class StellarRackBlockEntity
extends class_2621 {
    private static final SmoothSegmentedValue RED = SmoothSegmentedValue.of(Easing.IN_OUT_EXPO, 0.9843137f, 0.5921569f, 0.5f).add(Easing.IN_OUT_EXPO, 0.5921569f, 0.9843137f, 0.5f);
    private static final SmoothSegmentedValue GREEN = SmoothSegmentedValue.of(Easing.IN_OUT_EXPO, 0.5058824f, 0.88235295f, 0.5f).add(Easing.IN_OUT_EXPO, 0.88235295f, 0.5058824f, 0.5f);
    private static final SmoothSegmentedValue BLUE = SmoothSegmentedValue.of(Easing.IN_OUT_EXPO, 0.007843138f, 0.98039216f, 0.5f).add(Easing.IN_OUT_EXPO, 0.98039216f, 0.007843138f, 0.5f);
    private static final SmoothSegmentedValue ALPHA = SmoothSegmentedValue.of(Easing.IN_OUT_EXPO, 0.9f, 1.0f, 0.5f).add(Easing.IN_OUT_EXPO, 1.0f, 0.9f, 0.5f);
    private class_2371<class_1799> items = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
    private int tickCount = 0;
    private float oldStarRotation;
    private float starRotation;

    public StellarRackBlockEntity(class_2338 pos, class_2680 state) {
        this(ESBlockEntities.STELLAR_RACK.get(), pos, state);
    }

    public StellarRackBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public boolean anyEmpty() {
        return this.items.stream().anyMatch(class_1799::method_7960);
    }

    public boolean placeItem(class_1799 itemStack) {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            this.method_5447(i, itemStack);
            this.markUpdated();
            return true;
        }
        return false;
    }

    private void markUpdated() {
        if (this.method_10997() != null) {
            this.method_5431();
            this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public static void tick(class_1937 level, class_2338 pos, class_2680 state, StellarRackBlockEntity entity) {
        ++entity.tickCount;
        entity.oldStarRotation = entity.starRotation;
        entity.starRotation += 0.17453292f;
        if (level.field_9236) {
            EternalStarlight.getClientHelper().spawnStellarRackParticles(pos.method_46558());
            float angle = 360.0f / (float)entity.method_11282().stream().filter(i -> !i.method_7960()).count();
            float accumulatedAngle = entity.getStarRotation(0.0f) * 0.4f * 57.295776f;
            for (class_1799 itemStack : entity.method_11282()) {
                if (itemStack.method_7960()) continue;
                class_243 vec3 = ESMathUtil.rotationToPosition(0.9f, 0.0f, accumulatedAngle += angle);
                EternalStarlight.getClientHelper().spawnStellarRackItemParticles(entity.method_11016().method_61082().method_1031(0.0, 0.9, 0.0).method_1019(vec3));
            }
        }
        if (level.method_8510() % 600L == 0L) {
            level.method_8396(null, pos, ESSoundEvents.STELLAR_RACK_AMBIENT.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public int getColor(float partialTicks) {
        float ticks = ((float)this.getTickCount() + partialTicks) % 250.0f;
        return class_5253.class_5254.method_59554((float)ALPHA.calculate(ticks / 250.0f), (float)RED.calculate(ticks / 250.0f), (float)GREEN.calculate(ticks / 250.0f), (float)BLUE.calculate(ticks / 250.0f));
    }

    public float getStarRotation(float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)this.oldStarRotation, (float)this.starRotation);
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.eternal_starlight.stellar_rack");
    }

    public class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> items) {
        this.items = items;
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return null;
    }

    public int method_5439() {
        return 5;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 compoundTag = new class_2487();
        class_1262.method_5427((class_2487)compoundTag, this.items, (boolean)true, (class_7225.class_7874)provider);
        return compoundTag;
    }

    protected void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        if (!this.method_54871(tag)) {
            class_1262.method_5429((class_2487)tag, this.items, (class_7225.class_7874)provider);
        }
    }

    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (!this.method_54872(tag)) {
            class_1262.method_5426((class_2487)tag, this.items, (class_7225.class_7874)provider);
        }
    }
}

