/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.helper;

import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.client.book.BookDefinition;
import cn.leolezury.eternalstarlight.common.client.book.component.BookComponentRegistry;
import cn.leolezury.eternalstarlight.common.client.book.component.ConfiguredBookComponent;
import cn.leolezury.eternalstarlight.common.client.book.component.IndexBookComponent;
import cn.leolezury.eternalstarlight.common.client.gui.screen.BookScreen;
import cn.leolezury.eternalstarlight.common.client.gui.screen.CrestSelectionScreen;
import cn.leolezury.eternalstarlight.common.client.gui.screen.GatekeeperDialogueScreen;
import cn.leolezury.eternalstarlight.common.client.gui.toast.SimpleTextToast;
import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.helper.ClientHelper;
import cn.leolezury.eternalstarlight.common.client.particle.advanced.AdvancedParticleOptions;
import cn.leolezury.eternalstarlight.common.entity.living.boss.gatekeeper.TheGatekeeper;
import cn.leolezury.eternalstarlight.common.entity.projectile.SoulitSpectator;
import cn.leolezury.eternalstarlight.common.network.ClientDismountPacket;
import cn.leolezury.eternalstarlight.common.network.ClientMountPacket;
import cn.leolezury.eternalstarlight.common.network.NoParametersPacket;
import cn.leolezury.eternalstarlight.common.network.OpenBookPacket;
import cn.leolezury.eternalstarlight.common.network.OpenCrestGuiPacket;
import cn.leolezury.eternalstarlight.common.network.OpenGatekeeperGuiPacket;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.network.UpdateBookPacket;
import cn.leolezury.eternalstarlight.common.network.UpdateCameraPacket;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.spell.ManaType;
import cn.leolezury.eternalstarlight.common.util.Color;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.SmoothSegmentedValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ClientSideHelper
implements ClientHelper {
    @Override
    public void handleS2cNoParam(NoParametersPacket packet) {
        switch (packet.id()) {
            case "cancel_weather": {
                ClientWeatherState.weather = null;
            }
        }
    }

    @Override
    public void handleParticlePacket(ParticlePacket packet) {
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (clientLevel != null) {
            clientLevel.method_8466(packet.particle(), true, packet.x(), packet.y(), packet.z(), packet.dx(), packet.dy(), packet.dz());
        }
    }

    @Override
    public void handleOpenCrestGui(OpenCrestGuiPacket packet) {
        if (packet.ownedCrests().isEmpty()) {
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"message.eternal_starlight.no_crest"), true);
            }
        } else {
            class_310.method_1551().method_1507((class_437)new CrestSelectionScreen(packet.crests(), packet.ownedCrests()));
        }
    }

    @Override
    public void handleUpdateCamera(UpdateCameraPacket packet) {
        class_1297 camera;
        if (packet.cameraId() == -1) {
            ClientHandlers.resetCameraIn = 0;
        } else if (class_310.method_1551().field_1687 != null && !(class_310.method_1551().method_1560() instanceof SoulitSpectator) && (camera = class_310.method_1551().field_1687.method_8469(packet.cameraId())) != null) {
            ClientHandlers.resetCameraIn = 260;
            class_310.method_1551().field_1690.field_1842 = true;
            class_310.method_1551().method_1504(camera);
        }
    }

    @Override
    public void handleClientMount(ClientMountPacket packet) {
        if (class_310.method_1551().field_1687 != null) {
            class_1297 rider = class_310.method_1551().field_1687.method_8469(packet.riderId());
            class_1297 vehicle = class_310.method_1551().field_1687.method_8469(packet.vehicleId());
            if (rider != null && vehicle != null) {
                rider.method_5873(vehicle, true);
            }
        }
    }

    @Override
    public void handleClientDismount(ClientDismountPacket packet) {
        class_1297 rider;
        if (class_310.method_1551().field_1687 != null && (rider = class_310.method_1551().field_1687.method_8469(packet.riderId())) != null) {
            rider.method_5848();
        }
    }

    @Override
    public void handleOpenGatekeeperGui(OpenGatekeeperGuiPacket packet) {
        class_1297 class_12972;
        class_638 clientLevel = class_310.method_1551().field_1687;
        if (clientLevel != null && (class_12972 = clientLevel.method_8469(packet.id())) instanceof TheGatekeeper) {
            TheGatekeeper gatekeeper = (TheGatekeeper)class_12972;
            class_310.method_1551().method_1507((class_437)new GatekeeperDialogueScreen(gatekeeper, packet.challenged()));
        }
    }

    @Override
    public void handleUpdateBook(UpdateBookPacket packet) {
        HashSet<class_2960> bookIds = new HashSet<class_2960>();
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_1661 inventory = player.method_31548();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1799 stack = inventory.method_5438(i);
                class_2960 bookId = (class_2960)stack.method_57824(ESDataComponents.BOOK.get());
                if (bookId == null) continue;
                bookIds.add(bookId);
            }
        }
        Set definitions = bookIds.stream().map(ClientHandlers.books::getBook).collect(Collectors.toSet());
        ArrayList<IndexBookComponent.Entry> newEntries = new ArrayList<IndexBookComponent.Entry>();
        ArrayList<IndexBookComponent.Entry> changedEntries = new ArrayList<IndexBookComponent.Entry>();
        for (BookDefinition definition : definitions) {
            ArrayList entries = new ArrayList();
            definition.components().stream().flatMap(Collection::stream).filter(c -> c.component() == BookComponentRegistry.INDEX).forEach(c -> {
                Object patt0$temp = c.config();
                if (patt0$temp instanceof IndexBookComponent.Config) {
                    IndexBookComponent.Config config = (IndexBookComponent.Config)patt0$temp;
                    entries.addAll(config.entries());
                }
            });
            block2: for (IndexBookComponent.Entry entry : entries) {
                boolean enabled;
                Optional<ConfiguredBookComponent<?, ?>> jumpTo = definition.getComponent(entry.getJumpToId());
                boolean oldEnabled = jumpTo.isPresent() && jumpTo.get().isEnabled(packet.oldUnlocked());
                boolean bl = enabled = jumpTo.isPresent() && jumpTo.get().isEnabled(packet.unlocked());
                if (!oldEnabled && enabled) {
                    newEntries.add(entry);
                }
                for (class_2960 listeningId : entry.getListeningIds()) {
                    boolean listeningEnabled;
                    Optional<ConfiguredBookComponent<?, ?>> listening = definition.getComponent(listeningId);
                    boolean oldListeningEnabled = listening.isPresent() && listening.get().isEnabled(packet.oldUnlocked());
                    boolean bl2 = listeningEnabled = listening.isPresent() && listening.get().isEnabled(packet.unlocked());
                    if (oldListeningEnabled || !listeningEnabled) continue;
                    changedEntries.add(entry);
                    continue block2;
                }
            }
        }
        changedEntries.removeAll(newEntries);
        if (newEntries.size() > 3) {
            class_310.method_1551().method_1566().method_1999((class_368)new SimpleTextToast((class_2561)class_2561.method_43471((String)"book.eternal_starlight.unlock"), (class_2561)class_2561.method_43471((String)"book.eternal_starlight.unlock.multiple"), ESItems.BOOK.get().method_7854()));
        } else {
            for (IndexBookComponent.Entry entry : newEntries) {
                class_310.method_1551().method_1566().method_1999((class_368)new SimpleTextToast((class_2561)class_2561.method_43471((String)"book.eternal_starlight.unlock"), entry.getText(), entry.getIcon()));
            }
        }
        if (changedEntries.size() > 3) {
            class_310.method_1551().method_1566().method_1999((class_368)new SimpleTextToast((class_2561)class_2561.method_43471((String)"book.eternal_starlight.update"), (class_2561)class_2561.method_43471((String)"book.eternal_starlight.unlock.multiple"), ESItems.BOOK.get().method_7854()));
        } else {
            for (IndexBookComponent.Entry entry : changedEntries) {
                class_310.method_1551().method_1566().method_1999((class_368)new SimpleTextToast((class_2561)class_2561.method_43471((String)"book.eternal_starlight.update"), entry.getText(), entry.getIcon()));
            }
        }
    }

    @Override
    public void handleOpenBook(OpenBookPacket packet) {
        BookDefinition definition = ClientHandlers.books.getBook(packet.bookId());
        if (definition != null) {
            class_310.method_1551().method_1507((class_437)new BookScreen(definition, packet.unlocked()));
        }
    }

    @Override
    public void spawnStellarRackParticles(class_243 center) {
        int i;
        if ((double)AdvancedParticleOptions.RANDOM.method_43057() < 0.3) {
            if (AdvancedParticleOptions.RANDOM.method_43056()) {
                float size = (float)(1.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 0.4);
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, (float)((12.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 10.0) * 0.01745329238474369), (float)((18.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 10.0) * 0.01745329238474369), 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, size, 0.4f).add(Easing.IN_OUT_BOUNCE, size, 0.0f, 0.6f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.11764707f, 0.17764707f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.2682353f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.29882354f, 0.29411766f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.SHINE.get())), (float)center.field_1352, (float)center.field_1351, (float)center.field_1350);
            }
            for (i = 0; i < 4; ++i) {
                new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_BACK, 0.1f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.1f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.2f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.2f, 0.0f, 0.4f)).lifetime((int)(40.0 + ((double)AdvancedParticleOptions.RANDOM.method_43057() - 0.5) * 20.0)).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)center.field_1352, (float)center.field_1351, (float)center.field_1350);
            }
        }
        for (i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)center.field_1352, (float)center.field_1351 + 0.45f, (float)center.field_1350);
        }
    }

    @Override
    public void spawnStellarRackItemParticles(class_243 center) {
        for (int i = 0; i < 5; ++i) {
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.15f, 0.5f).add(Easing.IN_OUT_BOUNCE, 0.15f, 0.0f, 0.5f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, 0.29529414f, 0.23294118f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.14705883f, 0.14588235f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0023529413f, 0.21176472f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)center.field_1352, (float)center.field_1351, (float)center.field_1350);
        }
    }

    @Override
    public void spawnManaCrystalItemParticles(ManaType type, class_243 center) {
        for (int i = 0; i < 5; ++i) {
            class_243 pos = center.method_49272(AdvancedParticleOptions.RANDOM, 0.5f);
            Color color = Color.rgb(type.getColor());
            new AdvancedParticleOptions().speed(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, AdvancedParticleOptions.RANDOM.method_43057() * 0.015f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, (AdvancedParticleOptions.RANDOM.method_43057() - 0.5f) * 0.03f, 1.0f)).spinSpeed(SmoothSegmentedValue.of(Easing.IN_OUT_QUAD, 0.31415927f, 0.62831855f, 1.0f)).quadSize(SmoothSegmentedValue.of(Easing.IN_OUT_SINE, 0.0f, 0.25f, 0.6f).add(Easing.IN_OUT_BOUNCE, 0.25f, 0.0f, 0.4f)).lifetime(12).color(SmoothSegmentedValue.of(Easing.IN_OUT_QUART, (float)color.r() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.g() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.IN_OUT_SINE, (float)color.b() * 0.4f / 255.0f, 0.3f, 1.0f), SmoothSegmentedValue.of(Easing.OUT_QUINT, 0.0f, 1.0f, 0.7f).add(Easing.IN_OUT_QUAD, 1.0f, 0.0f, 0.3f)).defaultOperators().spawn(class_7923.field_41180.method_10221((Object)((class_2396)ESParticles.ADVANCED_GLOW.get())), (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350);
        }
    }
}

