/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.resource;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.book.BookDefinition;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BookLoader
extends class_4309 {
    private final Map<class_2960, BookDefinition> books = new HashMap<class_2960, BookDefinition>();

    public BookLoader() {
        super(new Gson(), "eternal_starlight/books");
    }

    @Nullable
    public BookDefinition getBook(class_2960 key) {
        return this.books.get(key);
    }

    public void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        this.books.clear();
        int loaded = 0;
        for (Map.Entry<class_2960, JsonElement> entry : jsons.entrySet()) {
            try {
                BookDefinition definition = (BookDefinition)BookDefinition.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow(JsonParseException::new);
                this.books.put(entry.getKey(), definition);
                ++loaded;
            }
            catch (Exception e) {
                EternalStarlight.LOGGER.error("Failed to book definition {}", (Object)entry.getKey(), (Object)e);
            }
        }
        EternalStarlight.LOGGER.info("Loaded {} book definitions", (Object)loaded);
    }
}

