/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.visual;

import cn.leolezury.eternalstarlight.common.client.handler.ClientHandlers;
import cn.leolezury.eternalstarlight.common.client.visual.WorldVisualEffect;
import cn.leolezury.eternalstarlight.common.entity.interfaces.TrailOwner;
import cn.leolezury.eternalstarlight.common.util.TrailEffect;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;

@Environment(value=EnvType.CLIENT)
public class TrailVisualEffect<T extends class_1297>
implements WorldVisualEffect {
    private final T entity;
    private final TrailEffect effect;
    private boolean shouldRemove;

    public TrailVisualEffect(class_1297 entity) {
        if (!(entity instanceof TrailOwner)) {
            throw new UnsupportedOperationException("Entity using TrailVisualEffect must implement TrailOwner");
        }
        this.entity = entity;
        this.effect = ((TrailOwner)entity).newTrail();
    }

    public T getEntity() {
        return this.entity;
    }

    public static void clientTick(class_638 level, List<WorldVisualEffect> visualEffects) {
        for (class_1297 entity : level.method_18112()) {
            if (!(entity instanceof TrailOwner) || entity.field_6012 <= 2 || !visualEffects.stream().noneMatch(effect -> {
                TrailVisualEffect trail;
                return effect instanceof TrailVisualEffect && (trail = (TrailVisualEffect)effect).getEntity().method_5628() == entity.method_5628();
            })) continue;
            visualEffects.add(new TrailVisualEffect(entity));
        }
    }

    @Override
    public void worldTick() {
        if (class_310.method_1551().field_1687 == null) {
            this.shouldRemove = true;
            return;
        }
        boolean shouldRender = false;
        for (class_1297 toRender : class_310.method_1551().field_1687.method_18112()) {
            if (toRender != this.entity) continue;
            shouldRender = true;
            break;
        }
        if (!shouldRender && !this.entity.method_31481()) {
            this.shouldRemove = true;
            return;
        }
        if (this.entity.method_31481() && this.effect.getLength() <= 0.0f) {
            this.shouldRemove = true;
        }
        ((TrailOwner)this.entity).updateTrail(this.effect);
    }

    @Override
    public void render(class_4597 source, class_4587 stack, float partialTicks) {
        boolean entityRemoved = this.entity.method_31481();
        float x = (float)(entityRemoved ? this.entity.method_23317() : class_3532.method_16436((double)partialTicks, (double)((class_1297)this.entity).field_6038, (double)this.entity.method_23317()));
        float y = (float)(entityRemoved ? this.entity.method_23318() : class_3532.method_16436((double)partialTicks, (double)((class_1297)this.entity).field_5971, (double)this.entity.method_23318()));
        float z = (float)(entityRemoved ? this.entity.method_23321() : class_3532.method_16436((double)partialTicks, (double)((class_1297)this.entity).field_5989, (double)this.entity.method_23321()));
        this.effect.prepareRender(new class_243((double)x, (double)y, (double)z).method_1031(0.0, (double)(this.entity.method_17682() / 2.0f), 0.0), partialTicks);
        this.effect.render(ClientHandlers.DELAYED_BUFFER_SOURCE.getBuffer(((TrailOwner)this.entity).getTrailRenderType()), stack, ((TrailOwner)this.entity).getTrailColor().x, ((TrailOwner)this.entity).getTrailColor().y, ((TrailOwner)this.entity).getTrailColor().z, ((TrailOwner)this.entity).getTrailColor().w, ((TrailOwner)this.entity).isTrailFullBright() ? 0xF000F0 : class_310.method_1551().method_1561().method_23839(this.entity, partialTicks));
    }

    @Override
    public boolean shouldRemove() {
        return this.shouldRemove;
    }
}

