/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.ESKeyframeAnimations;
import cn.leolezury.eternalstarlight.common.client.model.animation.PlayerAnimator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_7184;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_591.class})
public abstract class PlayerModelMixin<T extends class_1309>
implements AnimatedModel {
    @Unique
    private static List<PlayerAnimator.AnimationTransformer> transformers = new ArrayList<PlayerAnimator.AnimationTransformer>();
    @Unique
    private static PlayerAnimator.PlayerAnimationState playerAnimationState;
    @Unique
    private static class_742 animatedPlayer;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="RETURN")})
    private void setupAnim(T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (livingEntity instanceof class_742) {
            class_742 player = (class_742)livingEntity;
            for (Map.Entry<PlayerAnimator.AnimationTrigger, PlayerAnimator.AnimationStateFunction> entry : PlayerAnimator.ANIMATIONS.entrySet()) {
                if (!entry.getKey().shouldPlay(player)) continue;
                PlayerAnimator.PlayerAnimationState state = entry.getValue().get(player);
                transformers = state.transformers();
                playerAnimationState = state;
                animatedPlayer = player;
                this.animatePlayer(entry.getKey().animateTicks(player, ageInTicks));
            }
        }
    }

    @Unique
    private void animatePlayer(float ticks) {
        class_7184 definition = playerAnimationState.chooseDefinition();
        boolean resetLeftArm = playerAnimationState.resetLeftArmBeforeAnimation();
        boolean resetRightArm = playerAnimationState.resetRightArmBeforeAnimation();
        class_591 playerModel = (class_591)this;
        if (resetLeftArm) {
            playerModel.field_27433.method_41923();
            playerModel.field_3484.method_41923();
        }
        if (resetRightArm) {
            playerModel.field_3401.method_41923();
            playerModel.field_3486.method_41923();
        }
        float scale = 1.0f;
        for (PlayerAnimator.AnimationTransformer transformer : transformers) {
            if (!transformer.shouldApply(playerAnimationState, animatedPlayer, playerModel)) continue;
            transformer.preAnimate(playerAnimationState, animatedPlayer, playerModel);
            scale = transformer.modifyScale(playerAnimationState, animatedPlayer, playerModel, scale);
            ticks = transformer.modifyTicks(playerAnimationState, animatedPlayer, playerModel, ticks);
        }
        ESKeyframeAnimations.animate(this, definition, (long)(ticks * 1000.0f / 20.0f), scale, ANIMATION_VECTOR_CACHE);
        for (PlayerAnimator.AnimationTransformer transformer : transformers) {
            if (!transformer.shouldApply(playerAnimationState, animatedPlayer, playerModel)) continue;
            transformer.postAnimate(playerAnimationState, animatedPlayer, playerModel);
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setupAnimResetPose(T livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        class_591 playerModel = (class_591)this;
        playerModel.field_3398.method_41923();
        playerModel.field_3391.method_41923();
        playerModel.field_3397.method_41923();
        playerModel.field_3392.method_41923();
    }

    @Override
    @Unique
    public class_630 root() {
        return null;
    }

    @Override
    @Unique
    public Optional<class_630> getAnyDescendantWithName(String name) {
        class_591 playerModel = (class_591)this;
        for (PlayerAnimator.AnimationTransformer transformer : transformers) {
            Optional<class_630> modelPart;
            if (!transformer.shouldApply(playerAnimationState, animatedPlayer, playerModel) || !(modelPart = transformer.modifyModelPart(playerAnimationState, animatedPlayer, playerModel, name)).isPresent()) continue;
            return modelPart;
        }
        switch (name) {
            case "hat": {
                return Optional.of(playerModel.field_3394);
            }
            case "head": {
                return Optional.of(playerModel.field_3398);
            }
            case "body": {
                return Optional.of(playerModel.field_3391);
            }
            case "jacket": {
                return Optional.of(playerModel.field_3483);
            }
            case "right_arm": {
                return Optional.of(playerModel.field_3401);
            }
            case "right_sleeve": {
                return Optional.of(playerModel.field_3486);
            }
            case "left_arm": {
                return Optional.of(playerModel.field_27433);
            }
            case "left_sleeve": {
                return Optional.of(playerModel.field_3484);
            }
            case "right_leg": {
                return Optional.of(playerModel.field_3392);
            }
            case "right_pants": {
                return Optional.of(playerModel.field_3479);
            }
            case "left_leg": {
                return Optional.of(playerModel.field_3397);
            }
            case "left_pants": {
                return Optional.of(playerModel.field_3482);
            }
        }
        return Optional.empty();
    }
}

