/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.structure.garden;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.LunarVineBlock;
import cn.leolezury.eternalstarlight.common.block.ShadegrieveBlock;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESStructurePieceTypes;
import cn.leolezury.eternalstarlight.common.util.MazeGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3532;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6625;

public class CursedGardenMazePiece
extends class_3443 {
    private static final int MAZE_SIZE = 37;
    private static final int STRUCTURE_SIZE = 111;
    private static final int STRUCTURE_HEIGHT = 12;
    private static final int CENTER_SIZE = 20;
    private static final int LUNAR_VINE_SIZE = 21;
    private static final Set<class_2350> HORIZONTAL_DIRECTIONS = Set.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034);
    private final class_3499 noConnection;
    private final class_3499 singleConnection;
    private final class_3499 doubleConnectionStraight;
    private final class_3499 doubleConnectionCorner;
    private final class_3499 tripleConnection;
    private final class_3499 allConnection;
    private boolean[][] maze = new boolean[37][37];

    public CursedGardenMazePiece(class_3485 templateManager, long seed, int x, int y, int z) {
        super(ESStructurePieceTypes.CURSED_GARDEN_MAZE.get(), 0, new class_3341(x - 55, y - 1, z - 55, x + 55, y + 12, z + 55));
        this.method_14926(class_2350.field_11035);
        this.noConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_no_connection"));
        this.singleConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_single_connection"));
        this.doubleConnectionStraight = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_double_connection_straight"));
        this.doubleConnectionCorner = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_double_connection_corner"));
        this.tripleConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_triple_connection"));
        this.allConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_all_connection"));
        MazeGenerator mazeGenerator = new MazeGenerator(37, class_5819.method_43049((long)(seed + new class_2338(x, y, z).method_10063())));
        this.maze = mazeGenerator.generateMaze(1, 1);
        this.maze[0][18] = false;
        this.maze[1][18] = false;
        this.maze[18][0] = false;
        this.maze[18][1] = false;
        this.maze[36][18] = false;
        this.maze[35][18] = false;
        this.maze[18][36] = false;
        this.maze[18][35] = false;
        for (int i = 0; i < 37; ++i) {
            for (int j = 0; j < 37; ++j) {
                if (!(Math.pow((double)(i * 3 + 1) - 55.5, 2.0) + Math.pow((double)(j * 3 + 1) - 55.5, 2.0) < 400.0)) continue;
                this.maze[i][j] = false;
            }
        }
    }

    public CursedGardenMazePiece(class_6625 context, class_2487 tag) {
        super(ESStructurePieceTypes.CURSED_GARDEN_MAZE.get(), tag);
        this.method_14926(class_2350.field_11035);
        class_3485 templateManager = context.comp_135();
        this.noConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_no_connection"));
        this.singleConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_single_connection"));
        this.doubleConnectionStraight = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_double_connection_straight"));
        this.doubleConnectionCorner = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_double_connection_corner"));
        this.tripleConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_triple_connection"));
        this.allConnection = templateManager.method_15091(EternalStarlight.id("cursed_garden/maze_all_connection"));
        class_2499 xTag = tag.method_10554("maze", 9);
        for (int x = 0; x < 37; ++x) {
            class_2520 yTag;
            if (x >= xTag.size() || !((yTag = xTag.method_10534(x)) instanceof class_2499)) continue;
            class_2499 yList = (class_2499)yTag;
            for (int y = 0; y < 37; ++y) {
                class_2520 class_25202;
                if (y >= yList.size() || !((class_25202 = yList.method_10534(y)) instanceof class_2481)) continue;
                class_2481 byteTag = (class_2481)class_25202;
                this.maze[x][y] = byteTag.method_10698() != 0;
            }
        }
    }

    protected void method_14943(class_6625 context, class_2487 tag) {
        class_2499 xTag = new class_2499();
        for (int x = 0; x < 37; ++x) {
            class_2499 yTag = new class_2499();
            for (int y = 0; y < 37; ++y) {
                yTag.add((Object)class_2481.method_23234((boolean)this.maze[x][y]));
            }
            xTag.add((Object)yTag);
        }
        tag.method_10566("maze", (class_2520)xTag);
    }

    public void method_14931(class_5281 level, class_5138 structureManager, class_2794 generator, class_5819 random, class_3341 box, class_1923 chunkPos, class_2338 blockPos) {
        for (int x = 0; x < 37; ++x) {
            for (int z = 0; z < 37; ++z) {
                if (this.maze[x][z]) {
                    class_2338.class_2339 pillarPos = this.method_33781(x * 3, 1, z * 3);
                    HashSet<class_2350> connectedDirs = new HashSet<class_2350>();
                    for (class_2350 direction : HORIZONTAL_DIRECTIONS) {
                        int connectedX = x + direction.method_10148();
                        int connectedZ = z + direction.method_10165();
                        if (connectedX < 0 || connectedX >= 37 || connectedZ < 0 || connectedZ >= 37 || !this.maze[connectedX][connectedZ]) continue;
                        connectedDirs.add(direction);
                    }
                    switch (connectedDirs.size()) {
                        case 0: {
                            this.noConnection.method_15172((class_5425)level, (class_2338)pillarPos, (class_2338)pillarPos, new class_3492().method_15126(box), random, 2);
                            break;
                        }
                        case 1: {
                            connectedDirs.stream().findFirst().ifPresent(arg_0 -> this.lambda$postProcess$0(level, (class_2338)pillarPos, box, random, arg_0));
                            break;
                        }
                        case 2: {
                            connectedDirs.stream().findFirst().ifPresent(arg_0 -> this.lambda$postProcess$3(connectedDirs, level, (class_2338)pillarPos, box, random, arg_0));
                            break;
                        }
                        case 3: {
                            new HashSet<class_2350>(HORIZONTAL_DIRECTIONS).stream().filter(d -> !connectedDirs.contains(d)).findFirst().ifPresent(arg_0 -> this.lambda$postProcess$5(level, (class_2338)pillarPos, box, random, arg_0));
                            break;
                        }
                        case 4: {
                            this.allConnection.method_15172((class_5425)level, (class_2338)pillarPos, (class_2338)pillarPos, new class_3492().method_15126(box), random, 2);
                        }
                    }
                }
                for (int blockX = x * 3; blockX < x * 3 + 3; ++blockX) {
                    for (int blockZ = z * 3; blockZ < z * 3 + 3; ++blockZ) {
                        this.method_14917(level, x != 0 && x != 36 && z != 0 && z != 36 ? ESBlocks.TENACIOUS_NIGHTFALL_GRASS_BLOCK.get().method_9564() : ESBlocks.GRIMSTONE_BRICKS.get().method_9564(), blockX, 0, blockZ, box);
                        if (this.maze[x][z]) {
                            int leavesHeight = 3 + random.method_43048(3);
                            for (int y = 0; y < 11; ++y) {
                                this.method_14917(level, y <= leavesHeight && x != 0 && x != 36 && z != 0 && z != 36 ? (class_2680)(random.method_43048(3) == 0 ? ESBlocks.BLOOMING_SHADEGRIEVE.get() : ESBlocks.SHADEGRIEVE.get()).method_9564().method_11657((class_2769)ShadegrieveBlock.TOP, (Comparable)Boolean.valueOf(y == leavesHeight)) : (y == 10 ? ESBlocks.GRIMSTONE_TILE_SLAB.get().method_9564() : ESBlocks.GRIMSTONE_BRICKS.get().method_9564()), blockX, y + 2, blockZ, box);
                            }
                            continue;
                        }
                        for (int y = 0; y < 12; ++y) {
                            this.method_14917(level, class_2246.field_10124.method_9564(), blockX, y + 1, blockZ, box);
                        }
                    }
                }
            }
        }
        this.method_14917(level, ESBlocks.LUNAR_MONSTROSITY_SPAWNER.get().method_9564(), 55, 1, 55, box);
        ArrayList<class_2338> chestPositions = new ArrayList<class_2338>();
        for (int x = 1; x < 111; ++x) {
            for (int z = 1; z < 111; ++z) {
                if (this.method_14929((class_1922)level, x, 1, z, box).method_26215() || this.method_14929((class_1922)level, x, 1, z, box).method_27852(class_2246.field_10597) || this.method_14929((class_1922)level, x, 1, z, box).method_27852((class_2248)ESBlocks.LUNAR_VINE.get())) continue;
                for (class_2350 direction : class_2350.class_2353.field_11062.method_29716().toList()) {
                    int vineZ;
                    int vineX = x + direction.method_10148();
                    if (!this.method_14929((class_1922)level, vineX, 1, vineZ = z + direction.method_10165(), box).method_26215()) continue;
                    double distSqr = Math.pow((double)vineX - 55.5, 2.0) + Math.pow((double)vineZ - 55.5, 2.0);
                    boolean lunarVines = distSqr < 441.0;
                    boolean bossRoom = distSqr < 400.0;
                    int yTo = 12 - random.method_43048(8) - 1;
                    int yFrom = random.method_43048(yTo - 3) + 2;
                    direction = direction.method_10166() == class_2350.class_2351.field_11048 ? direction.method_10153() : direction;
                    for (int y = yFrom; y < yTo; ++y) {
                        if (!this.method_14929((class_1922)level, vineX, y, vineZ, box).method_26215() || !this.method_14929((class_1922)level, x, y, z, box).method_27852(ESBlocks.GRIMSTONE_BRICKS.get()) && !this.method_14929((class_1922)level, x, y, z, box).method_27852((class_2248)ESBlocks.SHADEGRIEVE.get())) continue;
                        this.method_14917(level, lunarVines ? (class_2680)ESBlocks.LUNAR_VINE.get().method_9564().method_11657((class_2769)LunarVineBlock.field_11177, (Comparable)direction) : (class_2680)class_2246.field_10597.method_9564().method_11657((class_2769)class_2541.field_11697.get(direction), (Comparable)Boolean.valueOf(true)), vineX, y, vineZ, box);
                    }
                    if (bossRoom || random.method_43048(45) != 0 || !chestPositions.stream().noneMatch(pos -> new class_2338(vineX, 1, vineZ).method_10262((class_2382)pos) <= 100.0)) continue;
                    chestPositions.add(new class_2338(vineX, 1, vineZ));
                    this.method_14915(level, box, random, vineX, 1, vineZ, ESLootTables.CHEST_CURSED_GARDEN);
                }
            }
        }
    }

    private /* synthetic */ void lambda$postProcess$5(class_5281 level, class_2338 pillarPos, class_3341 box, class_5819 random, class_2350 direction) {
        class_3492 class_34922 = new class_3492().method_15126(box);
        this.tripleConnection.method_15172((class_5425)level, pillarPos, pillarPos, class_34922.method_15123(switch (class_3532.method_15392((int)((int)(direction.method_10144() - class_2350.field_11043.method_10144())))) {
            case 90 -> class_2470.field_11463;
            case -180 -> class_2470.field_11464;
            case -90 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        }).method_15119(new class_2338(1, 0, 1)), random, 2);
    }

    private /* synthetic */ void lambda$postProcess$3(Set connectedDirs, class_5281 level, class_2338 pillarPos, class_3341 box, class_5819 random, class_2350 direction) {
        if (connectedDirs.contains(direction.method_10153())) {
            class_3492 class_34922 = new class_3492().method_15126(box);
            this.doubleConnectionStraight.method_15172((class_5425)level, pillarPos, pillarPos, class_34922.method_15123(switch (class_3532.method_15392((int)((int)(direction.method_10144() - class_2350.field_11034.method_10144())))) {
                case 90 -> class_2470.field_11463;
                case -180 -> class_2470.field_11464;
                case -90 -> class_2470.field_11465;
                default -> class_2470.field_11467;
            }).method_15119(new class_2338(1, 0, 1)), random, 2);
        } else {
            connectedDirs.stream().max((o1, o2) -> (int)Math.signum(class_3532.method_15381((float)o1.method_10144(), (float)o2.method_10144()))).ifPresent(dir -> {
                class_3492 class_34922 = new class_3492().method_15126(box);
                this.doubleConnectionCorner.method_15172((class_5425)level, pillarPos, pillarPos, class_34922.method_15123(switch (class_3532.method_15392((int)((int)(dir.method_10144() - class_2350.field_11034.method_10144())))) {
                    case 90 -> class_2470.field_11463;
                    case -180 -> class_2470.field_11464;
                    case -90 -> class_2470.field_11465;
                    default -> class_2470.field_11467;
                }).method_15119(new class_2338(1, 0, 1)), random, 2);
            });
        }
    }

    private /* synthetic */ void lambda$postProcess$0(class_5281 level, class_2338 pillarPos, class_3341 box, class_5819 random, class_2350 direction) {
        class_3492 class_34922 = new class_3492().method_15126(box);
        this.singleConnection.method_15172((class_5425)level, pillarPos, pillarPos, class_34922.method_15123(switch (class_3532.method_15392((int)((int)(direction.method_10144() - class_2350.field_11034.method_10144())))) {
            case 90 -> class_2470.field_11463;
            case -180 -> class_2470.field_11464;
            case -90 -> class_2470.field_11465;
            default -> class_2470.field_11467;
        }).method_15119(new class_2338(1, 0, 1)), random, 2);
    }
}

