/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.system.transformer;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.registry.ESDataTransformerTypes;
import cn.leolezury.eternalstarlight.common.world.gen.system.WorldGenProvider;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformer;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.DataTransformerType;
import cn.leolezury.eternalstarlight.common.world.gen.system.transformer.SkippingIterationTransformer;
import com.mojang.serialization.MapCodec;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;

public class MergedIterationTransformer
extends DataTransformer {
    public static final MapCodec<MergedIterationTransformer> CODEC = class_6895.method_40341(ESRegistries.DATA_TRANSFORMER, DataTransformer.CODEC).fieldOf("transformers").xmap(MergedIterationTransformer::new, transformer -> transformer.transformers);
    private final class_6885<DataTransformer> transformers;

    public MergedIterationTransformer(class_6885<DataTransformer> transformers) {
        this.transformers = transformers;
    }

    @Override
    public int[][] transform(int[][] original, int[][] related, WorldGenProvider provider, int areaX, int areaZ, int size, long seed, long seedAddition) {
        int[][] transformed = new int[size][size];
        int from = size <= 32 ? 0 : size / 4 - 8;
        int to = size - from;
        for (int x = 0; x < size; ++x) {
            for (int z = 0; z < size; ++z) {
                if (x >= from && x <= to && z >= from && z <= to) {
                    transformed[x][z] = original[x][z];
                    for (class_6880 transformer : this.transformers) {
                        Object object = transformer.comp_349();
                        if (!(object instanceof SkippingIterationTransformer)) continue;
                        SkippingIterationTransformer iterationTransformer = (SkippingIterationTransformer)object;
                        int originalValue = original[x][z];
                        original[x][z] = transformed[x][z];
                        transformed[x][z] = iterationTransformer.transform(original, related, provider, this.getRandomForPos(x, z, areaX, areaZ, size, seed + seedAddition), x, z, areaX, areaZ, size);
                        original[x][z] = originalValue;
                    }
                    continue;
                }
                transformed[x][z] = original[x][z];
            }
        }
        return transformed;
    }

    @Override
    public DataTransformerType<?> type() {
        return ESDataTransformerTypes.MERGED_ITERATION.get();
    }
}

