/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.the_harvest.block;

import com.robertx22.library_of_exile.components.PlayerDataCapability;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.utils.TeleportUtils;
import com.robertx22.the_harvest.block_entity.HarvestBE;
import com.robertx22.the_harvest.item.HarvestItemMapData;
import com.robertx22.the_harvest.item.HarvestItemNbt;
import com.robertx22.the_harvest.item.HarvestMapItem;
import com.robertx22.the_harvest.main.HarvestEntries;
import com.robertx22.the_harvest.main.HarvestMain;
import com.robertx22.the_harvest.main.HarvestWords;
import com.robertx22.the_harvest.structure.HarvestMapCap;
import com.robertx22.the_harvest.structure.HarvestMapData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;

public class HarvestBlock
extends BaseEntityBlock {
    public HarvestBlock() {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(10.0f).m_60955_().m_60953_(x -> 10));
    }

    public List<ItemStack> m_49635_(BlockState pState, LootParams.Builder pParams) {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>();
        BlockEntity blockentity = (BlockEntity)pParams.m_287159_(LootContextParams.f_81462_);
        if (blockentity instanceof HarvestBE) {
            HarvestBE be = (HarvestBE)blockentity;
            all.add(this.m_5456_().m_7968_());
        }
        return all;
    }

    public static void startNewMap(Player p, ItemStack stack, HarvestBE be) {
        HarvestItemMapData map = (HarvestItemMapData)HarvestItemNbt.HARVEST_MAP.loadFrom(stack);
        ChunkPos count = map.getOrSetStartPos(p.m_9236_(), stack);
        ChunkPos start = HarvestMain.HARVEST_MAP_STRUCTURE.getStartFromCounter(count.f_45578_, count.f_45579_);
        BlockPos pos = TeleportUtils.getSpawnTeleportPos((MapStructure)HarvestMain.HARVEST_MAP_STRUCTURE, (BlockPos)start.m_151394_(5));
        PlayerDataCapability pdata = PlayerDataCapability.get((Player)p);
        HarvestMapData data = new HarvestMapData();
        data.onStartMap(p);
        data.item = map;
        data.x = start.f_45578_;
        data.z = start.f_45579_;
        be.x = count.f_45578_;
        be.z = count.f_45579_;
        be.currentWorldUUID = HarvestMapCap.get((Level)p.m_9236_()).data.data.uuid;
        be.m_6596_();
        stack.m_41774_(1);
        HarvestMapCap.get((Level)p.m_9236_()).data.data.setData(p, data, (MapStructure)HarvestMain.HARVEST_MAP_STRUCTURE, start.m_151394_(5));
        pdata.mapTeleports.entranceTeleportLogic(p, HarvestMain.DIMENSION_KEY, pos);
    }

    public static void joinCurrentMap(Player p, HarvestBE be) {
        ChunkPos start = HarvestMain.HARVEST_MAP_STRUCTURE.getStartFromCounter(be.x, be.z);
        BlockPos pos = TeleportUtils.getSpawnTeleportPos((MapStructure)HarvestMain.HARVEST_MAP_STRUCTURE, (BlockPos)start.m_151394_(5));
        PlayerDataCapability pdata = PlayerDataCapability.get((Player)p);
        pdata.mapTeleports.entranceTeleportLogic(p, HarvestMain.DIMENSION_KEY, pos);
    }

    public InteractionResult m_6227_(BlockState pState, Level world, BlockPos pPos, Player p, InteractionHand pHand, BlockHitResult pHit) {
        HarvestBE obe;
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity be = world.m_7702_(pPos);
        HarvestBE harvestBE = obe = be instanceof HarvestBE ? (HarvestBE)be : null;
        if (obe == null) {
            HarvestMain.debugMsg(p, "Missing Block entity");
            return InteractionResult.SUCCESS;
        }
        boolean isMapWorld = MapDimensions.isMap((Level)world);
        ItemStack stack = p.m_21205_();
        if (HarvestItemNbt.HARVEST_MAP.has(stack)) {
            HarvestItemMapData map = (HarvestItemMapData)HarvestItemNbt.HARVEST_MAP.loadFrom(stack);
            if (!map.relic && isMapWorld) {
                p.m_213846_((Component)HarvestWords.RELIC_MAPS_ONLY.get(new Object[0]).m_130940_(ChatFormatting.RED));
                return InteractionResult.SUCCESS;
            }
            HarvestBlock.startNewMap(p, stack, obe);
            return InteractionResult.SUCCESS;
        }
        if (obe.isActivated()) {
            HarvestBlock.joinCurrentMap(p, obe);
            return InteractionResult.SUCCESS;
        }
        if (isMapWorld) {
            HarvestBlock.initMapSpecificHarvest(p, obe);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    private static void initMapSpecificHarvest(Player p, HarvestBE obe) {
        if (obe.gaveMap) {
            return;
        }
        obe.setGaveMap();
        ItemStack map = HarvestMapItem.blankMap(((HarvestMapItem)((Object)HarvestEntries.HARVEST_MAP_ITEM.get())).m_7968_(), true);
        HarvestBlock.startNewMap(p, map, obe);
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new HarvestBE(pPos, pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return new BlockEntityTicker<T>(){

            public void m_155252_(Level pLevel, BlockPos pPos, BlockState pState, T pBlockEntity) {
            }
        };
    }
}

