/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.the_harvest.main;

import com.google.common.collect.Lists;
import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfigDefaults;
import com.robertx22.library_of_exile.config.map_dimension.MapRegisterBuilder;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.init.PredeterminedResult;
import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.dimension.MapChunkGenEvent;
import com.robertx22.library_of_exile.dimension.MapContentType;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.helpers.OrderedModConstructor;
import com.robertx22.library_of_exile.registry.register_info.ModRequiredRegisterInfo;
import com.robertx22.library_of_exile.registry.util.ExileRegistryUtil;
import com.robertx22.library_of_exile.unidentified.IdentifiableItems;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.the_harvest.capability.HarvestEntityCap;
import com.robertx22.the_harvest.configs.HarvestConfig;
import com.robertx22.the_harvest.database.HarvestArena;
import com.robertx22.the_harvest.database.HarvestDatabase;
import com.robertx22.the_harvest.item.HarvestItemNbt;
import com.robertx22.the_harvest.item.HarvestMapItem;
import com.robertx22.the_harvest.main.ComponentInit;
import com.robertx22.the_harvest.main.HarvestClient;
import com.robertx22.the_harvest.main.HarvestCommands;
import com.robertx22.the_harvest.main.HarvestEntries;
import com.robertx22.the_harvest.main.HarvestLootTables;
import com.robertx22.the_harvest.main.HarvestMobValidator;
import com.robertx22.the_harvest.main.HarvestModConstructor;
import com.robertx22.the_harvest.main.HarvestWords;
import com.robertx22.the_harvest.structure.HarvestMapCap;
import com.robertx22.the_harvest.structure.HarvestMapData;
import com.robertx22.the_harvest.structure.HarvestMapStructure;
import com.robertx22.the_harvest.structure.HarvestWorldData;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="the_harvest")
public class HarvestMain {
    public static boolean RUN_DEV_TOOLS = false;
    public static String MODID = "the_harvest";
    public static String DIMENSION_ID = "the_harvest:harvest";
    public static ResourceLocation DIMENSION_KEY = new ResourceLocation(DIMENSION_ID);
    public static ModRequiredRegisterInfo REGISTER_INFO = new ModRequiredRegisterInfo(MODID);
    public static HarvestMapStructure HARVEST_MAP_STRUCTURE = new HarvestMapStructure();
    public static MapDimensionInfo MAP = new MapDimensionInfo(DIMENSION_KEY, (MapStructure)HARVEST_MAP_STRUCTURE, MapContentType.SIDE_CONTENT, Arrays.asList(new MapStructure[0]), new HarvestMobValidator(), new MapDimensionConfigDefaults(3, 2)){

        public void clearMapDataOnFolderWipe(MinecraftServer minecraftServer) {
            HarvestMapCap.get((Level)minecraftServer.m_129783_()).data = new HarvestWorldData();
        }
    };
    public static PredeterminedResult<MobList> DUNGEON_MOB_SPAWNS = new PredeterminedResult<MobList>(){

        public ExileRegistryType getRegistryType() {
            return LibDatabase.MOB_LIST;
        }

        public MobList getPredeterminedRandomINTERNAL(Random random, Level level, ChunkPos pos) {
            HarvestArena arena = HARVEST_MAP_STRUCTURE.getArena(pos);
            return (MobList)LibDatabase.MobLists().getFilterWrapped(x -> arena.mob_list_tag_check.matches((ExileRegistry)x).can).random(random.nextDouble());
        }
    };

    public static ResourceLocation id(String id) {
        return new ResourceLocation(MODID, id);
    }

    public static void debugMsg(Player p, String s) {
        if (p.m_7500_()) {
            p.m_213846_((Component)Component.m_237113_((String)("[Debug Info]:" + s)));
        }
    }

    public HarvestMain() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        OrderedModConstructor.register((OrderedModConstructor)new HarvestModConstructor(MODID), (IEventBus)bus);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> bus.addListener(this::clientSetup));
        new MapRegisterBuilder(MAP).chunkGenerator((EventConsumer)new EventConsumer<MapChunkGenEvent>(){

            public void accept(MapChunkGenEvent event) {
                if (event.mapId.equals("harvest")) {
                    HARVEST_MAP_STRUCTURE.generateInChunk((ServerLevelAccessor)event.world, event.manager, event.chunk.m_7697_());
                }
            }
        }, HarvestMain.id("harvest_chunk_gen")).build();
        if (RUN_DEV_TOOLS) {
            ExileRegistryUtil.setCurrentRegistarMod((String)MODID);
            ApiForgeEvents.registerForgeEvent(PlayerEvent.PlayerLoggedInEvent.class, event -> HarvestDatabase.INSTANCE.runDataGen(CachedOutput.f_236016_));
        }
        ApiForgeEvents.registerForgeEvent(GatherDataEvent.class, event -> {
            PackOutput output = event.getGenerator().getPackOutput();
            LootTableProvider.SubProviderEntry chestsLootTables = new LootTableProvider.SubProviderEntry(HarvestLootTables.Provider::new, LootContextParamSets.f_81411_);
            LootTableProvider provider = new LootTableProvider(output, Set.of(), List.of(chestsLootTables));
            event.getGenerator().addProvider(true, (DataProvider)provider);
            if (RUN_DEV_TOOLS) {
                // empty if block
            }
            try {
                event.getGenerator().m_123917_();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)HarvestConfig.SPEC);
        bus.addListener(this::commonSetupEvent);
        HarvestEntries.CREATIVE_TAB.register(MODID, () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 2).m_257737_(() -> ((BlockItem)HarvestEntries.HARVEST_ITEM.get()).m_7968_()).m_257941_((Component)HarvestWords.CREATIVE_TAB.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})).m_257501_(new CreativeModeTab.DisplayItemsGenerator(){

            public void m_257865_(CreativeModeTab.ItemDisplayParameters param, CreativeModeTab.Output output) {
                for (Item item : ForgeRegistries.ITEMS) {
                    if (!ForgeRegistries.ITEMS.getKey((Object)item).m_135827_().equals(MODID)) continue;
                    output.m_246326_((ItemLike)item);
                }
            }
        }).m_257652_());
        HarvestCommands.init();
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new EventConsumer<ExileEvents.OnChestLooted>(){

            public void accept(ExileEvents.OnChestLooted e) {
                try {
                    List<Integer> empty;
                    float chance = (float)((Double)HarvestConfig.get().MAP_SPAWN_CHANCE_ON_CHEST_LOOT.get() * (double)HarvestConfig.get().getDimChanceMulti(e.player.m_9236_()));
                    if (RandomUtils.roll((float)chance) && !MapDimensions.isMap((Level)e.player.m_9236_()) && !(empty = HarvestMain.mygetEmptySlotsRandomized(e.inventory, new Random())).isEmpty()) {
                        int index = (Integer)RandomUtils.randomFromList(empty);
                        ItemStack map = HarvestMapItem.blankMap(((HarvestMapItem)((Object)HarvestEntries.HARVEST_MAP_ITEM.get())).m_7968_(), false);
                        e.inventory.m_6836_(index, map);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        IdentifiableItems.register((ResourceLocation)HarvestEntries.HARVEST_MAP_ITEM.getId(), (IdentifiableItems.Config)new IdentifiableItems.Config(){

            public boolean isUnidentified(ItemStack stack) {
                return !HarvestItemNbt.HARVEST_MAP.has(stack);
            }

            public void identify(Player player, ItemStack stack) {
                HarvestMapItem.blankMap(stack, false);
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, event -> {
            float chance;
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            if (MapDimensions.isMap((Level)event.getEntity().m_9236_()) && HarvestEntityCap.get((LivingEntity)event.getEntity()).data.isHarvestSpawn && RandomUtils.roll((float)(chance = ((Double)HarvestConfig.get().LOOT_TABLE_CHANCE_PER_MOB.get()).floatValue()))) {
                this.dropFromLootTable(event.getEntity(), HarvestLootTables.LOOT, event.getSource());
            }
        });
        System.out.println("The Harvest loaded.");
    }

    protected void dropFromLootTable(LivingEntity en, ResourceLocation table, DamageSource pDamageSource) {
        ResourceLocation resourcelocation = table;
        LootTable loottable = en.m_9236_().m_7654_().m_278653_().m_278676_(resourcelocation);
        LootParams.Builder lootparams$builder = new LootParams.Builder((ServerLevel)en.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)en).m_287286_(LootContextParams.f_81460_, (Object)en.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)pDamageSource).m_287289_(LootContextParams.f_81458_, (Object)pDamageSource.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)pDamageSource.m_7640_());
        LootParams lootparams = lootparams$builder.m_287235_(LootContextParamSets.f_81415_);
        loottable.m_287276_(lootparams, en.m_287233_(), arg_0 -> ((LivingEntity)en).m_19983_(arg_0));
    }

    private static List<Integer> mygetEmptySlotsRandomized(Container inventory, Random rand) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (!inventory.m_8020_(i).m_41619_()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    public static Optional<HarvestMapData> ifMapData(Level level, BlockPos pos) {
        HarvestMapData mapdata;
        if (level.f_46443_) {
            return Optional.empty();
        }
        MapDimensionInfo map = MapDimensions.getInfo((Level)level);
        if (map != null && map.dimensionId.equals((Object)DIMENSION_KEY) && (mapdata = (HarvestMapData)HarvestMapCap.get((Level)level).data.data.getData((MapStructure)HARVEST_MAP_STRUCTURE, pos)) != null) {
            return Optional.of(mapdata);
        }
        return Optional.empty();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        HarvestClient.init();
    }

    public void commonSetupEvent(FMLCommonSetupEvent event) {
        ComponentInit.reg();
        MinecraftForge.EVENT_BUS.addGenericListener(Level.class, x -> x.addCapability(HarvestMapCap.RESOURCE, (ICapabilityProvider)new HarvestMapCap((Level)x.getObject())));
        MinecraftForge.EVENT_BUS.addGenericListener(Entity.class, x -> {
            Object patt13063$temp = x.getObject();
            if (patt13063$temp instanceof LivingEntity) {
                LivingEntity en = (LivingEntity)patt13063$temp;
                x.addCapability(HarvestEntityCap.RESOURCE, (ICapabilityProvider)new HarvestEntityCap(en));
            }
        });
    }
}

