/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.the_harvest.structure;

import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.database.mob_list.MobEntry;
import com.robertx22.library_of_exile.database.mob_list.MobList;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.the_harvest.capability.HarvestEntityCap;
import com.robertx22.the_harvest.configs.HarvestConfig;
import com.robertx22.the_harvest.database.holders.HarvestRelicStats;
import com.robertx22.the_harvest.item.HarvestItemMapData;
import com.robertx22.the_harvest.main.HarvestMain;
import com.robertx22.the_harvest.main.HarvestWords;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HarvestMapData {
    public HarvestItemMapData item = new HarvestItemMapData();
    public int mobsLeft = 0;
    public int ticksLeft = 2400;
    public int x = 0;
    public int z = 0;
    public Long tileTicker = 0L;

    public void onStartMap(Player p) {
        this.mobsLeft = (Integer)HarvestConfig.get().MAX_TOTAL_MOB_SPAWNS.get();
        this.ticksLeft = 2400;
    }

    public List<LivingEntity> getAllLivingMobs(Level world, BlockPos pos) {
        return world.m_45976_(LivingEntity.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)30.0, (double)30.0, (double)30.0)).stream().filter(x -> HarvestEntityCap.get((LivingEntity)x).data.isHarvestSpawn).collect(Collectors.toList());
    }

    void tickSecond(Level world, BlockPos pos) {
        block6: {
            if (this.mobsLeft < 1 && this.ticksLeft > 20) {
                this.ticksLeft = 10;
            }
            if (this.tileTicker == 0L) {
                this.tileTicker = pos.m_121878_();
            }
            if (this.ticksLeft <= 0 || pos.m_121878_() != this.tileTicker.longValue()) break block6;
            this.ticksLeft -= 20;
            if (this.ticksLeft < 0) {
                for (Player p : HarvestMain.HARVEST_MAP_STRUCTURE.getAllPlayersInMap(world, pos)) {
                    p.m_213846_((Component)HarvestWords.HARVEST_END.get(new Object[0]).m_130940_(ChatFormatting.GREEN));
                }
            } else {
                for (Player p : HarvestMain.HARVEST_MAP_STRUCTURE.getAllPlayersInMap(world, pos)) {
                    int secleft = this.ticksLeft / 20;
                    HarvestMapData.actionBar((ServerPlayer)p, HarvestWords.HARVEST_TIME_REMAINING.get(secleft).m_130940_(ChatFormatting.GREEN));
                }
            }
        }
    }

    public static void actionBar(ServerPlayer p, MutableComponent title) {
        p.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)title));
    }

    public void waveLogicSecond(Level world, BlockPos pos) {
        if (HarvestMain.HARVEST_MAP_STRUCTURE.getAllPlayersInMap(world, pos).isEmpty()) {
            return;
        }
        this.tickSecond(world, pos);
        if (this.ticksLeft < 1) {
            return;
        }
        List<LivingEntity> list = this.getAllLivingMobs(world, pos);
        if (list.size() < 3) {
            MobList mobs = (MobList)HarvestMain.DUNGEON_MOB_SPAWNS.getPredeterminedRandom(world, pos);
            int toSpawn = 15;
            LibMapData data = LibMapCap.getData((Level)world, (BlockPos)pos);
            if (data != null) {
                float multi = 1.0f + data.relicStats.get((RelicStat)HarvestRelicStats.INSTANCE.MOBS_SPAWNED.get()) / 100.0f;
                toSpawn = (int)((float)toSpawn * multi);
            }
            if (toSpawn > this.mobsLeft) {
                toSpawn = this.mobsLeft;
            }
            List<Direction> dirs = Arrays.asList(Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH);
            for (int i = 0; i < toSpawn; ++i) {
                MobEntry mob = (MobEntry)RandomUtils.weightedRandom((Collection)mobs.mobs);
                this.spawnMob(world, pos.m_121955_(((Direction)RandomUtils.randomFromList(dirs)).m_122436_().m_142393_(2)), mob.getType());
            }
        }
    }

    public void spawnMob(Level world, BlockPos pos, EntityType type) {
        --this.mobsLeft;
        LivingEntity en = (LivingEntity)type.m_20615_(world);
        en.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        if (en instanceof Mob) {
            Mob mob = (Mob)en;
            mob.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(pos), MobSpawnType.COMMAND, (SpawnGroupData)null, (CompoundTag)null);
        }
        world.m_7967_((Entity)en);
        HarvestEntityCap.get((LivingEntity)en).data.isHarvestSpawn = true;
    }
}

