/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.components.LibMapDataSaver;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.utils.LoadSave;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibMapCap
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public Level world;
    public static final ResourceLocation RESOURCE = new ResourceLocation("library_of_exile", "world_data");
    public static Capability<LibMapCap> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<LibMapCap>(){});
    final transient LazyOptional<LibMapCap> supp = LazyOptional.of(() -> this);
    public LibMapDataSaver data = new LibMapDataSaver();

    public LibMapCap(Level world) {
        this.world = world;
    }

    public static LibMapCap get(Level level) {
        return (LibMapCap)level.m_7654_().m_129783_().getCapability(INSTANCE).orElse((Object)new LibMapCap(level));
    }

    public static LibMapData getData(Level level, BlockPos pos) {
        ExileEvents.GrabLibMapData event = new ExileEvents.GrabLibMapData(level, pos);
        ExileEvents.GRAB_LIB_MAP_DATA.callEvents(event);
        if (event.data == null) {
            return new LibMapData();
        }
        return event.data;
    }

    public static Optional<LibMapData> ifData(Level level, BlockPos pos) {
        LibMapData data = LibMapCap.getData(level, pos);
        return data != null ? Optional.of(data) : Optional.empty();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        try {
            nbt.m_128359_("data", IAutoGson.GSON.toJson((Object)this.data));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        try {
            this.data = LoadSave.loadOrBlank(LibMapDataSaver.class, new LibMapDataSaver(), nbt, "data", new LibMapDataSaver());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

