/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.components;

import com.robertx22.library_of_exile.components.DelayedTeleportData;
import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.dimension.teleport.SavedPlayerMapTeleports;
import com.robertx22.library_of_exile.utils.LoadSave;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerDataCapability
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("library_of_exile", "player");
    public static Capability<PlayerDataCapability> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerDataCapability>(){});
    final transient LazyOptional<PlayerDataCapability> supp = LazyOptional.of(() -> this);
    private static final String MAP_TPS = "map_tps";
    transient Player player;
    public SavedPlayerMapTeleports mapTeleports = new SavedPlayerMapTeleports();
    public DelayedTeleportData delayedTeleportData = null;

    public static PlayerDataCapability get(Player p) {
        return (PlayerDataCapability)p.getCapability(INSTANCE).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public PlayerDataCapability(Player player) {
        this.player = player;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        try {
            if (this.mapTeleports != null) {
                LoadSave.Save(this.mapTeleports, nbt, MAP_TPS);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        try {
            this.mapTeleports = LoadSave.Load(SavedPlayerMapTeleports.class, new SavedPlayerMapTeleports(), nbt, MAP_TPS);
            if (this.mapTeleports == null) {
                this.mapTeleports = new SavedPlayerMapTeleports();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void syncToClient(Player player) {
    }

    @Override
    public String getCapIdForSyncing() {
        return "player_data";
    }
}

