/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.config.map_dimension;

import com.robertx22.library_of_exile.components.BlockData;
import com.robertx22.library_of_exile.components.LibChunkCap;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.config.map_dimension.ChunkProcessType;
import com.robertx22.library_of_exile.config.map_dimension.MapDimensionConfig;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.map_data_block.MapBlockCtx;
import com.robertx22.library_of_exile.database.map_data_block.MapDataBlock;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ExileLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;

public class ProcessMapChunks {
    static List<ChunkPos> getChunksInRadius(Player p, int terrain) {
        ChunkPos start = p.m_146902_();
        ArrayList<ChunkPos> all = new ArrayList<ChunkPos>();
        all.add(start);
        for (int x = -terrain; x < terrain; ++x) {
            for (int z = -terrain; z < terrain; ++z) {
                all.add(new ChunkPos(start.f_45578_ + x, start.f_45579_ + z));
            }
        }
        return all;
    }

    public static void process(Player p, MapDimensionInfo info, MapDimensionConfig config, ChunkProcessType type) {
        LevelChunk chunk;
        LevelChunk c;
        List<ChunkPos> processChunks = ProcessMapChunks.getChunksInRadius(p, (Integer)config.CHUNK_PROCESS_RADIUS.get());
        List<ChunkPos> spawnChunks = ProcessMapChunks.getChunksInRadius(p, (Integer)config.CHUNK_SPAWN_RADIUS.get());
        Level level = p.m_9236_();
        for (ChunkPos cpos : processChunks) {
            if (!level.m_7232_(cpos.f_45578_, cpos.f_45579_) || !((c = level.m_6325_(cpos.f_45578_, cpos.f_45579_)) instanceof LevelChunk)) continue;
            chunk = c;
            LibChunkCap cap = (LibChunkCap)chunk.getCapability(LibChunkCap.INSTANCE).orElse((Object)new LibChunkCap(chunk));
            if (cap.mapGenData.generatedData(info.structure)) continue;
            cap.mapGenData.setGeneratedData(info.structure);
            ProcessMapChunks.generateData(level, chunk);
            ExileEvents.PROCESS_CHUNK_DATA.callEvents(new ExileEvents.OnProcessChunkData(p, info.structure, cpos));
        }
        for (ChunkPos cpos : spawnChunks) {
            if (!level.m_7232_(cpos.f_45578_, cpos.f_45579_) || !((c = level.m_6325_(cpos.f_45578_, cpos.f_45579_)) instanceof LevelChunk)) continue;
            chunk = c;
            ProcessMapChunks.spawnDataFromChunk(level, chunk, type);
        }
    }

    public static void spawnDataFromChunk(Level level, LevelChunk chunk, ChunkProcessType type) {
        CompoundTag data = new CompoundTag();
        chunk.getCapability(LibChunkCap.INSTANCE).ifPresent(x -> {
            if (!x.mapGenData.mapBlocks.isEmpty()) {
                for (BlockData block : x.mapGenData.mapBlocks.getOrDefault((Object)type, Arrays.asList(new BlockData[0]))) {
                    ProcessMapChunks.generateSingleData(level, chunk, type, block.getPos(), data, block.data);
                }
            }
            x.mapGenData.mapBlocks.put(type, new ArrayList());
        });
    }

    public static void generateData(Level level, LevelChunk chunk) {
        CompoundTag nbt = new CompoundTag();
        chunk.getCapability(LibChunkCap.INSTANCE).ifPresent(x -> {
            for (BlockPos tilePos : chunk.m_5928_()) {
                BlockEntity tile = level.m_7702_(tilePos);
                String text = ProcessMapChunks.getDataString(tile);
                if (text.isEmpty()) continue;
                ChunkProcessType type = ChunkProcessType.NORMAL;
                Optional<MapDataBlock> be = LibDatabase.MapDataBlocks().getList().stream().filter(e -> e.matches(text, tilePos, level, nbt)).findFirst();
                if (be.isPresent()) {
                    type = be.get().process_on;
                }
                if (!x.mapGenData.mapBlocks.containsKey((Object)type)) {
                    x.mapGenData.mapBlocks.put(type, new ArrayList());
                }
                x.mapGenData.mapBlocks.get((Object)type).add(new BlockData(tilePos.m_121878_(), text));
                level.m_7471_(tilePos, false);
            }
        });
    }

    public static void generateSingleData(Level level, LevelChunk chunk, ChunkProcessType type, BlockPos tilePos, CompoundTag data, String text) {
        if (!text.isEmpty()) {
            boolean any = false;
            boolean skip = false;
            LibMapData libdata = LibMapCap.getData(level, tilePos);
            MapBlockCtx ctx = new MapBlockCtx();
            ctx.libMapData = libdata;
            for (MapDataBlock processor : LibDatabase.MapDataBlocks().getList()) {
                if (processor.matches(text, tilePos, level, data) && processor.process_on != type) {
                    skip = true;
                    break;
                }
                boolean did = processor.process(text, tilePos, level, data, ctx);
                if (!did) continue;
                any = true;
            }
            if (!skip) {
                if (any) {
                    if (level.m_8055_(tilePos).m_60734_() != Blocks.f_50677_ && level.m_8055_(tilePos).m_60734_() == Blocks.f_50272_) {
                        // empty if block
                    }
                } else {
                    MapDimensionInfo info;
                    boolean oldComplex;
                    level.m_7471_(tilePos, false);
                    boolean bl = oldComplex = text.contains("spawn") && text.contains(";");
                    if (!oldComplex) {
                        ExileLog.get().warn("Data block with id: " + text + " matched no processors! " + tilePos.toString(), new Object[0]);
                    }
                    if ((info = MapDimensions.getInfo(level)) != null) {
                        String id = (String)info.config.DEFAULT_DATA_BLOCK.get();
                        LibDatabase.MapDataBlocks().get(id).process(id, tilePos, level, data, ctx);
                    }
                }
            }
        }
    }

    public static String getDataString(BlockEntity be) {
        if (be instanceof StructureBlockEntity) {
            StructureBlockEntity struc = (StructureBlockEntity)be;
            CompoundTag nbt = struc.m_187482_();
            return nbt.m_128461_("metadata");
        }
        if (be instanceof CommandBlockEntity) {
            CommandBlockEntity cb = (CommandBlockEntity)be;
            return cb.m_59141_().m_45438_();
        }
        return "";
    }
}

