/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.database.relic.stat;

import com.robertx22.library_of_exile.custom_ser.CustomSerializer;
import com.robertx22.library_of_exile.custom_ser.GsonCustomSer;
import com.robertx22.library_of_exile.database.affix.base.AffixTranslation;
import com.robertx22.library_of_exile.database.init.ExileCustomSers;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.relic.stat.EmptyRelicStat;
import com.robertx22.library_of_exile.localization.ITranslated;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public abstract class RelicStat
implements JsonExileRegistry<RelicStat>,
GsonCustomSer<RelicStat>,
ITranslated {
    public static EmptyRelicStat SERIALIZER = new EmptyRelicStat("empty");
    public String id;
    public String serializer;
    public boolean is_percent = true;
    public float min = 0.0f;
    public float max = 1000.0f;
    public float base = 0.0f;

    public RelicStat(String ser, String id) {
        this.id = id;
        this.serializer = ser;
    }

    public void setInfinitelyScalingPercentStat() {
        this.is_percent = true;
        this.min = 0.0f;
        this.max = 1000.0f;
        this.base = 0.0f;
    }

    public void set100PercentStat() {
        this.is_percent = true;
        this.min = 0.0f;
        this.max = 100.0f;
        this.base = 0.0f;
    }

    public float cap(float val) {
        return Mth.m_14036_((float)val, (float)this.min, (float)this.max);
    }

    @Override
    public void addToSerializables(ExileRegistrationInfo info) {
        this.getSerMap().register(this);
        Database.getRegistry(this.getExileRegistryType()).addSerializable(this, info);
    }

    @Override
    public CustomSerializer<RelicStat> getSerMap() {
        return ExileCustomSers.ATLAS_STAT;
    }

    @Override
    public String getSer() {
        return this.serializer;
    }

    public MutableComponent getTooltip(float value) {
        String num = RelicStat.formatNumber(value);
        String perc = this.is_percent ? "%" : "";
        String plusminus = value > 0.0f ? "+" : "";
        ChatFormatting color = ChatFormatting.YELLOW;
        String finalNum = plusminus + num + perc;
        MutableComponent numcomp = Component.m_237113_((String)finalNum).m_130940_(color);
        return this.getTranslation(TranslationType.NAME).getTranslatedName(numcomp).m_130940_(ChatFormatting.GREEN);
    }

    static String formatNumber(float num) {
        if (num < 10.0f) {
            return AffixTranslation.DECIMAL_FORMAT.format(num);
        }
        return "" + (int)num;
    }

    @Override
    public ExileRegistryType getExileRegistryType() {
        return LibDatabase.RELIC_STAT;
    }

    @Override
    public String GUID() {
        return this.id;
    }

    @Override
    public int Weight() {
        return 1000;
    }
}

