/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.packets.particles;

import com.robertx22.library_of_exile.packets.particles.ParticleEnum;
import com.robertx22.library_of_exile.utils.RGB;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3d;

public class ParticlePacketData {
    public double x = 1.0;
    public double y = 1.0;
    public double z = 1.0;
    public boolean isVecPos = false;
    public double mx = 1.0;
    public double my = 1.0;
    public double mz = 1.0;
    public ParticleEnum type;
    public float radius = 1.0f;
    public int amount = 1;
    public RGB color;
    public String particleID;

    private ParticlePacketData() {
    }

    public static ParticlePacketData empty() {
        return new ParticlePacketData();
    }

    public <T extends ParticleOptions> ParticleOptions getParticleType() {
        ParticleType<?> particleType = VanillaUTIL.REGISTRY.particles().get(new ResourceLocation(this.particleID));
        if (particleType instanceof ParticleOptions) {
            return (ParticleOptions)particleType;
        }
        return ParticleTypes.f_123797_;
    }

    public ParticlePacketData motion(Vector3d v) {
        this.mx = v.x;
        this.my = v.y;
        this.mz = v.z;
        return this;
    }

    public ParticlePacketData type(ParticleType type) {
        this.particleID = VanillaUTIL.REGISTRY.particles().getKey(type).toString();
        return this;
    }

    public ParticlePacketData amount(int num) {
        this.amount = num;
        return this;
    }

    public ParticlePacketData radius(double rad) {
        this.radius = (float)rad;
        return this;
    }

    public ParticlePacketData radius(float rad) {
        this.radius = rad;
        return this;
    }

    public ParticlePacketData color(RGB color) {
        this.color = color;
        return this;
    }

    public Vector3d getPos() {
        return new Vector3d(this.x, this.y, this.z);
    }

    public BlockPos getBlockPos() {
        return new BlockPos((int)this.x, (int)this.y, (int)this.z);
    }

    public ParticlePacketData(Vector3d pos, ParticleEnum type) {
        this.x = pos.x();
        this.y = pos.y();
        this.z = pos.z();
        this.isVecPos = true;
        this.type = type;
    }

    public ParticlePacketData(BlockPos pos, ParticleEnum type) {
        this.x = pos.m_123341_();
        this.y = pos.m_123342_();
        this.z = pos.m_123343_();
        this.type = type;
    }
}

