/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.tags;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.tags.ExileTagRequirementEntry;
import com.robertx22.library_of_exile.tags.ITaggable;
import com.robertx22.library_of_exile.tags.tag_types.RegistryTag;
import com.robertx22.library_of_exile.util.ExplainedResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;

public class ExileTagRequirement<TAGGABLE extends ExileRegistry<?> & ITaggable<?>> {
    public List<ExileTagRequirementEntry> checks = new ArrayList<ExileTagRequirementEntry>();

    public ExplainedResult matches(TAGGABLE obj) {
        for (ExileTagRequirementEntry entry : this.checks) {
            if (entry.matches(((ITaggable)obj).getTags().tags)) continue;
            return ExplainedResult.failure((Component)Component.m_237113_((String)("Tag check of " + obj.getRegistryIdPlusGuid() + ": failed for: " + entry.toString())));
        }
        return ExplainedResult.success();
    }

    public Builder createBuilder() {
        return new Builder();
    }

    public class Builder {
        List<String> must = new ArrayList<String>();
        List<String> any = new ArrayList<String>();
        List<String> not = new ArrayList<String>();
        boolean addedMust = false;
        boolean addedany = false;
        boolean addednot = false;

        public Builder mustHave(String ... tags) {
            this.must.addAll(Arrays.asList(tags));
            this.addedMust = true;
            return this;
        }

        public Builder includes(String ... tags) {
            this.any.addAll(Arrays.asList(tags));
            this.addedany = true;
            return this;
        }

        public Builder excludes(String ... tags) {
            this.not.addAll(Arrays.asList(tags));
            this.addednot = true;
            return this;
        }

        public Builder mustHave(RegistryTag<TAGGABLE> ... tags) {
            for (RegistryTag tag : tags) {
                this.must.add(tag.GUID());
            }
            this.addedMust = true;
            return this;
        }

        public Builder includes(RegistryTag<TAGGABLE> ... tags) {
            for (RegistryTag tag : tags) {
                this.any.add(tag.GUID());
            }
            this.addedany = true;
            return this;
        }

        public Builder excludes(RegistryTag<TAGGABLE> ... tags) {
            for (RegistryTag tag : tags) {
                this.not.add(tag.GUID());
            }
            this.addednot = true;
            return this;
        }

        public ExileTagRequirement<TAGGABLE> build() {
            ExileTagRequirement r = new ExileTagRequirement();
            if (this.addedMust) {
                r.checks.add(new ExileTagRequirementEntry(ExileTagRequirementEntry.TagRequirementCheck.HAS_ALL, this.must));
            }
            if (this.addedany) {
                r.checks.add(new ExileTagRequirementEntry(ExileTagRequirementEntry.TagRequirementCheck.HAS_ANY, this.any));
            }
            if (this.addednot) {
                r.checks.add(new ExileTagRequirementEntry(ExileTagRequirementEntry.TagRequirementCheck.HAS_NONE, this.not));
            }
            return r;
        }
    }
}

