/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.toomanytrims.entity;

import net.mcreator.toomanytrims.procedures.TrimmedGolemActivateDisplayProcedure;
import net.mcreator.toomanytrims.procedures.TrimmedGolemAttackAnimDisplayProcedure;
import net.mcreator.toomanytrims.procedures.TrimmedGolemDisplayConditionProcedure;
import net.mcreator.toomanytrims.procedures.TrimmedGolemInactiveDisplayProcedure;
import net.mcreator.toomanytrims.procedures.TrimmedGolemWanderAttackProcedureProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.fluids.FluidType;

public class TrimmedGolemEntity
extends Monster {
    public static final EntityDataAccessor<Integer> DATA_is_active = SynchedEntityData.defineId(TrimmedGolemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public final AnimationState animationState0 = new AnimationState();
    public final AnimationState animationState2 = new AnimationState();
    public final AnimationState animationState3 = new AnimationState();
    public final AnimationState animationState4 = new AnimationState();

    public TrimmedGolemEntity(EntityType<TrimmedGolemEntity> type, Level world) {
        super(type, world);
        this.xpReward = 20;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_is_active, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 8.41 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = TrimmedGolemEntity.this.getX();
                double y = TrimmedGolemEntity.this.getY();
                double z = TrimmedGolemEntity.this.getZ();
                TrimmedGolemEntity entity = TrimmedGolemEntity.this;
                Level world = TrimmedGolemEntity.this.level();
                return super.canUse() && TrimmedGolemWanderAttackProcedureProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TrimmedGolemEntity.this.getX();
                double y = TrimmedGolemEntity.this.getY();
                double z = TrimmedGolemEntity.this.getZ();
                TrimmedGolemEntity entity = TrimmedGolemEntity.this;
                Level world = TrimmedGolemEntity.this.level();
                return super.canContinueToUse() && TrimmedGolemWanderAttackProcedureProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false){

            public boolean canUse() {
                double x = TrimmedGolemEntity.this.getX();
                double y = TrimmedGolemEntity.this.getY();
                double z = TrimmedGolemEntity.this.getZ();
                TrimmedGolemEntity entity = TrimmedGolemEntity.this;
                Level world = TrimmedGolemEntity.this.level();
                return super.canUse() && TrimmedGolemWanderAttackProcedureProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TrimmedGolemEntity.this.getX();
                double y = TrimmedGolemEntity.this.getY();
                double z = TrimmedGolemEntity.this.getZ();
                TrimmedGolemEntity entity = TrimmedGolemEntity.this;
                Level world = TrimmedGolemEntity.this.level();
                return super.canContinueToUse() && TrimmedGolemWanderAttackProcedureProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = TrimmedGolemEntity.this.getX();
                double y = TrimmedGolemEntity.this.getY();
                double z = TrimmedGolemEntity.this.getZ();
                TrimmedGolemEntity entity = TrimmedGolemEntity.this;
                Level world = TrimmedGolemEntity.this.level();
                return super.canUse() && TrimmedGolemWanderAttackProcedureProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = TrimmedGolemEntity.this.getX();
                double y = TrimmedGolemEntity.this.getY();
                double z = TrimmedGolemEntity.this.getZ();
                TrimmedGolemEntity entity = TrimmedGolemEntity.this;
                Level world = TrimmedGolemEntity.this.level();
                return super.canContinueToUse() && TrimmedGolemWanderAttackProcedureProcedure.execute((Entity)entity);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void playStepSound(BlockPos pos, BlockState blockIn) {
        this.playSound((SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"too_many_trims:entity.trimmed_golem.step")), 0.15f, 1.0f);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"too_many_trims:entity.trimmed_golem.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"too_many_trims:entity.trimmed_golem.death"));
    }

    public boolean hurtServer(ServerLevel level, DamageSource damagesource, float amount) {
        if (damagesource.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (damagesource.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (damagesource.is(DamageTypes.FALL)) {
            return false;
        }
        if (damagesource.is(DamageTypes.DROWN)) {
            return false;
        }
        if (damagesource.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (damagesource.is(DamageTypes.EXPLOSION) || damagesource.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        return super.hurtServer(level, damagesource, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Datais_active", ((Integer)this.entityData.get(DATA_is_active)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Datais_active")) {
            this.entityData.set(DATA_is_active, (Object)compound.getInt("Datais_active"));
        }
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide()) {
            this.animationState0.animateWhen(TrimmedGolemDisplayConditionProcedure.execute((Entity)this), this.tickCount);
            this.animationState2.animateWhen(TrimmedGolemAttackAnimDisplayProcedure.execute((Entity)this), this.tickCount);
            this.animationState3.animateWhen(TrimmedGolemInactiveDisplayProcedure.execute((Entity)this), this.tickCount);
            this.animationState4.animateWhen(TrimmedGolemActivateDisplayProcedure.execute((Entity)this), this.tickCount);
        }
    }

    public boolean canDrownInFluidType(FluidType type) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TrimmedGolemEntity entity = this;
        return false;
    }

    public boolean isPushedByFluid() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        TrimmedGolemEntity entity = this;
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    protected void doPush(Entity entityIn) {
    }

    protected void pushEntities() {
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.2);
        builder = builder.add(Attributes.MAX_HEALTH, 150.0);
        builder = builder.add(Attributes.ARMOR, 10.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 12.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 1.2);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 2.0);
        return builder;
    }
}

