/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import joshie.durabilitydecay.DurabilityDecay;
import joshie.durabilitydecay.config.ConfigManager;

public class ConfigFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "durability_decay.json";
    private static File configFile;

    public static void init(Path configDir) {
        configFile = configDir.resolve(CONFIG_FILE_NAME).toFile();
        if (!configFile.exists()) {
            ConfigFileManager.createDefaultConfig();
        }
        ConfigFileManager.loadConfig();
    }

    private static void createDefaultConfig() {
        try {
            configFile.getParentFile().mkdirs();
            String defaultConfig = "{\n  \"default\": {\n    \"base\": 0,\n    \"fraction\": 0.25,\n    \"max\": 0.5,\n    \"min\": 0,\n    \"mending_impacts_block\": false,\n    \"allow_decay_restoration\": true,\n    \"restoration_min_threshold\": 0.40,\n    \"restoration_base\": 0.12,\n    \"restoration_scaling\": 0.5,\n    \"restoration_min_amount\": 0.03,\n    \"restoration_tier_bonus\": 0.02,\n    \"restoration_work_penalty\": 0.8,\n    \"restoration_max_cap\": 0.95\n  },\n  \"items\": {\n    \"minecraft:diamond_sword\": {\n      \"base\": 0.02,\n      \"fraction\": 0.3,\n      \"max\": 0.6,\n      \"min\": 0,\n      \"mending_impacts_block\": false\n    },\n    \"minecraft:diamond_pickaxe\": {\n      \"base\": 0.02,\n      \"fraction\": 0.3,\n      \"max\": 0.6,\n      \"min\": 0,\n      \"mending_impacts_block\": false\n    },\n    \"minecraft:diamond_axe\": {\n      \"base\": 0.02,\n      \"fraction\": 0.3,\n      \"max\": 0.6,\n      \"min\": 0,\n      \"mending_impacts_block\": false\n    },\n    \"minecraft:netherite_sword\": {\n      \"base\": 0.01,\n      \"fraction\": 0.2,\n      \"max\": 0.5,\n      \"min\": 0,\n      \"mending_impacts_block\": false\n    },\n    \"minecraft:netherite_pickaxe\": {\n      \"base\": 0.01,\n      \"fraction\": 0.2,\n      \"max\": 0.5,\n      \"min\": 0,\n      \"mending_impacts_block\": false\n    },\n    \"#minecraft:armor\": {\n      \"base\": 0.03,\n      \"fraction\": 0.35,\n      \"max\": 0.7,\n      \"min\": 0,\n      \"mending_impacts_block\": false\n    }\n  }\n}\n";
            try (FileWriter writer = new FileWriter(configFile);){
                writer.write(defaultConfig);
            }
            DurabilityDecay.LOGGER.info("Created default config file at: {}", (Object)configFile.getAbsolutePath());
        }
        catch (IOException e) {
            DurabilityDecay.LOGGER.error("Failed to create default config file", (Throwable)e);
        }
    }

    public static void loadConfig() {
        if (!configFile.exists()) {
            DurabilityDecay.LOGGER.warn("Config file not found, using defaults");
            return;
        }
        try (FileReader reader = new FileReader(configFile);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            ConfigManager.getInstance().getConfig().loadFromJson(json.toString());
            DurabilityDecay.LOGGER.info("Loaded config from: {}", (Object)configFile.getAbsolutePath());
        }
        catch (Exception e) {
            DurabilityDecay.LOGGER.error("Failed to load config file", (Throwable)e);
        }
    }

    public static void reloadConfig() {
        DurabilityDecay.LOGGER.info("Reloading config...");
        ConfigFileManager.loadConfig();
    }

    public static File getConfigFile() {
        return configFile;
    }
}

