/*
 * Decompiled with CFR 0.152.
 */
package joshie.durabilitydecay.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import joshie.durabilitydecay.DurabilityDecay;
import joshie.durabilitydecay.config.DecayConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;

public class ConfigManager
implements PreparableReloadListener {
    private static final ResourceLocation CONFIG_ID = ResourceLocation.fromNamespaceAndPath((String)"durability_decay", (String)"decay_rules");
    private static ConfigManager INSTANCE;
    private final DecayConfig config = new DecayConfig();

    public ConfigManager() {
        INSTANCE = this;
    }

    public static ConfigManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConfigManager();
        }
        return INSTANCE;
    }

    public DecayConfig getConfig() {
        return this.config;
    }

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier stage, ResourceManager resourceManager, ProfilerFiller preparationsProfiler, ProfilerFiller reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            preparationsProfiler.push("durability_decay_config");
            JsonObject mergedConfig = new JsonObject();
            try {
                ResourceLocation configPath = ResourceLocation.fromNamespaceAndPath((String)"durability_decay", (String)"decay_rules.json");
                for (Resource resource : resourceManager.getResourceStack(configPath)) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(resource.open(), StandardCharsets.UTF_8));){
                        String line;
                        StringBuilder content = new StringBuilder();
                        while ((line = reader.readLine()) != null) {
                            content.append(line);
                        }
                        JsonObject json = JsonParser.parseString((String)content.toString()).getAsJsonObject();
                        this.mergeConfigs(mergedConfig, json);
                        DurabilityDecay.LOGGER.info("Loaded decay config from: {}", (Object)resource.sourcePackId());
                    }
                    catch (Exception e) {
                        DurabilityDecay.LOGGER.error("Failed to read config from resource", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                DurabilityDecay.LOGGER.warn("No decay config found, using defaults");
            }
            preparationsProfiler.pop();
            return mergedConfig;
        }, backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).wait(arg_0))).thenAcceptAsync(mergedConfig -> {
            reloadProfiler.push("durability_decay_config_apply");
            this.config.clear();
            if (mergedConfig != null && !mergedConfig.entrySet().isEmpty()) {
                this.config.loadFromJson(mergedConfig.toString());
            }
            reloadProfiler.pop();
        }, gameExecutor);
    }

    private void mergeConfigs(JsonObject base, JsonObject overlay) {
        for (Map.Entry entry : overlay.entrySet()) {
            base.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }
}

